/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.input;

import android.content.Context;
import android.content.res.Resources;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ListAdapter;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentManager;
import io.adaptivecards.R;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.ChoiceInput;
import io.adaptivecards.objectmodel.ChoiceInputVector;
import io.adaptivecards.objectmodel.ChoiceSetInput;
import io.adaptivecards.objectmodel.ChoiceSetStyle;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.ForegroundColor;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.input.customcontrols.ValidatedAutoCompleteTextView;
import io.adaptivecards.renderer.input.customcontrols.ValidatedCheckBoxLayout;
import io.adaptivecards.renderer.input.customcontrols.ValidatedRadioGroup;
import io.adaptivecards.renderer.input.customcontrols.ValidatedSpinner;
import io.adaptivecards.renderer.input.customcontrols.ValidatedSpinnerLayout;
import io.adaptivecards.renderer.inputhandler.AutoCompleteTextViewHandler;
import io.adaptivecards.renderer.inputhandler.CheckBoxSetInputHandler;
import io.adaptivecards.renderer.inputhandler.ComboBoxInputHandler;
import io.adaptivecards.renderer.inputhandler.IInputHandler;
import io.adaptivecards.renderer.inputhandler.RadioGroupInputHandler;
import io.adaptivecards.renderer.registration.CardRendererRegistration;
import java.util.Arrays;
import java.util.Vector;

public class ChoiceSetInputRenderer
extends BaseCardElementRenderer {
    private static ChoiceSetInputRenderer s_instance = null;

    protected ChoiceSetInputRenderer() {
    }

    public boolean isUsingCustomInputs(Context context) {
        TypedValue isUsingCustomInputs;
        Resources.Theme theme = context.getTheme();
        if (theme.resolveAttribute(R.attr.adaptiveUsingCustomChoiceSetInputs, isUsingCustomInputs = new TypedValue(), true)) {
            return isUsingCustomInputs.data != 0;
        }
        return false;
    }

    public static ChoiceSetInputRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ChoiceSetInputRenderer();
        }
        return s_instance;
    }

    public View renderCheckBoxSet(RenderedAdaptiveCard renderedCard, Context context, ChoiceSetInput choiceSetInput, HostConfig hostConfig, RenderArgs renderArgs) {
        ValidatedCheckBoxLayout checkBoxLayout = new ValidatedCheckBoxLayout(context, ChoiceSetInputRenderer.getColor(hostConfig.GetForegroundColor(ContainerStyle.Default, ForegroundColor.Attention, false)));
        Vector<CheckBox> checkBoxList = new Vector<CheckBox>();
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        long size = choiceInputVector.size();
        String value = choiceSetInput.GetValue();
        Vector<String> defaults = new Vector<String>();
        defaults.addAll(Arrays.asList(value.split(",")));
        final CheckBoxSetInputHandler checkBoxSetInputHandler = new CheckBoxSetInputHandler(choiceSetInput, checkBoxList);
        checkBoxSetInputHandler.setView((View)checkBoxLayout);
        checkBoxLayout.setTag(new TagContent((BaseCardElement)choiceSetInput, checkBoxSetInputHandler));
        int i = 0;
        while ((long)i < size) {
            ChoiceInput choiceInput = choiceInputVector.get(i);
            CheckBox checkBox = new CheckBox(context);
            checkBox.setText((CharSequence)choiceInput.GetTitle());
            if (!choiceSetInput.GetWrap()) {
                checkBox.setMaxLines(1);
                checkBox.setEllipsize(TextUtils.TruncateAt.END);
            }
            if (defaults.contains(choiceInput.GetValue())) {
                checkBox.setChecked(true);
            }
            checkBoxList.add(checkBox);
            checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    CardRendererRegistration.getInstance().notifyInputChange(checkBoxSetInputHandler.getId(), checkBoxSetInputHandler.getInput());
                }
            });
            checkBox.setOnTouchListener(new FocusableChoiceListener<CompoundButton>((CompoundButton)checkBoxList.get(0)));
            checkBoxLayout.addView((View)checkBox);
            ++i;
        }
        renderedCard.registerInputHandler((IInputHandler)checkBoxSetInputHandler, renderArgs.getContainerCardId());
        return checkBoxLayout;
    }

    public View renderRadioGroup(RenderedAdaptiveCard renderedCard, Context context, ChoiceSetInput choiceSetInput, HostConfig hostConfig, RenderArgs renderArgs) {
        ValidatedRadioGroup radioGroup = new ValidatedRadioGroup(context, ChoiceSetInputRenderer.getColor(hostConfig.GetForegroundColor(ContainerStyle.Default, ForegroundColor.Attention, false)));
        final RadioGroupInputHandler radioGroupInputHandler = new RadioGroupInputHandler(choiceSetInput);
        radioGroupInputHandler.setView((View)radioGroup);
        radioGroup.setTag(new TagContent((BaseCardElement)choiceSetInput, radioGroupInputHandler));
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        long size = choiceInputVector.size();
        String value = choiceSetInput.GetValue();
        int i = 0;
        while ((long)i < size) {
            ChoiceInput choiceInput = choiceInputVector.get(i);
            RadioButton radioButton = new RadioButton(context);
            radioButton.setId(i);
            if (!choiceSetInput.GetWrap()) {
                radioButton.setMaxLines(1);
                radioButton.setEllipsize(TextUtils.TruncateAt.END);
            }
            radioButton.setText((CharSequence)choiceInput.GetTitle());
            if (choiceInput.GetValue().equals(value)) {
                radioButton.setChecked(true);
            }
            radioGroup.addView((View)radioButton);
            radioButton.setOnTouchListener(new FocusableChoiceListener<RadioButton>((RadioButton)radioGroup.getChildAt(0)));
            ++i;
        }
        renderedCard.registerInputHandler((IInputHandler)radioGroupInputHandler, renderArgs.getContainerCardId());
        radioGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup group, int checkedId) {
                CardRendererRegistration.getInstance().notifyInputChange(radioGroupInputHandler.getId(), radioGroupInputHandler.getInput());
            }
        });
        return radioGroup;
    }

    public View renderComboBox(RenderedAdaptiveCard renderedCard, Context context, ChoiceSetInput choiceSetInput, HostConfig hostConfig, RenderArgs renderArgs) {
        boolean needsOuterLayout;
        Vector<String> titleList = new Vector<String>();
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        long size = choiceInputVector.size();
        int selection = 0;
        String value = choiceSetInput.GetValue();
        int i = 0;
        while ((long)i < size) {
            ChoiceInput choiceInput = choiceInputVector.get(i);
            titleList.addElement(choiceInput.GetTitle());
            if (choiceInput.GetValue().equals(value)) {
                selection = i;
            }
            ++i;
        }
        boolean hasEmptyDefault = value.isEmpty();
        if (hasEmptyDefault) {
            String placeholder = choiceSetInput.GetPlaceholder();
            if (placeholder.isEmpty()) {
                placeholder = " ";
            }
            titleList.addElement(placeholder);
            selection = (int)size;
        }
        boolean usingCustomInputs = this.isUsingCustomInputs(context);
        ValidatedSpinner spinner = new ValidatedSpinner(context, usingCustomInputs);
        final ComboBoxInputHandler comboBoxInputHandler = new ComboBoxInputHandler(choiceSetInput);
        boolean isRequired = choiceSetInput.GetIsRequired();
        ValidatedSpinnerLayout inputLayout = null;
        boolean bl = needsOuterLayout = isRequired && !usingCustomInputs;
        if (needsOuterLayout) {
            inputLayout = new ValidatedSpinnerLayout(context, ChoiceSetInputRenderer.getColor(hostConfig.GetForegroundColor(ContainerStyle.Default, ForegroundColor.Attention, false)));
            inputLayout.setTag(new TagContent((BaseCardElement)choiceSetInput, comboBoxInputHandler));
            comboBoxInputHandler.setView((View)inputLayout);
        } else {
            spinner.setTag(new TagContent((BaseCardElement)choiceSetInput, comboBoxInputHandler));
            comboBoxInputHandler.setView((View)spinner);
        }
        renderedCard.registerInputHandler((IInputHandler)comboBoxInputHandler, renderArgs.getContainerCardId());
        class WrappedTextSpinnerAdapter
        extends TextSpinnerAdapter {
            WrappedTextSpinnerAdapter(Context context, int resource, Vector<String> items, boolean hasEmptyDefault) {
                class TextSpinnerAdapter
                extends ArrayAdapter<String> {
                    private int m_itemCount;
                    private boolean m_hasEmptyDefault;

                    TextSpinnerAdapter(Context context, int resource, Vector<String> items, boolean hasEmptyDefault) {
                        super(context, resource, items);
                        this.m_itemCount = 0;
                        this.m_hasEmptyDefault = false;
                        this.m_hasEmptyDefault = hasEmptyDefault;
                        this.m_itemCount = items.size();
                    }

                    public int getCount() {
                        if (this.m_hasEmptyDefault) {
                            return this.m_itemCount - 1;
                        }
                        return this.m_itemCount;
                    }
                }
                super(context, resource, items, hasEmptyDefault);
            }

            @NonNull
            public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
                View view = super.getView(position, convertView, parent);
                TextView txtView = (TextView)view.findViewById(16908308);
                txtView.setSingleLine(false);
                return view;
            }
        }
        TextSpinnerAdapter spinnerArrayAdapter = choiceSetInput.GetWrap() ? new WrappedTextSpinnerAdapter(context, 17367048, titleList, hasEmptyDefault) : new TextSpinnerAdapter(context, 17367048, titleList, hasEmptyDefault);
        spinnerArrayAdapter.setDropDownViewResource(0x1090009);
        spinner.setAdapter((SpinnerAdapter)spinnerArrayAdapter);
        spinner.setSelection(selection);
        spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                CardRendererRegistration.getInstance().notifyInputChange(comboBoxInputHandler.getId(), comboBoxInputHandler.getInput());
            }

            public void onNothingSelected(AdapterView<?> parent) {
                CardRendererRegistration.getInstance().notifyInputChange(comboBoxInputHandler.getId(), comboBoxInputHandler.getInput());
            }
        });
        spinner.setFocusable(true);
        if (needsOuterLayout) {
            inputLayout.addView((View)spinner);
            return inputLayout;
        }
        return spinner;
    }

    public View renderFilteredComboBox(RenderedAdaptiveCard renderedCard, Context context, ChoiceSetInput choiceSetInput, HostConfig hostConfig, RenderArgs renderArgs) {
        boolean needsOuterLayout;
        Vector<String> titleList = new Vector<String>();
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        long size = choiceInputVector.size();
        int valueIndex = -1;
        String value = choiceSetInput.GetValue();
        int i = 0;
        while ((long)i < size) {
            ChoiceInput choiceInput = choiceInputVector.get(i);
            titleList.addElement(choiceInput.GetTitle());
            if (choiceInput.GetValue().equals(value)) {
                valueIndex = i;
            }
            ++i;
        }
        boolean usingCustomInputs = this.isUsingCustomInputs(context);
        ValidatedAutoCompleteTextView autoCompleteTextView = new ValidatedAutoCompleteTextView(context, usingCustomInputs);
        autoCompleteTextView.setThreshold(0);
        final AutoCompleteTextViewHandler autoCompleteTextInputHandler = new AutoCompleteTextViewHandler(choiceSetInput);
        boolean isRequired = choiceSetInput.GetIsRequired();
        ValidatedSpinnerLayout inputLayout = null;
        boolean bl = needsOuterLayout = !usingCustomInputs;
        if (needsOuterLayout) {
            inputLayout = new ValidatedSpinnerLayout(context, ChoiceSetInputRenderer.getColor(hostConfig.GetForegroundColor(ContainerStyle.Default, ForegroundColor.Attention, false)));
            inputLayout.setTag(new TagContent((BaseCardElement)choiceSetInput, autoCompleteTextInputHandler));
            autoCompleteTextInputHandler.setView((View)inputLayout);
        } else {
            autoCompleteTextView.setTag(new TagContent((BaseCardElement)choiceSetInput, autoCompleteTextInputHandler));
            autoCompleteTextInputHandler.setView((View)autoCompleteTextView);
        }
        renderedCard.registerInputHandler((IInputHandler)autoCompleteTextInputHandler, renderArgs.getContainerCardId());
        class FilteredChoiceSetAdapter
        extends ArrayAdapter<String> {
            boolean m_mustWrap;

            FilteredChoiceSetAdapter(Context context, int resource, Vector<String> items, boolean mustWrap) {
                super(context, resource, items);
                this.m_mustWrap = false;
                this.m_mustWrap = mustWrap;
            }

            @NonNull
            public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
                View view = super.getView(position, convertView, parent);
                TextView txtView = (TextView)view.findViewById(16908308);
                if (this.m_mustWrap) {
                    txtView.setSingleLine(false);
                }
                return view;
            }
        }
        autoCompleteTextView.setAdapter((ListAdapter)new FilteredChoiceSetAdapter(context, 0x1090011, titleList, choiceSetInput.GetWrap()));
        autoCompleteTextView.setFocusable(true);
        if (valueIndex != -1) {
            autoCompleteTextView.setText(titleList.get(valueIndex));
        }
        autoCompleteTextView.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                CardRendererRegistration.getInstance().notifyInputChange(autoCompleteTextInputHandler.getId(), autoCompleteTextInputHandler.getInput());
            }

            public void onNothingSelected(AdapterView<?> parent) {
                CardRendererRegistration.getInstance().notifyInputChange(autoCompleteTextInputHandler.getId(), autoCompleteTextInputHandler.getInput());
            }
        });
        if (needsOuterLayout) {
            inputLayout.addView((View)autoCompleteTextView);
            return inputLayout;
        }
        return autoCompleteTextView;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) throws Exception {
        if (!hostConfig.GetSupportsInteractivity()) {
            renderedCard.addWarning(new AdaptiveWarning(3, "Input.ChoiceSet is not allowed"));
            return null;
        }
        ChoiceSetInput choiceSetInput = Util.castTo(baseCardElement, ChoiceSetInput.class);
        View inputView = null;
        if (choiceSetInput.GetIsMultiSelect()) {
            inputView = this.renderCheckBoxSet(renderedCard, context, choiceSetInput, hostConfig, renderArgs);
        } else if (choiceSetInput.GetChoiceSetStyle() == ChoiceSetStyle.Expanded) {
            inputView = this.renderRadioGroup(renderedCard, context, choiceSetInput, hostConfig, renderArgs);
        } else if (choiceSetInput.GetChoiceSetStyle() == ChoiceSetStyle.Compact) {
            inputView = this.renderComboBox(renderedCard, context, choiceSetInput, hostConfig, renderArgs);
        } else if (choiceSetInput.GetChoiceSetStyle() == ChoiceSetStyle.Filtered) {
            inputView = this.renderFilteredComboBox(renderedCard, context, choiceSetInput, hostConfig, renderArgs);
        } else {
            throw new IllegalArgumentException("ChoiceSet Input, " + choiceSetInput.GetId() + ", contains invalid style, " + choiceSetInput.GetChoiceSetStyle().toString() + ".");
        }
        viewGroup.addView(inputView);
        return inputView;
    }

    public static class FocusableChoiceListener<T extends CompoundButton>
    implements View.OnTouchListener {
        private T m_firstView;

        public FocusableChoiceListener(T firstView) {
            this.m_firstView = firstView;
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            if (motionEvent.getAction() == 1) {
                this.m_firstView.setFocusableInTouchMode(false);
                this.m_firstView.clearFocus();
                CompoundButton clickableElement = (CompoundButton)view;
                if (clickableElement instanceof CheckBox) {
                    clickableElement.setChecked(!clickableElement.isChecked());
                } else {
                    clickableElement.setChecked(true);
                }
            }
            return true;
        }
    }
}

