/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.input.customcontrols;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.util.TypedValue;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import io.adaptivecards.R;
import io.adaptivecards.renderer.input.customcontrols.IValidatedInputView;

@SuppressLint(value={"AppCompatCustomView"})
public class ValidatedEditText
extends EditText
implements IValidatedInputView {
    private boolean m_isInvalid = false;
    private boolean m_isUsingCustomInputs = false;
    private int m_errorColor = 0;
    private static final int[] STATE_INPUT_INVALID = new int[]{R.attr.state_error};

    private ValidatedEditText(Context context) {
        super(context);
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.m_isInvalid = false;
        this.verifyIfUsingCustomInputs(context);
    }

    public ValidatedEditText(Context context, int errorColor) {
        this(context);
        this.m_errorColor = errorColor;
    }

    public void verifyIfUsingCustomInputs(Context context) {
        TypedValue isUsingCustomInputs;
        Resources.Theme theme = context.getTheme();
        this.m_isUsingCustomInputs = theme.resolveAttribute(R.attr.adaptiveUsingCustomTextInputs, isUsingCustomInputs = new TypedValue(), true) ? isUsingCustomInputs.data != 0 : false;
    }

    @Override
    public void setValidationResult(boolean isValid) {
        if (this.m_isUsingCustomInputs) {
            this.setInputInvalid(!isValid);
        } else {
            if (isValid) {
                this.getBackground().setColorFilter(null);
            } else {
                this.getBackground().setColorFilter(this.m_errorColor, PorterDuff.Mode.SRC_ATOP);
            }
            this.invalidate();
        }
    }

    public void setInputInvalid(boolean isInvalid) {
        this.m_isInvalid = isInvalid;
        this.refreshDrawableState();
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.m_isInvalid) {
            ValidatedEditText.mergeDrawableStates((int[])drawableState, (int[])STATE_INPUT_INVALID);
        }
        return drawableState;
    }
}

