/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.inputhandler;

import android.view.View;
import io.adaptivecards.objectmodel.BaseInputElement;
import io.adaptivecards.renderer.inputhandler.IInputHandler;
import io.adaptivecards.renderer.layout.StretchableInputLayout;

public abstract class BaseInputHandler
implements IInputHandler {
    protected BaseInputElement m_baseInputElement = null;
    protected View m_view = null;
    private StretchableInputLayout m_inputLayout = null;

    public BaseInputHandler(BaseInputElement baseInputElement) {
        this.m_baseInputElement = baseInputElement;
    }

    public void setView(View view) {
        this.m_view = view;
    }

    public BaseInputElement getBaseInputElement() {
        return this.m_baseInputElement;
    }

    @Override
    public String getId() {
        return this.m_baseInputElement.GetId();
    }

    public void setInputLayout(StretchableInputLayout inputLayout) {
        this.m_inputLayout = inputLayout;
    }

    @Override
    public boolean isValid() {
        boolean isValid = true;
        String inputValue = this.getInput();
        if (this.m_baseInputElement.GetIsRequired()) {
            isValid = !inputValue.isEmpty();
        }
        isValid = isValid && this.isValidOnSpecifics(inputValue);
        this.showValidationErrors(isValid);
        return isValid;
    }

    public boolean isValidOnSpecifics(String inputValue) {
        return true;
    }

    public void showValidationErrors(boolean isValid) {
        if (this.m_inputLayout != null) {
            this.m_inputLayout.setValidationResult(isValid);
        }
    }
}

