/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.layout;

import android.content.Context;
import android.media.MediaPlayer;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.MediaController;
import io.adaptivecards.renderer.layout.FullscreenVideoView;

public class FullscreenVideoLayout
extends FullscreenVideoView
implements MediaPlayer.OnPreparedListener,
View.OnClickListener {
    protected View.OnClickListener m_clickListener;
    private MediaController m_mediaControlView;

    public FullscreenVideoLayout(Context context) {
        super(context);
    }

    public FullscreenVideoLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public FullscreenVideoLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void release() {
        super.release();
        super.setOnTouchListener(null);
    }

    @Override
    protected void initObjects() {
        super.initObjects();
        super.setOnClickListener((View.OnClickListener)this);
        if (this.m_mediaControlView == null) {
            this.m_mediaControlView = new MediaController(this.m_context){
                private View m_anchorView;
                private ViewGroup.LayoutParams m_layoutParams;

                public void setAnchorView(View view) {
                    this.m_anchorView = view;
                    this.m_layoutParams = view.getLayoutParams();
                    super.setAnchorView(view);
                    if (view instanceof ViewGroup) {
                        ((ViewGroup)this.getParent()).removeView((View)this);
                        this.setLayoutDirection(0);
                        ((ViewGroup)view).addView((View)this);
                    }
                }

                public void show() {
                    super.show();
                    if (this.isShowing() && this.getVisibility() == 4) {
                        this.setVisibility(0);
                        this.requestFocus();
                        this.requestFocusFromTouch();
                    }
                }

                public void hide() {
                    super.hide();
                    if (!this.isShowing() && this.getVisibility() == 0) {
                        this.setVisibility(4);
                        this.m_anchorView.requestFocus();
                        this.m_anchorView.requestFocusFromTouch();
                    }
                }
            };
            this.m_mediaControlView.setMediaPlayer((MediaController.MediaPlayerControl)this);
            this.m_mediaControlView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2, 80));
            this.m_mediaControlView.setAnchorView((View)this);
        }
    }

    @Override
    protected void releaseObjects() {
        super.releaseObjects();
        if (this.m_mediaControlView != null) {
            this.m_mediaControlView.hide();
            this.m_mediaControlView.setAnchorView(null);
        }
    }

    public void setOnClickListener(View.OnClickListener l) {
        this.m_clickListener = l;
    }

    @Override
    public void onCompletion(MediaPlayer mp) {
        super.onCompletion(mp);
        this.updateControls();
    }

    @Override
    public boolean onError(MediaPlayer mp, int what, int extra) {
        boolean result = super.onError(mp, what, extra);
        this.updateControls();
        return result;
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.m_mediaControlView.hide();
    }

    @Override
    public void start() throws IllegalStateException {
        if (!this.isPlaying()) {
            super.start();
        }
        this.updateControls();
    }

    @Override
    public void pause() throws IllegalStateException {
        if (this.isPlaying()) {
            super.pause();
        }
        this.updateControls();
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void stop() throws IllegalStateException {
        super.stop();
        this.updateControls();
    }

    protected void updateControls() {
        if (this.m_currentState == FullscreenVideoView.State.STARTED) {
            this.showControls();
        } else {
            this.showControlsForever();
        }
    }

    public void hideControls() {
        this.m_mediaControlView.hide();
        this.requestFocus();
    }

    public void showControls() {
        this.m_mediaControlView.show();
    }

    private void showControlsForever() {
        this.m_mediaControlView.show(0);
    }

    public void onClick(View v) {
        if (this.m_mediaControlView != null) {
            if (this.m_mediaControlView.isShowing()) {
                this.hideControls();
            } else {
                this.showControls();
            }
        }
        if (this.m_clickListener != null) {
            this.m_clickListener.onClick(v);
        }
    }

    private void togglePlaying() {
        if (this.m_currentState == FullscreenVideoView.State.STARTED) {
            this.pause();
        } else {
            this.start();
        }
    }
}

