/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.layout;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaDataSource;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.MediaController;
import java.io.IOException;

@SuppressLint(value={"NewApi"})
public class FullscreenVideoView
extends FrameLayout
implements MediaPlayer.OnPreparedListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnSeekCompleteListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnVideoSizeChangedListener,
MediaPlayer.OnBufferingUpdateListener,
TextureView.SurfaceTextureListener,
MediaController.MediaPlayerControl {
    protected Context m_context;
    protected MediaPlayer m_mediaPlayer;
    protected boolean m_videoIsReady;
    protected boolean m_surfaceIsReady;
    protected boolean m_isAudioOnly;
    protected State m_currentState;
    protected State m_lastState;
    protected boolean m_shouldAutoplay;
    protected int m_initialConfigOrientation;
    protected int m_initialMovieWidth;
    protected int m_initialMovieHeight;
    protected String m_videoPath;
    protected Uri m_videoUri;
    protected MediaPlayer.OnBufferingUpdateListener m_bufferingUpdateListener;
    protected MediaPlayer.OnCompletionListener m_completionListener;
    protected MediaPlayer.OnErrorListener m_errorListener;
    protected MediaPlayer.OnInfoListener m_infoListener;
    protected MediaPlayer.OnPreparedListener m_preparedListener;
    protected MediaPlayer.OnSeekCompleteListener m_seekCompleteListener;
    protected MediaPlayer.OnVideoSizeChangedListener m_videoSizeChangedListener;
    protected TextureView m_textureView;

    public FullscreenVideoView(Context context) {
        super(context);
        this.m_context = context;
        this.init();
    }

    public FullscreenVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.m_context = context;
        this.init();
    }

    public FullscreenVideoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.m_context = context;
        this.init();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.resize();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable p = super.onSaveInstanceState();
        return p;
    }

    public void onRestoreInstanceState(Parcelable state) {
        super.onRestoreInstanceState(state);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.m_mediaPlayer == null && this.m_currentState == State.END) {
            this.initObjects();
            try {
                if (this.m_videoPath != null) {
                    this.setVideoPath(this.m_videoPath, this.m_isAudioOnly);
                } else if (this.m_videoUri != null) {
                    this.setVideoURI(this.m_videoUri, this.m_isAudioOnly);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
        Surface surface = new Surface(surfaceTexture);
        if (this.m_mediaPlayer != null) {
            this.m_mediaPlayer.setSurface(surface);
            if (!this.m_surfaceIsReady) {
                this.m_surfaceIsReady = true;
                if (this.m_currentState == State.INITIALIZED || this.m_currentState == State.PREPARING) {
                    this.tryToPrepare();
                }
            }
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        this.resize();
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        if (this.m_mediaPlayer != null && this.m_mediaPlayer.isPlaying()) {
            this.m_mediaPlayer.pause();
        }
        this.m_surfaceIsReady = false;
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    public synchronized void onPrepared(MediaPlayer mp) {
        this.m_videoIsReady = true;
        this.tryToPrepare();
    }

    public void onSeekComplete(MediaPlayer mp) {
        if (this.m_lastState != null) {
            switch (this.m_lastState) {
                case STARTED: {
                    this.start();
                    break;
                }
                case PLAYBACKCOMPLETED: {
                    this.m_currentState = State.PLAYBACKCOMPLETED;
                    break;
                }
                case PREPARED: {
                    this.m_currentState = State.PREPARED;
                }
            }
        }
        if (this.m_seekCompleteListener != null) {
            this.m_seekCompleteListener.onSeekComplete(mp);
        }
    }

    public void onCompletion(MediaPlayer mp) {
        if (this.m_mediaPlayer != null && this.m_currentState != State.ERROR) {
            if (!this.m_mediaPlayer.isLooping()) {
                this.m_currentState = State.PLAYBACKCOMPLETED;
            } else {
                this.start();
            }
        }
        if (this.m_completionListener != null) {
            this.m_completionListener.onCompletion(mp);
        }
    }

    public boolean onInfo(MediaPlayer mediaPlayer, int what, int extra) {
        if (this.m_infoListener != null) {
            return this.m_infoListener.onInfo(mediaPlayer, what, extra);
        }
        return false;
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        this.m_currentState = State.ERROR;
        if (this.m_errorListener != null) {
            return this.m_errorListener.onError(mp, what, extra);
        }
        return false;
    }

    public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
        if (this.m_initialMovieWidth == -1 && this.m_initialMovieHeight == -1 && width != 0 && height != 0) {
            this.m_initialMovieWidth = width;
            this.m_initialMovieHeight = height;
            this.resize();
        }
        if (this.m_videoSizeChangedListener != null) {
            this.m_videoSizeChangedListener.onVideoSizeChanged(mp, width, height);
        }
    }

    public void onBufferingUpdate(MediaPlayer mp, int percent) {
        if (this.m_bufferingUpdateListener != null) {
            this.m_bufferingUpdateListener.onBufferingUpdate(mp, percent);
        }
    }

    protected void init() {
        if (this.isInEditMode()) {
            return;
        }
        this.m_mediaPlayer = null;
        this.m_shouldAutoplay = false;
        this.m_initialConfigOrientation = -1;
        this.m_videoIsReady = false;
        this.m_surfaceIsReady = false;
        this.m_initialMovieHeight = -1;
        this.m_initialMovieWidth = -1;
        this.setBackgroundColor(-16777216);
        this.initObjects();
    }

    protected void release() {
        this.releaseObjects();
        if (this.m_mediaPlayer != null) {
            this.m_mediaPlayer.setOnBufferingUpdateListener(null);
            this.m_mediaPlayer.setOnPreparedListener(null);
            this.m_mediaPlayer.setOnErrorListener(null);
            this.m_mediaPlayer.setOnSeekCompleteListener(null);
            this.m_mediaPlayer.setOnCompletionListener(null);
            this.m_mediaPlayer.setOnInfoListener(null);
            this.m_mediaPlayer.setOnVideoSizeChangedListener(null);
            this.m_mediaPlayer.release();
            this.m_mediaPlayer = null;
        }
        this.m_currentState = State.END;
    }

    protected void initObjects() {
        if (this.m_mediaPlayer == null) {
            this.m_mediaPlayer = new MediaPlayer();
            this.m_mediaPlayer.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.m_mediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.m_mediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.m_mediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.m_mediaPlayer.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)this);
            this.m_mediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.m_mediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.m_mediaPlayer.setAudioStreamType(3);
        }
        if (this.m_textureView == null) {
            this.m_textureView = new TextureView(this.m_context);
            this.m_textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
        }
        this.m_textureView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)this.m_textureView);
        this.m_currentState = State.IDLE;
    }

    protected void releaseObjects() {
        if (this.m_mediaPlayer != null) {
            this.m_mediaPlayer.setSurface(null);
            this.m_mediaPlayer.reset();
        }
        this.m_videoIsReady = false;
        this.m_surfaceIsReady = false;
        this.m_initialMovieHeight = -1;
        this.m_initialMovieWidth = -1;
        if (this.m_textureView != null) {
            this.m_textureView.setSurfaceTextureListener(null);
            this.removeView((View)this.m_textureView);
            this.m_textureView = null;
        }
    }

    public void prepare() throws IllegalStateException {
        this.m_currentState = State.PREPARING;
        this.m_mediaPlayer.prepareAsync();
    }

    protected void tryToPrepare() {
        if (this.m_surfaceIsReady && this.m_videoIsReady) {
            if (this.m_mediaPlayer != null && this.m_mediaPlayer.getVideoWidth() != 0 && this.m_mediaPlayer.getVideoHeight() != 0) {
                this.m_initialMovieWidth = this.m_mediaPlayer.getVideoWidth();
                this.m_initialMovieHeight = this.m_mediaPlayer.getVideoHeight();
            }
            this.resize();
            this.m_currentState = State.PREPARED;
            if (this.m_shouldAutoplay) {
                this.start();
            }
            if (this.m_preparedListener != null) {
                this.m_preparedListener.onPrepared(this.m_mediaPlayer);
            }
        }
    }

    public synchronized State getCurrentState() {
        return this.m_currentState;
    }

    public void resize() {
        if ((this.m_initialMovieHeight == -1 || this.m_initialMovieWidth == -1) && !this.m_isAudioOnly || this.m_textureView == null) {
            return;
        }
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                View currentParent = (View)FullscreenVideoView.this.getParent();
                if (currentParent != null) {
                    int screenWidth = currentParent.getWidth();
                    int newHeight = 200;
                    newHeight = !FullscreenVideoView.this.m_isAudioOnly ? (int)((float)(screenWidth * FullscreenVideoView.this.m_initialMovieHeight) / (float)FullscreenVideoView.this.m_initialMovieWidth) : 200;
                    if (FullscreenVideoView.this.m_textureView != null) {
                        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)FullscreenVideoView.this.m_textureView.getLayoutParams();
                        layoutParams.width = screenWidth;
                        layoutParams.height = newHeight;
                        FullscreenVideoView.this.m_textureView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    }
                }
            }
        });
    }

    public boolean isShouldAutoplay() {
        return this.m_shouldAutoplay;
    }

    public void setShouldAutoplay(boolean shouldAutoplay) {
        this.m_shouldAutoplay = shouldAutoplay;
    }

    public int getCurrentPosition() {
        if (this.m_mediaPlayer != null) {
            return this.m_mediaPlayer.getCurrentPosition();
        }
        throw new RuntimeException("Media Player is not initialized");
    }

    public int getDuration() {
        if (this.m_mediaPlayer != null) {
            return this.m_mediaPlayer.getDuration();
        }
        throw new RuntimeException("Media Player is not initialized");
    }

    public int getVideoHeight() {
        if (this.m_mediaPlayer != null) {
            return this.m_mediaPlayer.getVideoHeight();
        }
        throw new RuntimeException("Media Player is not initialized");
    }

    public int getVideoWidth() {
        if (this.m_mediaPlayer != null) {
            return this.m_mediaPlayer.getVideoWidth();
        }
        throw new RuntimeException("Media Player is not initialized");
    }

    public boolean isLooping() {
        if (this.m_mediaPlayer != null) {
            return this.m_mediaPlayer.isLooping();
        }
        throw new RuntimeException("Media Player is not initialized");
    }

    public boolean isPlaying() throws IllegalStateException {
        if (this.m_mediaPlayer != null) {
            return this.m_mediaPlayer.isPlaying();
        }
        throw new RuntimeException("Media Player is not initialized");
    }

    public void pause() throws IllegalStateException {
        if (this.m_mediaPlayer == null) {
            throw new RuntimeException("Media Player is not initialized");
        }
        this.m_currentState = State.PAUSED;
        this.m_mediaPlayer.pause();
    }

    public void reset() {
        this.releaseObjects();
        this.initObjects();
    }

    public void start() throws IllegalStateException {
        if (this.m_mediaPlayer == null) {
            throw new RuntimeException("Media Player is not initialized");
        }
        this.m_currentState = State.STARTED;
        this.m_mediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        this.m_mediaPlayer.start();
    }

    public void stop() throws IllegalStateException {
        if (this.m_mediaPlayer == null) {
            throw new RuntimeException("Media Player is not initialized");
        }
        this.m_currentState = State.STOPPED;
        this.m_mediaPlayer.stop();
    }

    public void seekTo(int msec) throws IllegalStateException {
        if (this.m_mediaPlayer != null) {
            if (this.m_mediaPlayer.getDuration() > -1 && msec <= this.m_mediaPlayer.getDuration()) {
                this.m_lastState = this.m_currentState;
                this.pause();
                this.m_mediaPlayer.seekTo(msec);
            }
        } else {
            throw new RuntimeException("Media Player is not initialized");
        }
    }

    public int getBufferPercentage() {
        return 0;
    }

    public boolean canPause() {
        return true;
    }

    public boolean canSeekBackward() {
        return true;
    }

    public boolean canSeekForward() {
        return true;
    }

    public int getAudioSessionId() {
        return this.m_mediaPlayer.getAudioSessionId();
    }

    public void setOnCompletionListener(MediaPlayer.OnCompletionListener l) {
        if (this.m_mediaPlayer == null) {
            throw new RuntimeException("Media Player is not initialized");
        }
        this.m_completionListener = l;
    }

    public void setOnErrorListener(MediaPlayer.OnErrorListener l) {
        if (this.m_mediaPlayer == null) {
            throw new RuntimeException("Media Player is not initialized");
        }
        this.m_errorListener = l;
    }

    public void setOnBufferingUpdateListener(MediaPlayer.OnBufferingUpdateListener l) {
        if (this.m_mediaPlayer == null) {
            throw new RuntimeException("Media Player is not initialized");
        }
        this.m_bufferingUpdateListener = l;
        this.m_mediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
    }

    public void setOnInfoListener(MediaPlayer.OnInfoListener l) {
        if (this.m_mediaPlayer == null) {
            throw new RuntimeException("Media Player is not initialized");
        }
        this.m_infoListener = l;
    }

    public void setOnSeekCompleteListener(MediaPlayer.OnSeekCompleteListener l) {
        if (this.m_mediaPlayer == null) {
            throw new RuntimeException("Media Player is not initialized");
        }
        this.m_seekCompleteListener = l;
    }

    public void setOnVideoSizeChangedListener(MediaPlayer.OnVideoSizeChangedListener l) {
        if (this.m_mediaPlayer == null) {
            throw new RuntimeException("Media Player is not initialized");
        }
        this.m_videoSizeChangedListener = l;
    }

    public void setOnPreparedListener(MediaPlayer.OnPreparedListener l) {
        if (this.m_mediaPlayer == null) {
            throw new RuntimeException("Media Player is not initialized");
        }
        this.m_preparedListener = l;
    }

    public void setLooping(boolean looping) {
        if (this.m_mediaPlayer == null) {
            throw new RuntimeException("Media Player is not initialized");
        }
        this.m_mediaPlayer.setLooping(looping);
    }

    public void setVolume(float leftVolume, float rightVolume) {
        if (this.m_mediaPlayer == null) {
            throw new RuntimeException("Media Player is not initialized");
        }
        this.m_mediaPlayer.setVolume(leftVolume, rightVolume);
    }

    public void setVideoPath(String path, boolean isAudio) throws IOException, IllegalStateException, SecurityException, IllegalArgumentException, RuntimeException {
        if (this.m_mediaPlayer != null) {
            if (this.m_currentState != State.IDLE) {
                throw new IllegalStateException("FullscreenVideoView Invalid State: " + (Object)((Object)this.m_currentState));
            }
        } else {
            throw new RuntimeException("Media Player is not initialized");
        }
        this.m_videoPath = path;
        this.m_videoUri = null;
        this.m_isAudioOnly = isAudio;
        this.m_mediaPlayer.setDataSource(path);
        this.m_currentState = State.INITIALIZED;
        this.prepare();
    }

    public void setVideoURI(Uri uri, boolean isAudio) throws IOException, IllegalStateException, SecurityException, IllegalArgumentException, RuntimeException {
        if (this.m_mediaPlayer != null) {
            if (this.m_currentState != State.IDLE) {
                throw new IllegalStateException("FullscreenVideoView Invalid State: " + (Object)((Object)this.m_currentState));
            }
        } else {
            throw new RuntimeException("Media Player is not initialized");
        }
        this.m_videoUri = uri;
        this.m_videoPath = null;
        this.m_isAudioOnly = isAudio;
        this.m_mediaPlayer.setDataSource(this.m_context, uri);
        this.m_currentState = State.INITIALIZED;
        this.prepare();
    }

    public void setDataSource(MediaDataSource dataSource, boolean isAudio) {
        if (this.m_mediaPlayer != null) {
            if (this.m_currentState != State.IDLE) {
                throw new IllegalStateException("FullscreenVideoView Invalid State: " + (Object)((Object)this.m_currentState));
            }
        } else {
            throw new RuntimeException("Media Player is not initialized");
        }
        this.m_videoUri = null;
        this.m_videoPath = null;
        this.m_isAudioOnly = isAudio;
        this.m_mediaPlayer.setDataSource(dataSource);
        this.m_currentState = State.INITIALIZED;
    }

    public static enum State {
        IDLE,
        INITIALIZED,
        PREPARED,
        PREPARING,
        STARTED,
        STOPPED,
        PAUSED,
        PLAYBACKCOMPLETED,
        ERROR,
        END;

    }
}

