/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.objectmodel;

import io.adaptivecards.objectmodel.AdaptiveCardObjectModelJNI;
import java.util.AbstractList;
import java.util.RandomAccess;

public class CharVector
extends AbstractList<Character>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected CharVector(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(CharVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                AdaptiveCardObjectModelJNI.delete_CharVector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public CharVector(char[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (char element : initialElements) {
            this.add(Character.valueOf(element));
        }
    }

    public CharVector(Iterable<Character> initialElements) {
        this();
        for (char element : initialElements) {
            this.add(Character.valueOf(element));
        }
    }

    @Override
    public Character get(int index) {
        return Character.valueOf(this.doGet(index));
    }

    @Override
    public Character set(int index, Character e) {
        return Character.valueOf(this.doSet(index, e.charValue()));
    }

    @Override
    public boolean add(Character e) {
        ++this.modCount;
        this.doAdd(e.charValue());
        return true;
    }

    @Override
    public void add(int index, Character e) {
        ++this.modCount;
        this.doAdd(index, e.charValue());
    }

    @Override
    public Character remove(int index) {
        ++this.modCount;
        return Character.valueOf(this.doRemove(index));
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public CharVector() {
        this(AdaptiveCardObjectModelJNI.new_CharVector__SWIG_0(), true);
    }

    public CharVector(CharVector other) {
        this(AdaptiveCardObjectModelJNI.new_CharVector__SWIG_1(CharVector.getCPtr(other), other), true);
    }

    public long capacity() {
        return AdaptiveCardObjectModelJNI.CharVector_capacity(this.swigCPtr, this);
    }

    public void reserve(long n) {
        AdaptiveCardObjectModelJNI.CharVector_reserve(this.swigCPtr, this, n);
    }

    @Override
    public boolean isEmpty() {
        return AdaptiveCardObjectModelJNI.CharVector_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        AdaptiveCardObjectModelJNI.CharVector_clear(this.swigCPtr, this);
    }

    public CharVector(int count, char value) {
        this(AdaptiveCardObjectModelJNI.new_CharVector__SWIG_2(count, value), true);
    }

    private int doSize() {
        return AdaptiveCardObjectModelJNI.CharVector_doSize(this.swigCPtr, this);
    }

    private void doAdd(char x) {
        AdaptiveCardObjectModelJNI.CharVector_doAdd__SWIG_0(this.swigCPtr, this, x);
    }

    private void doAdd(int index, char x) {
        AdaptiveCardObjectModelJNI.CharVector_doAdd__SWIG_1(this.swigCPtr, this, index, x);
    }

    private char doRemove(int index) {
        return AdaptiveCardObjectModelJNI.CharVector_doRemove(this.swigCPtr, this, index);
    }

    private char doGet(int index) {
        return AdaptiveCardObjectModelJNI.CharVector_doGet(this.swigCPtr, this, index);
    }

    private char doSet(int index, char val) {
        return AdaptiveCardObjectModelJNI.CharVector_doSet(this.swigCPtr, this, index, val);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        AdaptiveCardObjectModelJNI.CharVector_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

