/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.objectmodel;

import io.adaptivecards.objectmodel.AdaptiveCardObjectModelJNI;
import io.adaptivecards.objectmodel.MediaSource;
import java.util.AbstractList;
import java.util.RandomAccess;

public class MediaSourceVector
extends AbstractList<MediaSource>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected MediaSourceVector(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(MediaSourceVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                AdaptiveCardObjectModelJNI.delete_MediaSourceVector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public MediaSourceVector(MediaSource[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (MediaSource element : initialElements) {
            this.add(element);
        }
    }

    public MediaSourceVector(Iterable<MediaSource> initialElements) {
        this();
        for (MediaSource element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public MediaSource get(int index) {
        return this.doGet(index);
    }

    @Override
    public MediaSource set(int index, MediaSource e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(MediaSource e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, MediaSource e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public MediaSource remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public MediaSourceVector() {
        this(AdaptiveCardObjectModelJNI.new_MediaSourceVector__SWIG_0(), true);
    }

    public MediaSourceVector(MediaSourceVector other) {
        this(AdaptiveCardObjectModelJNI.new_MediaSourceVector__SWIG_1(MediaSourceVector.getCPtr(other), other), true);
    }

    public long capacity() {
        return AdaptiveCardObjectModelJNI.MediaSourceVector_capacity(this.swigCPtr, this);
    }

    public void reserve(long n) {
        AdaptiveCardObjectModelJNI.MediaSourceVector_reserve(this.swigCPtr, this, n);
    }

    @Override
    public boolean isEmpty() {
        return AdaptiveCardObjectModelJNI.MediaSourceVector_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        AdaptiveCardObjectModelJNI.MediaSourceVector_clear(this.swigCPtr, this);
    }

    public MediaSourceVector(int count, MediaSource value) {
        this(AdaptiveCardObjectModelJNI.new_MediaSourceVector__SWIG_2(count, MediaSource.getCPtr(value), value), true);
    }

    private int doSize() {
        return AdaptiveCardObjectModelJNI.MediaSourceVector_doSize(this.swigCPtr, this);
    }

    private void doAdd(MediaSource x) {
        AdaptiveCardObjectModelJNI.MediaSourceVector_doAdd__SWIG_0(this.swigCPtr, this, MediaSource.getCPtr(x), x);
    }

    private void doAdd(int index, MediaSource x) {
        AdaptiveCardObjectModelJNI.MediaSourceVector_doAdd__SWIG_1(this.swigCPtr, this, index, MediaSource.getCPtr(x), x);
    }

    private MediaSource doRemove(int index) {
        long cPtr = AdaptiveCardObjectModelJNI.MediaSourceVector_doRemove(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new MediaSource(cPtr, true);
    }

    private MediaSource doGet(int index) {
        long cPtr = AdaptiveCardObjectModelJNI.MediaSourceVector_doGet(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new MediaSource(cPtr, true);
    }

    private MediaSource doSet(int index, MediaSource val) {
        long cPtr = AdaptiveCardObjectModelJNI.MediaSourceVector_doSet(this.swigCPtr, this, index, MediaSource.getCPtr(val), val);
        return cPtr == 0L ? null : new MediaSource(cPtr, true);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        AdaptiveCardObjectModelJNI.MediaSourceVector_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

