/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.MediaPlayer;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import androidx.fragment.app.FragmentManager;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.Image;
import io.adaptivecards.objectmodel.ImageSize;
import io.adaptivecards.objectmodel.Media;
import io.adaptivecards.objectmodel.MediaSource;
import io.adaptivecards.objectmodel.MediaSourceVector;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.IMediaDataSourceOnPreparedListener;
import io.adaptivecards.renderer.IOnlineMediaLoader;
import io.adaptivecards.renderer.MediaLoaderAsync;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.layout.FullscreenVideoLayout;
import io.adaptivecards.renderer.layout.FullscreenVideoView;
import io.adaptivecards.renderer.readonly.ImageRenderer;
import io.adaptivecards.renderer.registration.CardRendererRegistration;

public class MediaRenderer
extends BaseCardElementRenderer {
    private static MediaRenderer s_instance = null;

    private MediaRenderer() {
    }

    public static MediaRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new MediaRenderer();
        }
        return s_instance;
    }

    private boolean isSupportedMimeType(String mimetype) {
        String[] supportedMimeTypes;
        for (String supportedMimeType : supportedMimeTypes = new String[]{"video/mp4", "audio/mp4", "audio/aac", "audio/mpeg"}) {
            if (supportedMimeType.compareTo(mimetype) != 0) continue;
            return true;
        }
        return false;
    }

    private ImageView renderPoster(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, Media media, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) throws Exception {
        ImageView posterView = null;
        Image poster = new Image();
        if (!media.GetPoster().isEmpty()) {
            poster.SetUrl(media.GetPoster());
        } else {
            poster.SetUrl(hostConfig.GetMedia().getDefaultPoster());
        }
        poster.SetAltText(media.GetAltText());
        if (!poster.GetUrl().isEmpty()) {
            poster.SetImageSize(ImageSize.Auto);
            posterView = ImageRenderer.getInstance().render(renderedCard, context, fragmentManager, viewGroup, poster, cardActionHandler, hostConfig, renderArgs);
            RelativeLayout.LayoutParams posterLayoutParams = new RelativeLayout.LayoutParams(-1, -1);
            posterLayoutParams.addRule(13, -1);
            ((TagContent)posterView.getTag()).GetStretchContainer().setLayoutParams((ViewGroup.LayoutParams)posterLayoutParams);
        }
        return posterView;
    }

    private ImageView renderPlayButton(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) throws Exception {
        ImageView playButtonView;
        String playButtonUrl = hostConfig.GetMedia().getPlayButton();
        RelativeLayout.LayoutParams playButtonLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
        playButtonLayoutParams.addRule(13, -1);
        if (!playButtonUrl.isEmpty()) {
            Image playButton = new Image();
            playButton.SetUrl(playButtonUrl);
            playButton.SetImageSize(ImageSize.Small);
            playButtonView = ImageRenderer.getInstance().render(renderedCard, context, fragmentManager, viewGroup, playButton, cardActionHandler, hostConfig, renderArgs);
            ((TagContent)playButtonView.getTag()).GetStretchContainer().setLayoutParams((ViewGroup.LayoutParams)playButtonLayoutParams);
        } else {
            Resources resources = context.getResources();
            Bitmap playButton = BitmapFactory.decodeResource((Resources)resources, (int)17301540);
            playButtonView = new ImageView(context);
            playButtonView.setImageBitmap(playButton);
            viewGroup.addView((View)playButtonView);
            playButtonView.setLayoutParams((ViewGroup.LayoutParams)playButtonLayoutParams);
        }
        return playButtonView;
    }

    private FullscreenVideoView renderMediaPlayer(Context context, ViewGroup viewGroup, Media media, HostConfig hostConfig) {
        final FullscreenVideoLayout mediaView = new FullscreenVideoLayout(context);
        MediaSourceVector mediaSources = media.GetSources();
        long sourcesSize = mediaSources.size();
        if (sourcesSize > 0L) {
            IOnlineMediaLoader onlineMediaLoader;
            boolean isAudio = mediaSources.get(0).GetMimeType().startsWith("audio");
            boolean registeredOnlineMediaLoader = false;
            if (Build.VERSION.SDK_INT >= 23 && (onlineMediaLoader = CardRendererRegistration.getInstance().getOnlineMediaLoader()) != null) {
                mediaView.setDataSource(onlineMediaLoader.loadOnlineMedia(mediaSources, new IMediaDataSourceOnPreparedListener(){

                    @Override
                    public void prepareMediaPlayer() {
                        mediaView.prepare();
                    }
                }), isAudio);
                registeredOnlineMediaLoader = true;
            }
            if (!registeredOnlineMediaLoader) {
                int i = 0;
                while ((long)i < sourcesSize) {
                    MediaSource mediaSource = mediaSources.get(i);
                    String mimeType = mediaSource.GetMimeType();
                    if (this.isSupportedMimeType(mimeType)) {
                        try {
                            new MediaLoaderAsync(mediaView, mediaSource, hostConfig, isAudio, context).execute(new String[]{""});
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
        }
        mediaView.setShouldAutoplay(true);
        mediaView.setContentDescription(media.GetAltText());
        RelativeLayout.LayoutParams videoViewLayoutParams = new RelativeLayout.LayoutParams(-1, -2);
        videoViewLayoutParams.addRule(20);
        videoViewLayoutParams.addRule(21);
        videoViewLayoutParams.addRule(13);
        mediaView.setLayoutParams((ViewGroup.LayoutParams)videoViewLayoutParams);
        mediaView.setVisibility(8);
        viewGroup.addView((View)mediaView);
        return mediaView;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) throws Exception {
        Media media = Util.castTo(baseCardElement, Media.class);
        LinearLayout mediaLayout = new LinearLayout(context);
        mediaLayout.setTag((Object)new TagContent(media));
        mediaLayout.setOrientation(1);
        RelativeLayout posterLayout = new RelativeLayout(context);
        ImageView posterView = this.renderPoster(renderedCard, context, fragmentManager, (ViewGroup)posterLayout, media, cardActionHandler, hostConfig, renderArgs);
        ImageView playButtonView = this.renderPlayButton(renderedCard, context, fragmentManager, (ViewGroup)posterLayout, cardActionHandler, hostConfig, renderArgs);
        FullscreenVideoView mediaView = this.renderMediaPlayer(context, (ViewGroup)posterLayout, media, hostConfig);
        posterLayout.setOnClickListener((View.OnClickListener)new PosterOnClickListener(posterView, playButtonView, mediaView, hostConfig.GetMedia().getAllowInlinePlayback(), media, renderedCard, cardActionHandler, (ViewGroup)posterLayout));
        mediaView.setOnCompletionListener(new MediaOnCompletionListener(media, renderedCard, cardActionHandler));
        mediaLayout.addView((View)posterLayout);
        viewGroup.addView((View)mediaLayout);
        return mediaLayout;
    }

    private class MediaOnCompletionListener
    implements MediaPlayer.OnCompletionListener {
        private BaseCardElement m_cardMediaElement;
        private RenderedAdaptiveCard m_renderedAdaptiveCard;
        private ICardActionHandler m_cardActionHandler;

        MediaOnCompletionListener(BaseCardElement mediaElement, RenderedAdaptiveCard renderedAdaptiveCard, ICardActionHandler cardActionHandler) {
            this.m_cardMediaElement = mediaElement;
            this.m_renderedAdaptiveCard = renderedAdaptiveCard;
            this.m_cardActionHandler = cardActionHandler;
        }

        public void onCompletion(MediaPlayer mp) {
            this.m_cardActionHandler.onMediaStop(this.m_cardMediaElement, this.m_renderedAdaptiveCard);
        }
    }

    private class PosterOnClickListener
    implements View.OnClickListener {
        private ViewGroup m_posterLayout;
        private ImageView m_poster;
        private ImageView m_playButton;
        private FullscreenVideoView m_mediaView;
        private boolean m_allowedInlinePlayback = true;
        private boolean m_alreadyClicked = false;
        private BaseCardElement m_cardMediaElement;
        private RenderedAdaptiveCard m_renderedAdaptiveCard;
        private ICardActionHandler m_cardActionHandler;

        public PosterOnClickListener(ImageView poster, ImageView playButton, FullscreenVideoView mediaView, boolean allowedInlinePlayback, BaseCardElement mediaElement, RenderedAdaptiveCard renderedAdaptiveCard, ICardActionHandler cardActionHandler, ViewGroup posterLayout) {
            this.m_poster = poster;
            this.m_playButton = playButton;
            this.m_mediaView = mediaView;
            this.m_allowedInlinePlayback = allowedInlinePlayback;
            this.m_cardMediaElement = mediaElement;
            this.m_renderedAdaptiveCard = renderedAdaptiveCard;
            this.m_cardActionHandler = cardActionHandler;
            this.m_posterLayout = posterLayout;
        }

        public void onClick(View v) {
            if (!this.m_alreadyClicked) {
                if (this.m_allowedInlinePlayback) {
                    if (this.m_poster != null) {
                        this.m_poster.setVisibility(8);
                    }
                    this.m_playButton.setVisibility(8);
                    this.m_mediaView.setVisibility(0);
                }
                this.m_posterLayout.setClickable(false);
                this.m_cardActionHandler.onMediaPlay(this.m_cardMediaElement, this.m_renderedAdaptiveCard);
                this.m_alreadyClicked = true;
            }
        }
    }
}

