/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.os.Build;
import android.text.Editable;
import android.text.Html;
import android.text.Spanned;
import android.text.style.URLSpan;
import io.adaptivecards.objectmodel.DateTimePreparser;
import io.adaptivecards.objectmodel.HorizontalAlignment;
import io.adaptivecards.objectmodel.MarkDownParser;
import io.adaptivecards.renderer.RenderArgs;
import java.util.ArrayDeque;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class RendererUtil {
    public static boolean isValidDate(String s) {
        long[] year = new long[]{0L};
        long[] month = new long[]{0L};
        long[] day = new long[]{0L};
        return DateTimePreparser.TryParseSimpleDate(s, year, month, day);
    }

    public static Calendar getDate(String s) {
        GregorianCalendar calendar = new GregorianCalendar();
        long[] year = new long[]{0L};
        long[] month = new long[]{0L};
        long[] day = new long[]{0L};
        if (DateTimePreparser.TryParseSimpleDate(s, year, month, day)) {
            calendar.set((int)year[0], (int)month[0] - 1, (int)day[0]);
        }
        return calendar;
    }

    public static boolean isValidTime(String s) {
        long[] hour = new long[]{0L};
        long[] minutes = new long[]{0L};
        return DateTimePreparser.TryParseSimpleTime(s, hour, minutes);
    }

    public static Calendar getTime(String s) {
        GregorianCalendar calendar = new GregorianCalendar();
        long[] hour = new long[]{0L};
        long[] minutes = new long[]{0L};
        if (DateTimePreparser.TryParseSimpleTime(s, hour, minutes)) {
            calendar.set(11, (int)hour[0]);
            calendar.set(12, (int)minutes[0]);
            calendar.set(13, 0);
        }
        return calendar;
    }

    public static CharSequence handleSpecialText(String textWithFormattedDates) {
        Spanned spanned = RendererUtil.getSpecialTextSpans(textWithFormattedDates);
        return RendererUtil.trimHtmlString(spanned);
    }

    private static boolean FirstAndLastSpansAreTheSame(Spanned spanned) {
        URLSpan[] firstSpan = (URLSpan[])spanned.getSpans(0, 1, URLSpan.class);
        URLSpan[] lastSpan = (URLSpan[])spanned.getSpans(spanned.length() - 2, spanned.length(), URLSpan.class);
        return firstSpan.length == 1 && lastSpan.length == 1;
    }

    public static SpecialTextHandleResult handleSpecialTextAndQueryLinks(String textWithFormattedDates) {
        Spanned spanned = RendererUtil.getSpecialTextSpans(textWithFormattedDates);
        URLSpan[] spans = (URLSpan[])spanned.getSpans(0, spanned.length(), URLSpan.class);
        boolean isALink = false;
        if (spans.length == 1) {
            isALink = RendererUtil.FirstAndLastSpansAreTheSame(spanned);
        }
        return new SpecialTextHandleResult(RendererUtil.trimHtmlString(spanned), spans.length > 0, isALink);
    }

    public static Spanned getSpecialTextSpans(String textWithFormattedDates) {
        MarkDownParser markDownParser = new MarkDownParser(textWithFormattedDates);
        String textString = markDownParser.TransformToHtml();
        textString = textString.replace("<li>", "<listItem>");
        textString = textString.replaceAll("(" + System.lineSeparator() + "|\r\n|\n\r|\r|\n)", "<br/>");
        Spanned htmlString = Build.VERSION.SDK_INT >= 24 ? Html.fromHtml((String)textString, (int)63, null, (Html.TagHandler)new UlTagHandler()) : Html.fromHtml((String)textString, null, (Html.TagHandler)new UlTagHandler());
        return htmlString;
    }

    public static CharSequence trimHtmlString(Spanned htmlString) {
        int i;
        int numToRemoveFromEnd = 0;
        int numToRemoveFromStart = 0;
        for (i = htmlString.length() - 1; i >= 0 && htmlString.charAt(i) == '\n'; --i) {
            ++numToRemoveFromEnd;
        }
        for (i = 0; i <= htmlString.length() - 1 && htmlString.charAt(i) == '\n'; ++i) {
            ++numToRemoveFromStart;
        }
        if (numToRemoveFromStart + numToRemoveFromEnd >= htmlString.length()) {
            return htmlString;
        }
        return htmlString.subSequence(numToRemoveFromStart, htmlString.length() - numToRemoveFromEnd);
    }

    static HorizontalAlignment computeHorizontalAlignment(HorizontalAlignment declaredAlignment, RenderArgs renderArgs) {
        if (declaredAlignment != null) {
            return declaredAlignment;
        }
        if (renderArgs != null && renderArgs.getHorizontalAlignment() != null) {
            return renderArgs.getHorizontalAlignment();
        }
        return HorizontalAlignment.Left;
    }

    public static class UlTagHandler
    implements Html.TagHandler,
    ContentHandler {
        private int tagNumber = 0;
        private boolean orderedList = false;
        private ContentHandler defaultContentHandler = null;
        private Editable text = null;
        private ArrayDeque<Boolean> tagStatusQueue = new ArrayDeque();

        private String getAttribute(String attributeName, Attributes attributes) {
            return attributes.getValue(attributeName);
        }

        public boolean handleTag(boolean opening, String tag, Editable output, Attributes attributes) {
            boolean tagWasHandled = false;
            if (tag.equals("ul") && !opening) {
                output.append((CharSequence)"\n");
                tagWasHandled = true;
            }
            if (tag.equals("listItem") && opening) {
                if (this.orderedList) {
                    output.append((CharSequence)"\n");
                    output.append((CharSequence)String.valueOf(this.tagNumber));
                    output.append((CharSequence)". ");
                    ++this.tagNumber;
                } else {
                    output.append((CharSequence)"\n\u2022 ");
                }
                tagWasHandled = true;
            }
            if (tag.equals("ol") && opening) {
                this.orderedList = true;
                String tagNumberString = this.getAttribute("start", attributes);
                int retrievedTagNumber = 1;
                if (tagNumberString != null) {
                    retrievedTagNumber = Integer.parseInt(tagNumberString);
                }
                this.tagNumber = retrievedTagNumber;
                tagWasHandled = true;
            }
            return tagWasHandled;
        }

        public void handleTag(boolean opening, String tag, Editable output, XMLReader xmlReader) {
            if (this.defaultContentHandler == null) {
                this.text = output;
                this.defaultContentHandler = xmlReader.getContentHandler();
                xmlReader.setContentHandler(this);
                this.tagStatusQueue.addLast(Boolean.FALSE);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            boolean isHandled = this.handleTag(true, localName, this.text, attributes);
            this.tagStatusQueue.addLast(isHandled);
            if (!isHandled) {
                this.defaultContentHandler.startElement(uri, localName, qName, attributes);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!this.tagStatusQueue.removeLast().booleanValue()) {
                this.defaultContentHandler.endElement(uri, localName, qName);
            }
            this.handleTag(false, localName, this.text, (Attributes)null);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.defaultContentHandler.setDocumentLocator(locator);
        }

        @Override
        public void startDocument() throws SAXException {
            this.defaultContentHandler.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            this.defaultContentHandler.endDocument();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.defaultContentHandler.startPrefixMapping(prefix, uri);
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            this.defaultContentHandler.endPrefixMapping(prefix);
        }

        @Override
        public void characters(char[] chars, int start, int length) throws SAXException {
            this.defaultContentHandler.characters(chars, start, length);
        }

        @Override
        public void ignorableWhitespace(char[] chars, int start, int length) throws SAXException {
            this.defaultContentHandler.ignorableWhitespace(chars, start, length);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            this.defaultContentHandler.processingInstruction(target, data);
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            this.defaultContentHandler.skippedEntity(name);
        }
    }

    public static class SpecialTextHandleResult {
        private CharSequence m_htmlString;
        private boolean m_hasLinks;
        private boolean m_isALink;

        public SpecialTextHandleResult(CharSequence htmlString, boolean hasLinks, boolean isALink) {
            this.m_htmlString = htmlString;
            this.m_hasLinks = hasLinks;
            this.m_isALink = isALink;
        }

        public CharSequence getHtmlString() {
            return this.m_htmlString;
        }

        public boolean getHasLinks() {
            return this.m_hasLinks;
        }

        public boolean isALink() {
            return this.m_isALink;
        }
    }
}

