/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.TypefaceSpan;
import android.text.style.UnderlineSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentManager;
import io.adaptivecards.objectmodel.BaseActionElement;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.FontType;
import io.adaptivecards.objectmodel.ForegroundColor;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.Inline;
import io.adaptivecards.objectmodel.InlineElementType;
import io.adaptivecards.objectmodel.InlineVector;
import io.adaptivecards.objectmodel.RichTextBlock;
import io.adaptivecards.objectmodel.TextRun;
import io.adaptivecards.objectmodel.TextSize;
import io.adaptivecards.objectmodel.TextStyle;
import io.adaptivecards.objectmodel.TextWeight;
import io.adaptivecards.renderer.BaseActionElementRenderer;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.readonly.DateTimeParser;
import io.adaptivecards.renderer.readonly.TextBlockRenderer;
import io.adaptivecards.renderer.readonly.TextRendererUtil;

public class RichTextBlockRenderer
extends BaseCardElementRenderer {
    private static RichTextBlockRenderer s_instance = null;

    public static RichTextBlockRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new RichTextBlockRenderer();
        }
        return s_instance;
    }

    public static SpannableStringBuilder setColor(SpannableStringBuilder paragraph, int spanStart, int spanEnd, ForegroundColor textColor, boolean isSubtle, HostConfig hostConfig, RenderArgs renderArgs) {
        int color2 = RichTextBlockRenderer.getColor(TextRendererUtil.getTextColor(textColor, hostConfig, isSubtle, renderArgs.getContainerStyle()));
        paragraph.setSpan((Object)new ForegroundColorSpan(color2), spanStart, spanEnd, 17);
        return paragraph;
    }

    public static TextRun castInlineToTextRun(Inline inline) {
        TextRun textRun = null;
        if (inline instanceof TextRun) {
            textRun = (TextRun)inline;
        } else {
            textRun = TextRun.dynamic_cast(inline);
            if (textRun == null) {
                throw new InternalError("Unable to convert BaseCardElement to TextBlock object model.");
            }
        }
        return textRun;
    }

    private SpannableStringBuilder buildSpannableParagraph(RenderedAdaptiveCard renderedCard, InlineVector inlines, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) {
        SpannableStringBuilder paragraph = new SpannableStringBuilder();
        int lastStringLength = 0;
        for (int i = 0; i < inlines.size(); ++i) {
            Inline inline = inlines.get(i);
            if (inline.GetInlineType() == InlineElementType.TextRun) {
                TextRun textRun = null;
                if (inline instanceof TextRun) {
                    textRun = (TextRun)inline;
                } else {
                    textRun = TextRun.dynamic_cast(inline);
                    if (textRun == null) {
                        throw new InternalError("Unable to convert BaseCardElement to TextBlock object model.");
                    }
                }
                TextSize textSize = TextRendererUtil.computeTextSize(hostConfig, TextStyle.Default, textRun.GetTextSize(), renderArgs);
                ForegroundColor textColor = TextRendererUtil.computeTextColor(hostConfig, TextStyle.Default, textRun.GetTextColor(), renderArgs);
                TextWeight textWeight = TextRendererUtil.computeTextWeight(hostConfig, TextStyle.Default, textRun.GetTextWeight(), renderArgs);
                boolean isSubtle = TextRendererUtil.computeIsSubtle(hostConfig, TextStyle.Default, textRun.GetIsSubtle(), renderArgs);
                FontType fontType = TextRendererUtil.computeFontType(hostConfig, TextStyle.Default, textRun.GetFontType(), renderArgs);
                DateTimeParser parser = new DateTimeParser(textRun.GetLanguage());
                String formattedText = parser.GenerateString(textRun.GetTextForDateParsing());
                paragraph.append((CharSequence)formattedText);
                int spanStart = lastStringLength;
                int spanEnd = lastStringLength + formattedText.length();
                int color2 = RichTextBlockRenderer.getColor(TextRendererUtil.getTextColor(textColor, hostConfig, isSubtle, renderArgs.getContainerStyle()));
                paragraph.setSpan((Object)new ForegroundColorSpan(color2), spanStart, spanEnd, 17);
                if (textRun.GetHighlight()) {
                    int highlightColor = RichTextBlockRenderer.getColor(TextRendererUtil.getHighlightColor(textColor, hostConfig, isSubtle, renderArgs.getContainerStyle()));
                    paragraph.setSpan((Object)new BackgroundColorSpan(highlightColor), spanStart, spanEnd, 17);
                }
                if (textRun.GetStrikethrough()) {
                    paragraph.setSpan((Object)new StrikethroughSpan(), spanStart, spanEnd, 17);
                }
                if (textRun.GetUnderline()) {
                    paragraph.setSpan((Object)new UnderlineSpan(), spanStart, spanEnd, 17);
                }
                paragraph.setSpan((Object)new StyleSpan(TextRendererUtil.getTextWeight(textWeight)), spanStart, spanEnd, 17);
                if (textRun.GetItalic()) {
                    paragraph.setSpan((Object)new StyleSpan(2), spanStart, spanEnd, 17);
                }
                long size = TextRendererUtil.getTextSize(fontType, textSize, hostConfig);
                paragraph.setSpan((Object)new AbsoluteSizeSpan((int)size, true), spanStart, spanEnd, 17);
                String fontName = hostConfig.GetFontFamily(fontType);
                if (fontName.isEmpty() && fontType == FontType.Monospace) {
                    fontName = "monospace";
                }
                paragraph.setSpan((Object)new TypefaceSpan(fontName), spanStart, spanEnd, 17);
                if (textRun.GetSelectAction() != null && textRun.GetSelectAction().GetIsEnabled()) {
                    paragraph.setSpan((Object)new ActionSpan(textRun.GetSelectAction(), renderedCard, cardActionHandler), spanStart, spanEnd, 17);
                }
            }
            lastStringLength = paragraph.length();
        }
        return paragraph;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) throws Exception {
        RichTextBlock richTextBlock = Util.castTo(baseCardElement, RichTextBlock.class);
        TextView textView = new TextView(context);
        textView.setEllipsize(TextUtils.TruncateAt.END);
        textView.setHorizontallyScrolling(false);
        textView.setTag((Object)new TagContent(richTextBlock));
        TextBlockRenderer.applyHorizontalAlignment(textView, richTextBlock.GetHorizontalAlignment(), renderArgs);
        InlineVector inlines = richTextBlock.GetInlines();
        textView.setText((CharSequence)"");
        SpannableStringBuilder convertedString = this.buildSpannableParagraph(renderedCard, inlines, cardActionHandler, hostConfig, renderArgs);
        textView.append((CharSequence)convertedString);
        textView.setMovementMethod(LinkMovementMethod.getInstance());
        textView.setClickable(true);
        viewGroup.addView((View)textView);
        return textView;
    }

    private class ActionSpan
    extends ClickableSpan {
        private BaseActionElementRenderer.SelectActionOnClickListener m_actionListener;

        public ActionSpan(BaseActionElement action, RenderedAdaptiveCard renderedCard, ICardActionHandler cardActionHandler) {
            this.m_actionListener = new BaseActionElementRenderer.SelectActionOnClickListener(renderedCard, action, cardActionHandler);
        }

        public void onClick(@NonNull View widget) {
            this.m_actionListener.onClick(widget);
        }
    }
}

