/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import androidx.fragment.app.FragmentManager;
import io.adaptivecards.objectmodel.ActionAlignment;
import io.adaptivecards.objectmodel.ActionsOrientation;
import io.adaptivecards.objectmodel.BaseActionElement;
import io.adaptivecards.objectmodel.BaseActionElementVector;
import io.adaptivecards.objectmodel.BaseElement;
import io.adaptivecards.objectmodel.FallbackType;
import io.adaptivecards.objectmodel.FeatureRegistration;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.Spacing;
import io.adaptivecards.renderer.AdaptiveFallbackException;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.ChannelAdaptor;
import io.adaptivecards.renderer.IActionLayoutRenderer;
import io.adaptivecards.renderer.IBaseActionElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.registration.CardRendererRegistration;

public class ActionLayoutRenderer
implements IActionLayoutRenderer {
    private static ActionLayoutRenderer s_instance = null;

    protected ActionLayoutRenderer() {
    }

    public static ActionLayoutRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ActionLayoutRenderer();
        }
        return s_instance;
    }

    @Override
    public View renderActions(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseActionElementVector baseActionElementList, ChannelAdaptor channelAdaptor, HostConfig hostConfig, RenderArgs renderArgs) throws AdaptiveFallbackException {
        if (baseActionElementList == null) {
            return null;
        }
        long size = baseActionElementList.size();
        LinearLayout actionButtonsLayout = new LinearLayout(context);
        actionButtonsLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        int alignment = hostConfig.GetActions().getActionAlignment().swigValue();
        int actionButtonsAlignment = 0x800033;
        if (alignment == ActionAlignment.Right.swigValue()) {
            actionButtonsAlignment = 0x800005;
        } else if (alignment == ActionAlignment.Center.swigValue()) {
            actionButtonsAlignment = 1;
        }
        actionButtonsLayout.setGravity(actionButtonsAlignment);
        int actionButtonsLayoutOrientation = hostConfig.GetActions().getActionsOrientation().swigValue();
        if (actionButtonsLayoutOrientation == ActionsOrientation.Vertical.swigValue()) {
            actionButtonsLayout.setOrientation(1);
        } else {
            actionButtonsLayout.setOrientation(0);
        }
        Spacing spacing = hostConfig.GetActions().getSpacing();
        BaseCardElementRenderer.setSpacingAndSeparator(context, viewGroup, spacing, false, hostConfig, true);
        if (viewGroup != null) {
            if (actionButtonsLayoutOrientation == ActionsOrientation.Horizontal.swigValue()) {
                HorizontalScrollView actionButtonsContainer = new HorizontalScrollView(context);
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
                layoutParams.gravity = actionButtonsAlignment;
                actionButtonsContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                actionButtonsContainer.setHorizontalScrollBarEnabled(false);
                actionButtonsContainer.addView((View)actionButtonsLayout);
                viewGroup.addView((View)actionButtonsContainer);
            } else {
                viewGroup.addView((View)actionButtonsLayout);
            }
        }
        renderArgs.setAllowAboveTitleIconPlacement(true);
        int i = 0;
        while ((long)i < size) {
            BaseActionElement actionElement = baseActionElementList.get(i);
            if (actionElement.GetIconUrl().isEmpty()) {
                renderArgs.setAllowAboveTitleIconPlacement(false);
                break;
            }
            ++i;
        }
        FeatureRegistration featureRegistration = CardRendererRegistration.getInstance().getFeatureRegistration();
        int i2 = 0;
        while ((long)i2 < size) {
            block24: {
                BaseActionElement actionElement = baseActionElementList.get(i2);
                IBaseActionElementRenderer actionRenderer = CardRendererRegistration.getInstance().getActionRenderer(actionElement.GetElementTypeString());
                try {
                    if (actionRenderer == null) {
                        throw new AdaptiveFallbackException(actionElement);
                    }
                    if (featureRegistration != null && !actionElement.MeetsRequirements(featureRegistration)) {
                        throw new AdaptiveFallbackException(actionElement, featureRegistration);
                    }
                    actionRenderer.render(renderedCard, context, fragmentManager, (ViewGroup)actionButtonsLayout, actionElement, channelAdaptor, hostConfig, renderArgs);
                }
                catch (AdaptiveFallbackException e) {
                    boolean elementHasFallback;
                    boolean bl = elementHasFallback = actionElement.GetFallbackType() != FallbackType.None;
                    if (elementHasFallback) {
                        if (actionElement.GetFallbackType() != FallbackType.Content) break block24;
                        BaseElement fallbackElement = actionElement.GetFallbackContent();
                        while (fallbackElement != null) {
                            try {
                                BaseActionElement fallbackActionElement = Util.castToBaseActionElement(fallbackElement);
                                IBaseActionElementRenderer fallbackActionRenderer = CardRendererRegistration.getInstance().getActionRenderer(fallbackActionElement.GetElementTypeString());
                                if (fallbackActionRenderer == null) {
                                    throw new AdaptiveFallbackException(fallbackElement);
                                }
                                if (featureRegistration != null && !fallbackElement.MeetsRequirements(featureRegistration)) {
                                    throw new AdaptiveFallbackException(fallbackElement, featureRegistration);
                                }
                                fallbackActionRenderer.render(renderedCard, context, fragmentManager, (ViewGroup)actionButtonsLayout, fallbackActionElement, channelAdaptor, hostConfig, renderArgs);
                            }
                            catch (AdaptiveFallbackException e2) {
                                if (fallbackElement.GetFallbackType() == FallbackType.Content) {
                                    fallbackElement = fallbackElement.GetFallbackContent();
                                    continue;
                                }
                                fallbackElement = null;
                            }
                        }
                    }
                    if (renderArgs.getAncestorHasFallback()) {
                        throw e;
                    }
                    renderedCard.addWarning(new AdaptiveWarning(1, "Unsupported card element type: " + actionElement.GetElementTypeString()));
                }
            }
            ++i2;
        }
        return actionButtonsLayout;
    }
}

