/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentManager;
import io.adaptivecards.R;
import io.adaptivecards.objectmodel.ActionsOrientation;
import io.adaptivecards.objectmodel.AdaptiveCardObjectModel;
import io.adaptivecards.objectmodel.BaseActionElement;
import io.adaptivecards.objectmodel.BaseActionElementVector;
import io.adaptivecards.objectmodel.FeatureRegistration;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.Mode;
import io.adaptivecards.renderer.AdaptiveFallbackException;
import io.adaptivecards.renderer.ChannelAdaptor;
import io.adaptivecards.renderer.IActionLayoutRenderer;
import io.adaptivecards.renderer.IBaseActionElementRenderer;
import io.adaptivecards.renderer.IOverflowActionRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.registration.CardRendererRegistration;
import java.util.ArrayList;
import java.util.List;

public class OverflowActionLayoutRenderer
implements IActionLayoutRenderer {
    private static final int OVERFLOW_BUTTON_WIDTH = 48;
    private static final int OVERFLOW_BUTTON_TEXT_SIZE = 18;
    private static final String OVERFLOW_TEXT = "\u2022\u2022\u2022";
    private static final int POPUP_CONTENT_SEPARATOR_STROKE_WIDTH = 1;
    private static final int POPUP_CONTENT_SEPARATOR_BORDER_WIDTH = 2;
    private static OverflowActionLayoutRenderer s_instance = null;

    protected OverflowActionLayoutRenderer() {
    }

    public static OverflowActionLayoutRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new OverflowActionLayoutRenderer();
        }
        return s_instance;
    }

    @Override
    public View renderActions(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseActionElementVector baseActionElementList, ChannelAdaptor channelAdaptor, HostConfig hostConfig, RenderArgs renderArgs) throws AdaptiveFallbackException {
        IOverflowActionRenderer overflowActionRenderer = CardRendererRegistration.getInstance().getOverflowActionRenderer();
        List<View> menuItemList = this.renderSecondaryActionElements(baseActionElementList, renderedCard, context, fragmentManager, viewGroup, channelAdaptor, hostConfig, renderArgs);
        Button overflowActionView = null;
        try {
            if (overflowActionRenderer == null || (overflowActionView = overflowActionRenderer.onRenderOverflowAction(viewGroup, menuItemList, renderArgs.isRootLevelActions())) == null) {
                overflowActionView = this.renderDefaultOverflowAction(context, viewGroup, hostConfig);
            }
            LinearLayout contentLayout = new LinearLayout(context);
            contentLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            contentLayout.setOrientation(1);
            this.setDrawables(contentLayout);
            overflowActionView.setOnClickListener((View.OnClickListener)new OverflowActionOnClickListener(contentLayout, overflowActionRenderer, menuItemList, renderArgs.isRootLevelActions()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return overflowActionView;
    }

    private Button renderDefaultOverflowAction(@NonNull Context context, @NonNull ViewGroup viewGroup, @NonNull HostConfig hostConfig) {
        LinearLayout.LayoutParams layoutParams;
        Button overflowActionView = new Button(context);
        ActionsOrientation orientation = hostConfig.GetActions().getActionsOrientation();
        int width = Util.dpToPixels(context, 48.0f);
        if (orientation == ActionsOrientation.Horizontal) {
            layoutParams = new LinearLayout.LayoutParams(width, -1);
            long spacing = hostConfig.GetActions().getButtonSpacing();
            layoutParams.setMarginEnd(Util.dpToPixels(context, spacing));
        } else {
            layoutParams = new LinearLayout.LayoutParams(width, -1);
        }
        overflowActionView.setText((CharSequence)OVERFLOW_TEXT);
        overflowActionView.setMinWidth(0);
        overflowActionView.setMinimumWidth(0);
        overflowActionView.setGravity(81);
        overflowActionView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        overflowActionView.setTextSize(2, 18.0f);
        viewGroup.addView((View)overflowActionView);
        return overflowActionView;
    }

    private void setDrawables(@NonNull LinearLayout linearLayout) {
        ColorDrawable colorDrawable = new ColorDrawable(linearLayout.getContext().getResources().getColor(17170443));
        ShapeDrawable borderDrawable = this.getShapeDrawable(linearLayout.getContext(), linearLayout.getContext().getResources().getColor(R.color.menu_border_color), 2);
        linearLayout.setBackground((Drawable)new LayerDrawable(new Drawable[]{colorDrawable, borderDrawable}));
        linearLayout.setDividerDrawable((Drawable)this.getShapeDrawable(linearLayout.getContext(), linearLayout.getContext().getResources().getColor(R.color.menu_divider_color), 1));
        linearLayout.setShowDividers(2);
    }

    private ShapeDrawable getShapeDrawable(@NonNull Context context, int color2, int strokeWidth) {
        ShapeDrawable shapedrawable = new ShapeDrawable();
        shapedrawable.setShape((Shape)new RectShape());
        shapedrawable.getPaint().setColor(color2);
        shapedrawable.getPaint().setStrokeWidth((float)Util.dpToPixels(context, strokeWidth));
        shapedrawable.getPaint().setStyle(Paint.Style.STROKE);
        return shapedrawable;
    }

    private List<View> renderSecondaryActionElements(@NonNull BaseActionElementVector elementVector, RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup actionButtonsLayout, ChannelAdaptor channelAdaptor, HostConfig hostConfig, RenderArgs renderArgs) throws AdaptiveFallbackException {
        ArrayList<View> menuItemViewList = new ArrayList<View>();
        FeatureRegistration featureRegistration = CardRendererRegistration.getInstance().getFeatureRegistration();
        for (BaseActionElement actionElement : elementVector) {
            IBaseActionElementRenderer actionRenderer = CardRendererRegistration.getInstance().getActionRenderer(AdaptiveCardObjectModel.ModeToString(Mode.Secondary));
            try {
                if (actionRenderer == null) {
                    throw new AdaptiveFallbackException(actionElement);
                }
                if (featureRegistration != null && !actionElement.MeetsRequirements(featureRegistration)) {
                    throw new AdaptiveFallbackException(actionElement, featureRegistration);
                }
                menuItemViewList.add((View)actionRenderer.render(renderedCard, context, fragmentManager, actionButtonsLayout, actionElement, channelAdaptor, hostConfig, renderArgs));
            }
            catch (AdaptiveFallbackException e) {
                e.printStackTrace();
            }
        }
        return menuItemViewList;
    }

    private static final class OverflowActionOnClickListener
    implements View.OnClickListener {
        private final LinearLayout contentLayout;
        private final IOverflowActionRenderer overflowActionRenderer;
        private final List<View> menuItemViewList;
        private PopupWindow popupWindow;
        private int contentWidth;
        private int contentHeight;
        private boolean isRootLevelActions;

        public OverflowActionOnClickListener(LinearLayout contentLayout, IOverflowActionRenderer overflowActionRenderer, List<View> menuItemViewList, boolean isRootLevelActions) {
            this.contentLayout = contentLayout;
            this.overflowActionRenderer = overflowActionRenderer;
            this.menuItemViewList = menuItemViewList;
            this.isRootLevelActions = isRootLevelActions;
        }

        public void onClick(View v) {
            if (this.overflowActionRenderer == null || !this.overflowActionRenderer.onDisplayOverflowActionMenu(this.menuItemViewList, v, this.isRootLevelActions)) {
                if (this.popupWindow == null) {
                    for (View child : this.menuItemViewList) {
                        this.contentLayout.addView(child);
                    }
                    this.contentLayout.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                    this.contentWidth = this.contentLayout.getMeasuredWidth();
                    this.contentHeight = this.contentLayout.getMeasuredHeight();
                    this.popupWindow = new PopupWindow((View)this.contentLayout, -2, -2, true);
                    this.popupWindow.setBackgroundDrawable((Drawable)new ColorDrawable());
                    this.contentLayout.setTag((Object)this.popupWindow);
                }
                int[] location = new int[2];
                v.getLocationOnScreen(location);
                int xPos = location[0];
                int yPos = location[1];
                int screenHeight = v.getContext().getResources().getDisplayMetrics().heightPixels;
                int screenWidth = v.getContext().getResources().getDisplayMetrics().widthPixels;
                int gravity = 0x800055;
                int yOffset = 0;
                if (yPos + this.contentHeight + v.getHeight() > screenHeight) {
                    yOffset = -v.getHeight() - this.contentHeight - this.contentLayout.getPaddingBottom();
                }
                if (xPos + this.contentWidth + v.getWidth() > screenWidth) {
                    gravity = 0x800033;
                }
                this.popupWindow.showAsDropDown(v, 0, yOffset, gravity);
            }
        }
    }
}

