/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.input;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import androidx.fragment.app.FragmentManager;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.DateInput;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.ChannelAdaptor;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.input.DatePickerFragment;
import io.adaptivecards.renderer.input.TextInputRenderer;
import io.adaptivecards.renderer.inputhandler.DateInputHandler;
import io.adaptivecards.renderer.readonly.RendererUtil;
import java.text.DateFormat;

public class DateInputRenderer
extends TextInputRenderer {
    private static DateInputRenderer s_instance = null;
    private static final String TITLE = "Set Date";

    protected DateInputRenderer() {
    }

    public static DateInputRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new DateInputRenderer();
        }
        return s_instance;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, final Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ChannelAdaptor channelAdaptor, HostConfig hostConfig, RenderArgs renderArgs) throws Exception {
        if (!hostConfig.GetSupportsInteractivity()) {
            renderedCard.addWarning(new AdaptiveWarning(3, "Input.Date is not allowed"));
            return null;
        }
        DateInput dateInput = Util.castTo(baseCardElement, DateInput.class);
        DateInputHandler dateInputHandler = new DateInputHandler(dateInput, fragmentManager);
        String dateInputValue = dateInput.GetValue();
        String dateString = "";
        if (dateInputValue != null && !dateInputValue.isEmpty()) {
            dateString = DateFormat.getDateInstance().format(RendererUtil.getDate(dateInput.GetValue()).getTime());
        }
        TagContent tagContent = new TagContent((BaseCardElement)dateInput, dateInputHandler);
        EditText editText = this.renderInternal(renderedCard, context, viewGroup, dateInput, dateString, dateInput.GetPlaceholder(), dateInputHandler, hostConfig, tagContent, renderArgs, !dateInput.GetMin().isEmpty() || !dateInput.GetMax().isEmpty());
        editText.setSingleLine();
        editText.setRawInputType(0);
        editText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TagContent tagContent = (TagContent)v.getTag();
                DateInputHandler dateInputHandler = (DateInputHandler)tagContent.GetInputHandler();
                DateInput dateInput = (DateInput)dateInputHandler.getBaseInputElement();
                DatePickerFragment datePickerFragment = new DatePickerFragment();
                datePickerFragment.initialize(dateInput, (EditText)v, context);
                Bundle args = new Bundle();
                args.putString("title", DateInputRenderer.TITLE);
                datePickerFragment.setArguments(args);
                FragmentManager fm = dateInputHandler.getFragmentManager();
                datePickerFragment.show(fm, DateInputRenderer.TITLE);
            }
        });
        editText.setTag((Object)tagContent);
        DateInputRenderer.setVisibility(baseCardElement.GetIsVisible(), (View)editText);
        return editText;
    }
}

