/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.input.customcontrols;

import android.content.Context;
import android.content.res.Resources;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.core.content.ContextCompat;
import io.adaptivecards.R;
import io.adaptivecards.renderer.input.customcontrols.IValidatedInputView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0004R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/adaptivecards/renderer/input/customcontrols/ValidatedTextView;", "Landroidx/appcompat/widget/AppCompatTextView;", "Lio/adaptivecards/renderer/input/customcontrols/IValidatedInputView;", "context", "Landroid/content/Context;", "usingCustomInputs", "", "(Landroid/content/Context;Z)V", "STATE_INPUT_INVALID", "", "mIsInvalid", "mIsUsingCustomInputs", "onCreateDrawableState", "extraSpace", "", "setInputInvalid", "", "isInvalid", "setValidationResult", "isValid", "verifyIfUsingCustomInputs", "adaptivecards_release"})
public final class ValidatedTextView
extends AppCompatTextView
implements IValidatedInputView {
    private boolean mIsInvalid;
    private boolean mIsUsingCustomInputs;
    @NotNull
    private final int[] STATE_INPUT_INVALID;

    public ValidatedTextView(@NotNull Context context, boolean usingCustomInputs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        int[] nArray = new int[]{R.attr.state_error};
        this.STATE_INPUT_INVALID = nArray;
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.mIsInvalid = false;
        this.verifyIfUsingCustomInputs(context);
        this.mIsUsingCustomInputs = usingCustomInputs;
        if (this.mIsUsingCustomInputs) {
            this.setBackground(ContextCompat.getDrawable((Context)context, (int)R.drawable.adaptive_choiceset_compact_background));
        }
    }

    public final void verifyIfUsingCustomInputs(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources.Theme theme = context.getTheme();
        TypedValue isUsingCustomInputs = new TypedValue();
        this.mIsUsingCustomInputs = theme.resolveAttribute(R.attr.adaptiveUsingCustomTextInputs, isUsingCustomInputs, true) ? isUsingCustomInputs.data != 0 : false;
    }

    @Override
    public void setValidationResult(boolean isValid) {
        if (this.mIsUsingCustomInputs) {
            this.setInputInvalid(!isValid);
        }
    }

    public final void setInputInvalid(boolean isInvalid) {
        this.mIsInvalid = isInvalid;
        this.refreshDrawableState();
    }

    @Nullable
    protected int[] onCreateDrawableState(int extraSpace) {
        int[] nArray = super.onCreateDrawableState(extraSpace + 1);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"super.onCreateDrawableState(extraSpace + 1)");
        int[] drawableState = nArray;
        if (this.mIsInvalid) {
            View.mergeDrawableStates((int[])drawableState, (int[])this.STATE_INPUT_INVALID);
        }
        return drawableState;
    }
}

