/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TableRow;
import androidx.fragment.app.FragmentManager;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.BaseCardElementVector;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.HorizontalAlignment;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.Table;
import io.adaptivecards.objectmodel.TableCell;
import io.adaptivecards.objectmodel.TableColumnDefinition;
import io.adaptivecards.objectmodel.TableRow;
import io.adaptivecards.objectmodel.VerticalContentAlignment;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.ChannelAdaptor;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.readonly.ContainerRenderer;
import io.adaptivecards.renderer.readonly.TableCellRenderArgs;
import io.adaptivecards.renderer.registration.CardRendererRegistration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J*\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002JH\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)H\u0016\u00a8\u0006*"}, d2={"Lio/adaptivecards/renderer/readonly/TableCellRenderer;", "Lio/adaptivecards/renderer/BaseCardElementRenderer;", "()V", "applyBorderOrSpacing", "", "cellLayout", "Landroid/view/View;", "showGridLines", "", "borderStyle", "Lio/adaptivecards/objectmodel/ContainerStyle;", "isFirst", "isLast", "bleed", "hostConfig", "Lio/adaptivecards/objectmodel/HostConfig;", "computeHorizontalAlignment", "Lio/adaptivecards/objectmodel/HorizontalAlignment;", "row", "Lio/adaptivecards/objectmodel/TableRow;", "col", "Lio/adaptivecards/objectmodel/TableColumnDefinition;", "table", "Lio/adaptivecards/objectmodel/Table;", "computeVerticalContentAlignment", "Lio/adaptivecards/objectmodel/VerticalContentAlignment;", "declaredAlignment", "render", "renderedCard", "Lio/adaptivecards/renderer/RenderedAdaptiveCard;", "context", "Landroid/content/Context;", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "viewGroup", "Landroid/view/ViewGroup;", "baseCardElement", "Lio/adaptivecards/objectmodel/BaseCardElement;", "channelAdaptor", "Lio/adaptivecards/renderer/ChannelAdaptor;", "renderArgs", "Lio/adaptivecards/renderer/RenderArgs;", "adaptivecards_release"})
public final class TableCellRenderer
extends BaseCardElementRenderer {
    @NotNull
    public static final TableCellRenderer INSTANCE = new TableCellRenderer();

    private TableCellRenderer() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public View render(@NotNull RenderedAdaptiveCard renderedCard, @NotNull Context context, @NotNull FragmentManager fragmentManager, @NotNull ViewGroup viewGroup, @NotNull BaseCardElement baseCardElement, @NotNull ChannelAdaptor channelAdaptor, @NotNull HostConfig hostConfig, @NotNull RenderArgs renderArgs) {
        void $this$render_u24lambda_u2d3;
        ViewGroup.LayoutParams params$iv;
        boolean $i$f$updateLayoutParamsTyped;
        Intrinsics.checkNotNullParameter((Object)renderedCard, (String)"renderedCard");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"viewGroup");
        Intrinsics.checkNotNullParameter((Object)baseCardElement, (String)"baseCardElement");
        Intrinsics.checkNotNullParameter((Object)channelAdaptor, (String)"channelAdaptor");
        Intrinsics.checkNotNullParameter((Object)hostConfig, (String)"hostConfig");
        Intrinsics.checkNotNullParameter((Object)renderArgs, (String)"renderArgs");
        if (!(renderArgs instanceof TableCellRenderArgs)) {
            throw new IllegalArgumentException("renderArgs must be instance of TableCellRenderArgs");
        }
        TableRow row = ((TableCellRenderArgs)renderArgs).getTable().GetRows().get(((TableCellRenderArgs)renderArgs).getRowIndex());
        TableColumnDefinition col = ((TableCellRenderArgs)renderArgs).getTable().GetColumns().get(((TableCellRenderArgs)renderArgs).getColIndex());
        TableCell cell = Util.castTo(baseCardElement, TableCell.class);
        LinearLayout linearLayout = new LinearLayout(context);
        boolean bl = false;
        boolean bl2 = false;
        LinearLayout $this$render_u24lambda_u2d0 = linearLayout;
        boolean bl3 = false;
        $this$render_u24lambda_u2d0.setOrientation(1);
        $this$render_u24lambda_u2d0.setTag((Object)new TagContent(cell));
        $this$render_u24lambda_u2d0.setLayoutParams((ViewGroup.LayoutParams)new TableRow.LayoutParams(0, -1));
        LinearLayout cellLayout = linearLayout;
        boolean stretch = false;
        if (col.GetPixelWidth() != null) {
            View $this$updateLayoutParams$iv = (View)cellLayout;
            $i$f$updateLayoutParamsTyped = false;
            ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv.getLayoutParams();
            if (layoutParams == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.TableRow.LayoutParams");
            }
            params$iv = (ViewGroup.LayoutParams)((TableRow.LayoutParams)layoutParams);
            TableRow.LayoutParams $this$render_u24lambda_u2d1 = (TableRow.LayoutParams)params$iv;
            boolean bl4 = false;
            Long l = col.GetPixelWidth();
            Intrinsics.checkNotNull((Object)l);
            $this$render_u24lambda_u2d1.width = Util.dpToPixels(context, l.longValue());
            $this$updateLayoutParams$iv.setLayoutParams(params$iv);
        } else if (col.GetWidth() != null) {
            float f;
            View $this$updateLayoutParams$iv = (View)cellLayout;
            $i$f$updateLayoutParamsTyped = false;
            ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv.getLayoutParams();
            if (layoutParams == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.TableRow.LayoutParams");
            }
            params$iv = (ViewGroup.LayoutParams)((TableRow.LayoutParams)layoutParams);
            TableRow.LayoutParams $this$render_u24lambda_u2d2 = (TableRow.LayoutParams)params$iv;
            boolean bl5 = false;
            Long l = col.GetWidth();
            $this$render_u24lambda_u2d2.weight = l == null ? 1.0f : (f = (float)l.longValue());
            $this$updateLayoutParams$iv.setLayoutParams(params$iv);
            stretch = true;
        }
        ((TableCellRenderArgs)renderArgs).getTableLayout().setColumnShrinkable(((TableCellRenderArgs)renderArgs).getColIndex(), stretch);
        ((TableCellRenderArgs)renderArgs).getTableLayout().setColumnStretchable(((TableCellRenderArgs)renderArgs).getColIndex(), stretch);
        boolean isFirst = ((TableCellRenderArgs)renderArgs).getColIndex() == 0;
        boolean isLast = ((TableCellRenderArgs)renderArgs).getColIndex() == ((TableCellRenderArgs)renderArgs).getTable().GetColumns().size() - 1;
        this.applyBorderOrSpacing((View)cellLayout, ((TableCellRenderArgs)renderArgs).getTable().GetShowGridLines(), ((TableCellRenderArgs)renderArgs).getGridStyle(), isFirst, isLast, cell.GetBleed(), hostConfig);
        BaseCardElementRenderer.applyRtl(cell.GetRtl(), (ViewGroup)cellLayout);
        BaseCardElementRenderer.setVisibility(cell.GetIsVisible(), (View)cellLayout);
        BaseCardElementRenderer.setMinHeight(cell.GetMinHeight(), (View)cellLayout, context);
        ContainerStyle computedStyle = ContainerRenderer.getLocalContainerStyle(cell, ((TableCellRenderArgs)renderArgs).getContainerStyle());
        ContainerRenderer.applyPadding(computedStyle, ((TableCellRenderArgs)renderArgs).getContainerStyle(), (ViewGroup)cellLayout, hostConfig, ((TableCellRenderArgs)renderArgs).getTable().GetShowGridLines());
        ContainerRenderer.applyContainerStyle(computedStyle, ((TableCellRenderArgs)renderArgs).getContainerStyle(), (ViewGroup)cellLayout, hostConfig);
        VerticalContentAlignment verticalContentAlignment = cell.GetVerticalContentAlignment();
        Intrinsics.checkNotNullExpressionValue((Object)row, (String)"row");
        Intrinsics.checkNotNullExpressionValue((Object)col, (String)"col");
        ContainerRenderer.applyVerticalContentAlignment(cellLayout, this.computeVerticalContentAlignment(verticalContentAlignment, row, col, ((TableCellRenderArgs)renderArgs).getTable()));
        ContainerRenderer.setSelectAction(renderedCard, cell.GetSelectAction(), (View)cellLayout, channelAdaptor.getCardActionHandler(), renderArgs);
        RenderArgs renderArgs2 = new RenderArgs(renderArgs);
        boolean bl6 = false;
        boolean bl7 = false;
        RenderArgs renderArgs3 = renderArgs2;
        HostConfig hostConfig2 = hostConfig;
        ChannelAdaptor channelAdaptor2 = channelAdaptor;
        BaseCardElementVector baseCardElementVector = cell.GetItems();
        ViewGroup viewGroup2 = (ViewGroup)cellLayout;
        FragmentManager fragmentManager2 = fragmentManager;
        Context context2 = context;
        RenderedAdaptiveCard renderedAdaptiveCard = renderedCard;
        CardRendererRegistration cardRendererRegistration = CardRendererRegistration.getInstance();
        boolean bl8 = false;
        $this$render_u24lambda_u2d3.setContainerStyle(computedStyle);
        $this$render_u24lambda_u2d3.setHorizontalAlignment(INSTANCE.computeHorizontalAlignment(row, col, ((TableCellRenderArgs)renderArgs).getTable()));
        Unit unit = Unit.INSTANCE;
        cardRendererRegistration.renderElements(renderedAdaptiveCard, context2, fragmentManager2, viewGroup2, baseCardElementVector, channelAdaptor2, hostConfig2, renderArgs2);
        viewGroup.addView((View)cellLayout);
        return (View)cellLayout;
    }

    /*
     * WARNING - void declaration
     */
    private final void applyBorderOrSpacing(View cellLayout, boolean showGridLines, ContainerStyle borderStyle, boolean isFirst, boolean isLast, boolean bleed, HostConfig hostConfig) {
        View $this$updateLayoutParams$iv = cellLayout;
        boolean $i$f$updateLayoutParamsTyped = false;
        ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
        }
        ViewGroup.LayoutParams params$iv = (ViewGroup.LayoutParams)((ViewGroup.MarginLayoutParams)layoutParams);
        ViewGroup.MarginLayoutParams $this$applyBorderOrSpacing_u24lambda_u2d5 = (ViewGroup.MarginLayoutParams)params$iv;
        boolean bl = false;
        if (showGridLines) {
            void $this$applyBorderOrSpacing_u24lambda_u2d5_u24lambda_u2d4;
            GradientDrawable gradientDrawable = new GradientDrawable();
            boolean bl2 = false;
            boolean bl3 = false;
            GradientDrawable gradientDrawable2 = gradientDrawable;
            View view = cellLayout;
            boolean bl4 = false;
            $this$applyBorderOrSpacing_u24lambda_u2d5_u24lambda_u2d4.setShape(0);
            $this$applyBorderOrSpacing_u24lambda_u2d5_u24lambda_u2d4.setColor(0);
            int color = Color.parseColor((String)hostConfig.GetBorderColor(borderStyle));
            $this$applyBorderOrSpacing_u24lambda_u2d5_u24lambda_u2d4.setStroke(Util.dpToPixels(cellLayout.getContext(), 1.0f), color);
            Unit unit = Unit.INSTANCE;
            view.setBackground((Drawable)gradientDrawable);
        } else if (bleed) {
            int padding = Util.dpToPixels(cellLayout.getContext(), hostConfig.GetSpacing().getPaddingSpacing());
            if (isFirst) {
                $this$applyBorderOrSpacing_u24lambda_u2d5.setMarginStart(-padding);
            }
            if (isLast) {
                $this$applyBorderOrSpacing_u24lambda_u2d5.setMarginEnd(-padding);
            }
        } else {
            int spacing = Util.dpToPixels(cellLayout.getContext(), hostConfig.GetTable().getCellSpacing());
            if (!isFirst) {
                $this$applyBorderOrSpacing_u24lambda_u2d5.setMarginStart(spacing / 2);
            }
            if (!isLast) {
                $this$applyBorderOrSpacing_u24lambda_u2d5.setMarginEnd(spacing / 2);
            }
        }
        $this$updateLayoutParams$iv.setLayoutParams(params$iv);
    }

    private final VerticalContentAlignment computeVerticalContentAlignment(VerticalContentAlignment declaredAlignment, TableRow row, TableColumnDefinition col, Table table) {
        VerticalContentAlignment verticalContentAlignment;
        VerticalContentAlignment verticalContentAlignment2;
        VerticalContentAlignment verticalContentAlignment3 = declaredAlignment;
        VerticalContentAlignment verticalContentAlignment4 = verticalContentAlignment3 == null ? ((verticalContentAlignment2 = row.GetVerticalCellContentAlignment()) == null ? col.GetVerticalCellContentAlignment() : verticalContentAlignment2) : (verticalContentAlignment = verticalContentAlignment3);
        return verticalContentAlignment == null ? ((verticalContentAlignment3 = table.GetVerticalCellContentAlignment()) == null ? VerticalContentAlignment.Top : verticalContentAlignment3) : verticalContentAlignment;
    }

    private final HorizontalAlignment computeHorizontalAlignment(TableRow row, TableColumnDefinition col, Table table) {
        HorizontalAlignment horizontalAlignment;
        HorizontalAlignment horizontalAlignment2 = row.GetHorizontalCellContentAlignment();
        HorizontalAlignment horizontalAlignment3 = horizontalAlignment2 == null ? ((horizontalAlignment = col.GetHorizontalCellContentAlignment()) == null ? table.GetHorizontalCellContentAlignment() : horizontalAlignment) : horizontalAlignment2;
        return horizontalAlignment3 == null ? HorizontalAlignment.Left : horizontalAlignment3;
    }
}

