/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TableLayout;
import androidx.fragment.app.FragmentManager;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.CardElementType;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.Table;
import io.adaptivecards.objectmodel.TableCell;
import io.adaptivecards.objectmodel.TableRow;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.ChannelAdaptor;
import io.adaptivecards.renderer.IBaseCardElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.readonly.ContainerRenderer;
import io.adaptivecards.renderer.readonly.TableCellRenderArgs;
import io.adaptivecards.renderer.registration.CardRendererRegistration;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lio/adaptivecards/renderer/readonly/TableRenderer;", "Lio/adaptivecards/renderer/BaseCardElementRenderer;", "()V", "render", "Landroid/view/View;", "renderedCard", "Lio/adaptivecards/renderer/RenderedAdaptiveCard;", "context", "Landroid/content/Context;", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "viewGroup", "Landroid/view/ViewGroup;", "baseCardElement", "Lio/adaptivecards/objectmodel/BaseCardElement;", "channelAdaptor", "Lio/adaptivecards/renderer/ChannelAdaptor;", "hostConfig", "Lio/adaptivecards/objectmodel/HostConfig;", "renderArgs", "Lio/adaptivecards/renderer/RenderArgs;", "adaptivecards_release"})
public final class TableRenderer
extends BaseCardElementRenderer {
    @NotNull
    public static final TableRenderer INSTANCE = new TableRenderer();

    private TableRenderer() {
    }

    @Override
    @NotNull
    public View render(@NotNull RenderedAdaptiveCard renderedCard, @NotNull Context context, @NotNull FragmentManager fragmentManager, @NotNull ViewGroup viewGroup, @NotNull BaseCardElement baseCardElement, @NotNull ChannelAdaptor channelAdaptor, @NotNull HostConfig hostConfig, @NotNull RenderArgs renderArgs) {
        Intrinsics.checkNotNullParameter((Object)renderedCard, (String)"renderedCard");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"viewGroup");
        Intrinsics.checkNotNullParameter((Object)baseCardElement, (String)"baseCardElement");
        Intrinsics.checkNotNullParameter((Object)channelAdaptor, (String)"channelAdaptor");
        Intrinsics.checkNotNullParameter((Object)hostConfig, (String)"hostConfig");
        Intrinsics.checkNotNullParameter((Object)renderArgs, (String)"renderArgs");
        Table table = Util.castTo(baseCardElement, Table.class);
        IBaseCardElementRenderer iBaseCardElementRenderer = CardRendererRegistration.getInstance().getRenderer(CardElementType.TableCell.toString());
        if (iBaseCardElementRenderer == null) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"No renderer registered for ", (Object)((Object)CardElementType.TableCell)));
        }
        IBaseCardElementRenderer tableCellRenderer = iBaseCardElementRenderer;
        TableLayout tableLayout = new TableLayout(context);
        boolean bl = false;
        int n = 0;
        TableLayout $this$render_u24lambda_u2d0 = tableLayout;
        boolean bl2 = false;
        $this$render_u24lambda_u2d0.setTag((Object)new TagContent(table));
        $this$render_u24lambda_u2d0.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        $this$render_u24lambda_u2d0.setClipChildren(false);
        $this$render_u24lambda_u2d0.setClipToPadding(false);
        TableLayout tableLayout2 = tableLayout;
        boolean isFirstRowHeader = table.GetFirstRowAsHeaders();
        ContainerStyle computedGridStyle = table.GetGridStyle() == ContainerStyle.None ? renderArgs.getContainerStyle() : table.GetGridStyle();
        n = 0;
        int n2 = table.GetRows().size() + -1;
        if (n <= n2) {
            do {
                int i = n++;
                TableRow row = table.GetRows().get(i);
                android.widget.TableRow tableRow = new android.widget.TableRow(context);
                int n3 = 0;
                int n4 = 0;
                android.widget.TableRow $this$render_u24lambda_u2d1 = tableRow;
                boolean bl3 = false;
                $this$render_u24lambda_u2d1.setClipChildren(false);
                $this$render_u24lambda_u2d1.setClipToPadding(false);
                android.widget.TableRow rowLayout = tableRow;
                ContainerStyle rowStyle = ContainerRenderer.computeContainerStyle(row.GetStyle(), renderArgs.getContainerStyle());
                ContainerRenderer.applyContainerStyle(rowStyle, renderArgs.getContainerStyle(), (ViewGroup)rowLayout, hostConfig);
                n3 = 0;
                n4 = table.GetColumns().size() + -1;
                if (n3 <= n4) {
                    do {
                        int j = n3++;
                        Object object = row.GetCells();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"row.GetCells()");
                        TableCell tableCell = (TableCell)CollectionsKt.getOrNull((List)((List)object), (int)j);
                        if (tableCell == null) break;
                        TableCell cell = tableCell;
                        Intrinsics.checkNotNullExpressionValue((Object)table, (String)"table");
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)computedGridStyle), (String)"computedGridStyle");
                        object = new TableCellRenderArgs(renderArgs, table, tableLayout2, i, j, computedGridStyle);
                        boolean bl4 = false;
                        boolean bl5 = false;
                        Object $this$render_u24lambda_u2d2 = object;
                        boolean bl6 = false;
                        ((RenderArgs)$this$render_u24lambda_u2d2).setContainerStyle(rowStyle);
                        ((RenderArgs)$this$render_u24lambda_u2d2).setColumnHeader(i == 0 && isFirstRowHeader);
                        Object cellArgs = object;
                        tableCellRenderer.render(renderedCard, context, fragmentManager, (ViewGroup)rowLayout, cell, channelAdaptor, hostConfig, (RenderArgs)cellArgs);
                    } while (n3 <= n4);
                }
                tableLayout2.addView((View)rowLayout);
            } while (n <= n2);
        }
        viewGroup.addView((View)tableLayout2);
        return (View)tableLayout2;
    }
}

