/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.typeaheadsearch;

import android.text.Html;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import androidx.annotation.ColorInt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J9\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\b2\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ,\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\nH\u0002\u00a8\u0006\u0012"}, d2={"Lio/adaptivecards/renderer/typeaheadsearch/TypeAheadHelper;", "", "()V", "createHighlightedSearchResultText", "Landroid/text/Spanned;", "text", "", "highlightTexts", "", "backgroundColor", "", "highlightTextColor", "(Ljava/lang/String;[Ljava/lang/String;II)Landroid/text/Spanned;", "highlightSpannableText", "", "spannableText", "Landroid/text/SpannableStringBuilder;", "lowerQuery", "adaptivecards_release"})
public final class TypeAheadHelper {
    @NotNull
    public static final TypeAheadHelper INSTANCE = new TypeAheadHelper();

    private TypeAheadHelper() {
    }

    @NotNull
    public final Spanned createHighlightedSearchResultText(@Nullable String text, @Nullable String[] highlightTexts, @ColorInt int backgroundColor, @ColorInt int highlightTextColor) {
        Spanned spanned;
        if (text != null) {
            CharSequence charSequence = text;
            boolean bl = false;
            if (charSequence.length() == 0) {
                return (Spanned)new SpannableString((CharSequence)"");
            }
        }
        List lowerCaseHighlightTexts = new ArrayList();
        if (highlightTexts != null) {
            Iterator iterator = ArrayIteratorKt.iterator((Object[])highlightTexts);
            while (iterator.hasNext()) {
                String highlightText = (String)iterator.next();
                Object object = highlightText;
                boolean bl = false;
                if (!(!StringsKt.isBlank((CharSequence)object))) continue;
                object = highlightText;
                bl = false;
                if (!(object.length() > 0)) continue;
                object = highlightText;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                boolean bl2 = false;
                Object object2 = object;
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string = ((String)object2).toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase(locale)");
                lowerCaseHighlightTexts.add(string);
            }
        }
        if (lowerCaseHighlightTexts.size() == 0) {
            Spanned spanned2 = Html.fromHtml((String)text);
            Intrinsics.checkNotNullExpressionValue((Object)spanned2, (String)"{\n            Html.fromHtml(text)\n        }");
            spanned = spanned2;
        } else {
            Spanned spanned3;
            try {
                SpannableStringBuilder spannableText = new SpannableStringBuilder((CharSequence)text);
                for (String lowerQuery : lowerCaseHighlightTexts) {
                    this.highlightSpannableText(spannableText, lowerQuery, backgroundColor, highlightTextColor);
                }
                spanned3 = (Spanned)spannableText;
            }
            catch (PatternSyntaxException ignored) {
                spanned3 = Html.fromHtml((String)text);
            }
            catch (IndexOutOfBoundsException ignored) {
                spanned3 = Html.fromHtml((String)text);
            }
            Spanned spanned4 = spanned3;
            Intrinsics.checkNotNullExpressionValue((Object)spanned4, (String)"try {\n            val spannableText = SpannableStringBuilder(text)\n            for (lowerQuery in lowerCaseHighlightTexts) {\n                highlightSpannableText(\n                    spannableText,\n                    lowerQuery,\n                    backgroundColor,\n                    highlightTextColor\n                )\n            }\n            spannableText\n        } catch (ignored: PatternSyntaxException) {\n            // as the user can input any string - it might lead to an invalid regex. in such case - do not highlight\n            Html.fromHtml(text)\n        } catch (ignored: IndexOutOfBoundsException) {\n            // in rare cases the index can be out of bound when setting span. in such case - do not highlight\n            Html.fromHtml(text)\n        }");
            spanned = spanned4;
        }
        return spanned;
    }

    private final void highlightSpannableText(SpannableStringBuilder spannableText, String lowerQuery, @ColorInt int backgroundColor, @ColorInt int highlightTextColor) {
        String string = spannableText.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"spannableText.toString()");
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        boolean bl = false;
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase(locale)");
        String lowerText = string2;
        int length = lowerQuery.length();
        int idx = StringsKt.indexOf$default((CharSequence)lowerText, (String)lowerQuery, (int)0, (boolean)false, (int)6, null);
        while (idx != -1) {
            StyleSpan span = new StyleSpan(1);
            spannableText.setSpan((Object)span, idx, idx + length, 33);
            spannableText.setSpan((Object)new BackgroundColorSpan(backgroundColor), idx, idx + length, 33);
            if (highlightTextColor != 0) {
                spannableText.setSpan((Object)new ForegroundColorSpan(highlightTextColor), idx, idx + length, 33);
            }
            idx = StringsKt.indexOf$default((CharSequence)lowerText, (String)lowerQuery, (int)(idx + 1), (boolean)false, (int)4, null);
        }
    }
}

