/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.typeaheadsearch;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.recyclerview.widget.RecyclerView;
import io.adaptivecards.R;
import io.adaptivecards.objectmodel.ChoiceInput;
import io.adaptivecards.renderer.SingleLiveEvent;
import io.adaptivecards.renderer.http.HttpRequestResult;
import io.adaptivecards.renderer.typeaheadsearch.DynamicTypeAheadService;
import io.adaptivecards.renderer.typeaheadsearch.DynamicTypeAheadUiState;
import io.adaptivecards.renderer.typeaheadsearch.IChoicesResolver;
import io.adaptivecards.renderer.typeaheadsearch.TypeAheadHelper;
import io.adaptivecards.renderer.typeaheadsearch.TypeAheadSearchViewModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0005J\u0006\u0010 \u001a\u00020\u000fJB\u0010!\u001a\u00020\u001e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u00192\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u00192\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u0011J\b\u0010(\u001a\u00020\u001eH\u0002R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\t\u001a\u0004\b\f\u0010\u0007R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0007R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lio/adaptivecards/renderer/typeaheadsearch/TypeAheadSearchViewModel;", "Landroidx/lifecycle/ViewModel;", "()V", "_queryText", "Lio/adaptivecards/renderer/SingleLiveEvent;", "", "get_queryText", "()Lio/adaptivecards/renderer/SingleLiveEvent;", "_queryText$delegate", "Lkotlin/Lazy;", "_uiState", "Lio/adaptivecards/renderer/typeaheadsearch/DynamicTypeAheadUiState;", "get_uiState", "_uiState$delegate", "adapter", "Lio/adaptivecards/renderer/typeaheadsearch/TypeAheadSearchViewModel$FilteredAdapter;", "count", "", "dataType", "dataset", "queryText", "getQueryText", "skip", "staticChoicesCount", "titleList", "", "uiState", "getUiState", "valueList", "clearText", "", "fetchDynamicOptions", "getAdaptor", "init", "titles", "values", "type", "set", "textColor", "textHighlightColor", "showDefaultView", "FilteredAdapter", "adaptivecards_release"})
public final class TypeAheadSearchViewModel
extends ViewModel {
    private int staticChoicesCount = 0;
    @NotNull
    private List<String> titleList;
    @NotNull
    private List<String> valueList;
    private final int count;
    private final int skip;
    private String dataset;
    private String dataType;
    private FilteredAdapter adapter;
    @NotNull
    private final Lazy _queryText$delegate = LazyKt.lazy((Function0)_queryText.2.INSTANCE);
    @NotNull
    private final Lazy _uiState$delegate = LazyKt.lazy((Function0)_uiState.2.INSTANCE);

    public TypeAheadSearchViewModel() {
        this.count = 15;
        this.titleList = new ArrayList();
        this.valueList = new ArrayList();
        this.get_queryText().setValue("");
        this.get_uiState().postValue(DynamicTypeAheadUiState.SearchOptions.INSTANCE);
    }

    @NotNull
    public final FilteredAdapter getAdaptor() {
        FilteredAdapter filteredAdapter = this.adapter;
        if (filteredAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            throw null;
        }
        return filteredAdapter;
    }

    private final SingleLiveEvent<String> get_queryText() {
        Lazy lazy = this._queryText$delegate;
        boolean bl = false;
        return (SingleLiveEvent)((Object)lazy.getValue());
    }

    private final SingleLiveEvent<DynamicTypeAheadUiState> get_uiState() {
        Lazy lazy = this._uiState$delegate;
        boolean bl = false;
        return (SingleLiveEvent)((Object)lazy.getValue());
    }

    @NotNull
    public final SingleLiveEvent<String> getQueryText() {
        return this.get_queryText();
    }

    @NotNull
    public final SingleLiveEvent<DynamicTypeAheadUiState> getUiState() {
        return this.get_uiState();
    }

    public final void init(@NotNull List<String> titles, @NotNull List<String> values, @NotNull String type, @NotNull String set, int textColor, int textHighlightColor) {
        Intrinsics.checkNotNullParameter(titles, (String)"titles");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        this.titleList = titles;
        this.valueList = values;
        this.staticChoicesCount = this.titleList.size();
        this.dataType = type;
        this.dataset = set;
        this.adapter = new FilteredAdapter(this.titleList, this.valueList, textColor, textHighlightColor);
        this.showDefaultView();
    }

    private final void showDefaultView() {
        if (this.staticChoicesCount == 0) {
            this.get_uiState().postValue(DynamicTypeAheadUiState.SearchOptions.INSTANCE);
        } else {
            this.get_uiState().postValue(DynamicTypeAheadUiState.ShowingChoices.INSTANCE);
        }
    }

    public final void fetchDynamicOptions(@NotNull String queryText) {
        Intrinsics.checkNotNullParameter((Object)queryText, (String)"queryText");
        CharSequence charSequence = queryText;
        boolean bl = false;
        if (charSequence.length() == 0) {
            this.clearText();
            return;
        }
        this.get_queryText().postValue(queryText);
        this.get_uiState().postValue(DynamicTypeAheadUiState.Loading.INSTANCE);
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.INSTANCE.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, queryText, null){
            int label;
            final /* synthetic */ TypeAheadSearchViewModel this$0;
            final /* synthetic */ String $queryText;
            {
                this.this$0 = $receiver;
                this.$queryText = $queryText;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        HttpRequestResult<List<ChoiceInput>> httpRequestResult;
                        ResultKt.throwOnFailure((Object)object);
                        IChoicesResolver iChoicesResolver = DynamicTypeAheadService.INSTANCE.getChoicesResolver();
                        if (iChoicesResolver == null) {
                            httpRequestResult = null;
                        } else {
                            String string = TypeAheadSearchViewModel.access$getDataType$p(this.this$0);
                            if (string == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"dataType");
                                throw null;
                            }
                            String string2 = string;
                            string = TypeAheadSearchViewModel.access$getDataset$p(this.this$0);
                            if (string == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"dataset");
                                throw null;
                            }
                            httpRequestResult = iChoicesResolver.getDynamicChoices(string2, string, this.$queryText, Boxing.boxInt((int)TypeAheadSearchViewModel.access$getCount$p(this.this$0)), Boxing.boxInt((int)TypeAheadSearchViewModel.access$getSkip$p(this.this$0)));
                        }
                        HttpRequestResult<List<ChoiceInput>> result = httpRequestResult;
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.INSTANCE.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(result, this.this$0, this.$queryText, null){
                            int label;
                            final /* synthetic */ HttpRequestResult<List<ChoiceInput>> $result;
                            final /* synthetic */ TypeAheadSearchViewModel this$0;
                            final /* synthetic */ String $queryText;
                            {
                                this.$result = $result;
                                this.this$0 = $receiver;
                                this.$queryText = $queryText;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        if (this.$result != null) {
                                            if (this.$result.isSuccessful() && StringsKt.equals$default((String)((String)TypeAheadSearchViewModel.access$get_queryText(this.this$0).getValue()), (String)this.$queryText, (boolean)false, (int)2, null)) {
                                                List<ChoiceInput> list = this.$result.getResult();
                                                Intrinsics.checkNotNullExpressionValue(list, (String)"result.result");
                                                List<ChoiceInput> choices = list;
                                                if (choices.size() > TypeAheadSearchViewModel.access$getCount$p(this.this$0)) {
                                                    choices = choices.subList(0, TypeAheadSearchViewModel.access$getCount$p(this.this$0));
                                                }
                                                List titles = new ArrayList<E>();
                                                List values = new ArrayList<E>();
                                                for (ChoiceInput choice : choices) {
                                                    String string = choice.GetTitle();
                                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"choice.GetTitle()");
                                                    titles.add(string);
                                                    string = choice.GetValue();
                                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"choice.GetValue()");
                                                    values.add(string);
                                                }
                                                Object object3 = TypeAheadSearchViewModel.access$getAdapter$p(this.this$0);
                                                if (object3 == null) {
                                                    Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
                                                    throw null;
                                                }
                                                ((FilteredAdapter)((Object)object3)).setQuery((String)TypeAheadSearchViewModel.access$get_queryText(this.this$0).getValue());
                                                object3 = TypeAheadSearchViewModel.access$getAdapter$p(this.this$0);
                                                if (object3 == null) {
                                                    Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
                                                    throw null;
                                                }
                                                ((FilteredAdapter)((Object)object3)).setChoices(titles, values);
                                                object3 = values;
                                                boolean bl = false;
                                                if (!object3.isEmpty()) {
                                                    TypeAheadSearchViewModel.access$get_uiState(this.this$0).postValue(DynamicTypeAheadUiState.ShowingChoices.INSTANCE);
                                                } else {
                                                    TypeAheadSearchViewModel.access$get_uiState(this.this$0).postValue(DynamicTypeAheadUiState.NoResults.INSTANCE);
                                                }
                                            } else if (StringsKt.equals$default((String)((String)TypeAheadSearchViewModel.access$get_queryText(this.this$0).getValue()), (String)this.$queryText, (boolean)false, (int)2, null)) {
                                                FilteredAdapter filteredAdapter = TypeAheadSearchViewModel.access$getAdapter$p(this.this$0);
                                                if (filteredAdapter == null) {
                                                    Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
                                                    throw null;
                                                }
                                                filteredAdapter.setQuery((String)TypeAheadSearchViewModel.access$get_queryText(this.this$0).getValue());
                                                filteredAdapter = TypeAheadSearchViewModel.access$getAdapter$p(this.this$0);
                                                if (filteredAdapter == null) {
                                                    Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
                                                    throw null;
                                                }
                                                filteredAdapter.setChoices((List<String>)new ArrayList<E>(), (List<String>)new ArrayList<E>());
                                                TypeAheadSearchViewModel.access$get_uiState(this.this$0).postValue(new DynamicTypeAheadUiState.Error(this.$result.getErrorMessage()));
                                            }
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void clearText() {
        this.getQueryText().postValue("");
        FilteredAdapter filteredAdapter = this.adapter;
        if (filteredAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            throw null;
        }
        filteredAdapter.setQuery((String)this.get_queryText().getValue());
        filteredAdapter = this.adapter;
        if (filteredAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            throw null;
        }
        filteredAdapter.setChoices(this.titleList, this.valueList);
        this.showDefaultView();
    }

    public static final /* synthetic */ String access$getDataType$p(TypeAheadSearchViewModel $this) {
        return $this.dataType;
    }

    public static final /* synthetic */ String access$getDataset$p(TypeAheadSearchViewModel $this) {
        return $this.dataset;
    }

    public static final /* synthetic */ int access$getCount$p(TypeAheadSearchViewModel $this) {
        return $this.count;
    }

    public static final /* synthetic */ int access$getSkip$p(TypeAheadSearchViewModel $this) {
        return $this.skip;
    }

    public static final /* synthetic */ SingleLiveEvent access$get_queryText(TypeAheadSearchViewModel $this) {
        return $this.get_queryText();
    }

    public static final /* synthetic */ FilteredAdapter access$getAdapter$p(TypeAheadSearchViewModel $this) {
        return $this.adapter;
    }

    public static final /* synthetic */ SingleLiveEvent access$get_uiState(TypeAheadSearchViewModel $this) {
        return $this.get_uiState();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0001\u001cB1\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000e\u001a\u00020\bH\u0016J\u001c\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u001c\u0010\u0013\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0016J$\u0010\u0017\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007J\u0010\u0010\u001a\u001a\u00020\u00102\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/adaptivecards/renderer/typeaheadsearch/TypeAheadSearchViewModel$FilteredAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lio/adaptivecards/renderer/typeaheadsearch/TypeAheadSearchViewModel$FilteredAdapter$ViewHolder;", "m_choices", "", "", "m_values", "textColor", "", "textHighlightColor", "(Ljava/util/List;Ljava/util/List;II)V", "delayTimeInMilliSeconds", "", "queryText", "getItemCount", "onBindViewHolder", "", "viewHolder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setChoices", "choices", "values", "setQuery", "query", "ViewHolder", "adaptivecards_release"})
    public static final class FilteredAdapter
    extends RecyclerView.Adapter<ViewHolder> {
        @NotNull
        private List<String> m_choices;
        @NotNull
        private List<String> m_values;
        private int textColor;
        private int textHighlightColor;
        private final long delayTimeInMilliSeconds;
        @NotNull
        private String queryText;

        public FilteredAdapter(@NotNull List<String> m_choices, @NotNull List<String> m_values, int textColor, int textHighlightColor) {
            Intrinsics.checkNotNullParameter(m_choices, (String)"m_choices");
            Intrinsics.checkNotNullParameter(m_values, (String)"m_values");
            this.m_choices = m_choices;
            this.m_values = m_values;
            this.textColor = textColor;
            this.textHighlightColor = textHighlightColor;
            this.delayTimeInMilliSeconds = 100L;
            this.queryText = "";
        }

        public final void setQuery(@Nullable String query) {
            if (query != null) {
                this.queryText = query;
            }
        }

        @SuppressLint(value={"NotifyDataSetChanged"})
        public final void setChoices(@NotNull List<String> choices, @NotNull List<String> values) {
            Intrinsics.checkNotNullParameter(choices, (String)"choices");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            this.m_choices = choices;
            this.m_values = values;
            this.notifyDataSetChanged();
        }

        @NotNull
        public ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Context context = parent.getContext();
            LayoutInflater inflater = LayoutInflater.from((Context)context);
            View choicesView = inflater.inflate(R.layout.adaptive_card_select_item, parent, false);
            ((TextView)choicesView.findViewById(R.id.choiceTitle)).setTextColor(this.textColor);
            Intrinsics.checkNotNullExpressionValue((Object)choicesView, (String)"choicesView");
            return new ViewHolder(choicesView);
        }

        public void onBindViewHolder(@NotNull ViewHolder viewHolder, int position) {
            Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"viewHolder");
            String[] title = this.m_choices.get(position);
            String value = this.m_values.get(position);
            TextView textView = viewHolder.getTextView();
            String[] stringArray = title;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            boolean bl = false;
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string = stringArray.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase(locale)");
            stringArray = new String[]{this.queryText};
            textView.setText((CharSequence)TypeAheadHelper.INSTANCE.createHighlightedSearchResultText(string, stringArray, ContextCompat.getColor((Context)textView.getContext(), (int)17170445), this.textHighlightColor));
            textView.setOnClickListener(arg_0 -> FilteredAdapter.onBindViewHolder$lambda-1(this, (String)title, value, arg_0));
        }

        public int getItemCount() {
            return this.m_choices.size();
        }

        private static final void onBindViewHolder$lambda-1$lambda-0(View $it, String $title, String $value) {
            Intrinsics.checkNotNullParameter((Object)$title, (String)"$title");
            Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
            Context context = $it.getContext();
            if (context == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.Activity");
            }
            Activity activity = (Activity)context;
            Intent intent = activity.getIntent();
            intent.putExtra("typeAheadSearchSelectedKey", $title);
            intent.putExtra("typeAheadSearchSelectedValue", $value);
            activity.setResult(-1, intent);
            activity.finish();
        }

        private static final void onBindViewHolder$lambda-1(FilteredAdapter this$0, String $title, String $value, View it) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$title, (String)"$title");
            Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
            if (it.getContext() instanceof Activity) {
                it.postDelayed(() -> FilteredAdapter.onBindViewHolder$lambda-1$lambda-0(it, $title, $value), this$0.delayTimeInMilliSeconds);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lio/adaptivecards/renderer/typeaheadsearch/TypeAheadSearchViewModel$FilteredAdapter$ViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Lio/adaptivecards/renderer/typeaheadsearch/TypeAheadSearchViewModel$FilteredAdapter;Landroid/view/View;)V", "textView", "Landroid/widget/TextView;", "getTextView", "()Landroid/widget/TextView;", "adaptivecards_release"})
        public final class ViewHolder
        extends RecyclerView.ViewHolder {
            @NotNull
            private final TextView textView;

            public ViewHolder(View itemView) {
                Intrinsics.checkNotNullParameter((Object)((Object)FilteredAdapter.this), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
                super(itemView);
                View view = itemView.findViewById(R.id.choiceTitle);
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.choiceTitle)");
                this.textView = (TextView)view;
            }

            @NotNull
            public final TextView getTextView() {
                return this.textView;
            }
        }
    }
}

