/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.objectmodel;

import io.adaptivecards.objectmodel.AdaptiveCardObjectModelJNI;
import io.adaptivecards.objectmodel.Image;
import java.util.AbstractList;
import java.util.RandomAccess;

public class ImageVector
extends AbstractList<Image>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected ImageVector(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(ImageVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(ImageVector obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                AdaptiveCardObjectModelJNI.delete_ImageVector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public ImageVector(Image[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (Image element : initialElements) {
            this.add(element);
        }
    }

    public ImageVector(Iterable<Image> initialElements) {
        this();
        for (Image element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public Image get(int index) {
        return this.doGet(index);
    }

    @Override
    public Image set(int index, Image e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(Image e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, Image e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public Image remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public ImageVector() {
        this(AdaptiveCardObjectModelJNI.new_ImageVector__SWIG_0(), true);
    }

    public ImageVector(ImageVector other) {
        this(AdaptiveCardObjectModelJNI.new_ImageVector__SWIG_1(ImageVector.getCPtr(other), other), true);
    }

    public long capacity() {
        return AdaptiveCardObjectModelJNI.ImageVector_capacity(this.swigCPtr, this);
    }

    public void reserve(long n) {
        AdaptiveCardObjectModelJNI.ImageVector_reserve(this.swigCPtr, this, n);
    }

    @Override
    public boolean isEmpty() {
        return AdaptiveCardObjectModelJNI.ImageVector_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        AdaptiveCardObjectModelJNI.ImageVector_clear(this.swigCPtr, this);
    }

    public ImageVector(int count, Image value) {
        this(AdaptiveCardObjectModelJNI.new_ImageVector__SWIG_2(count, Image.getCPtr(value), value), true);
    }

    private int doSize() {
        return AdaptiveCardObjectModelJNI.ImageVector_doSize(this.swigCPtr, this);
    }

    private void doAdd(Image x) {
        AdaptiveCardObjectModelJNI.ImageVector_doAdd__SWIG_0(this.swigCPtr, this, Image.getCPtr(x), x);
    }

    private void doAdd(int index, Image x) {
        AdaptiveCardObjectModelJNI.ImageVector_doAdd__SWIG_1(this.swigCPtr, this, index, Image.getCPtr(x), x);
    }

    private Image doRemove(int index) {
        long cPtr = AdaptiveCardObjectModelJNI.ImageVector_doRemove(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new Image(cPtr, true);
    }

    private Image doGet(int index) {
        long cPtr = AdaptiveCardObjectModelJNI.ImageVector_doGet(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new Image(cPtr, true);
    }

    private Image doSet(int index, Image val) {
        long cPtr = AdaptiveCardObjectModelJNI.ImageVector_doSet(this.swigCPtr, this, index, Image.getCPtr(val), val);
        return cPtr == 0L ? null : new Image(cPtr, true);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        AdaptiveCardObjectModelJNI.ImageVector_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

