/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.view.View;
import android.view.ViewGroup;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.renderer.inputhandler.IInputHandler;

public class TagContent {
    private boolean m_isSeparator = false;
    private String m_id = null;
    private BaseCardElement m_baseElement = null;
    private IInputHandler m_inputHandler = null;
    private ViewGroup m_viewContainer = null;
    private View m_separatorView = null;
    private View m_stretchContainer = null;

    public TagContent(boolean isSeparator) {
        this.m_isSeparator = isSeparator;
    }

    public TagContent(String id) {
        this.m_id = id;
    }

    public TagContent(BaseCardElement baseCardElement) {
        this(false);
        this.m_baseElement = baseCardElement;
    }

    public TagContent(BaseCardElement baseCardElement, IInputHandler inputHandler) {
        this.m_baseElement = baseCardElement;
        this.m_inputHandler = inputHandler;
    }

    @Deprecated
    public TagContent(BaseCardElement baseCardElement, ViewGroup viewContainer) {
        this(baseCardElement);
        this.m_viewContainer = viewContainer;
    }

    @Deprecated
    public TagContent(BaseCardElement baseCardElement, View separatorView, ViewGroup viewContainer) {
        this(baseCardElement, viewContainer);
        this.m_separatorView = separatorView;
    }

    public String GetId() {
        if (this.m_baseElement != null) {
            return this.m_baseElement.GetId();
        }
        return this.m_id;
    }

    public BaseCardElement GetBaseElement() {
        return this.m_baseElement;
    }

    public IInputHandler GetInputHandler() {
        return this.m_inputHandler;
    }

    public boolean IsSeparator() {
        return this.m_isSeparator;
    }

    public void SetSeparator(View separator) {
        this.m_separatorView = separator;
    }

    public View GetSeparator() {
        return this.m_separatorView;
    }

    public void SetViewContainer(ViewGroup viewContainer) {
        this.m_viewContainer = viewContainer;
    }

    public ViewGroup GetViewContainer() {
        return this.m_viewContainer;
    }

    public View GetStretchContainer() {
        return this.m_stretchContainer;
    }

    public void SetStretchContainer(View stretchContainer) {
        this.m_stretchContainer = stretchContainer;
    }

    public boolean equals(Object o) {
        if (o != null) {
            if (o instanceof TagContent) {
                TagContent tagContentCmp = (TagContent)o;
                String id = this.GetId();
                if (id != null && !id.isEmpty()) {
                    return id.equals(tagContentCmp.GetId());
                }
                return false;
            }
            return false;
        }
        return false;
    }
}

