/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.input;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.Filter;
import android.widget.ListAdapter;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentManager;
import io.adaptivecards.R;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.ChoiceInput;
import io.adaptivecards.objectmodel.ChoiceInputVector;
import io.adaptivecards.objectmodel.ChoiceSetInput;
import io.adaptivecards.objectmodel.ChoiceSetStyle;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.ForegroundColor;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.input.customcontrols.ValidatedAutoCompleteTextView;
import io.adaptivecards.renderer.input.customcontrols.ValidatedCheckBoxLayout;
import io.adaptivecards.renderer.input.customcontrols.ValidatedRadioGroup;
import io.adaptivecards.renderer.input.customcontrols.ValidatedSpinner;
import io.adaptivecards.renderer.input.customcontrols.ValidatedSpinnerLayout;
import io.adaptivecards.renderer.inputhandler.AutoCompleteTextViewHandler;
import io.adaptivecards.renderer.inputhandler.CheckBoxSetInputHandler;
import io.adaptivecards.renderer.inputhandler.ComboBoxInputHandler;
import io.adaptivecards.renderer.inputhandler.IInputHandler;
import io.adaptivecards.renderer.inputhandler.RadioGroupInputHandler;
import io.adaptivecards.renderer.registration.CardRendererRegistration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ChoiceSetInputRenderer
extends BaseCardElementRenderer {
    private static ChoiceSetInputRenderer s_instance = null;

    protected ChoiceSetInputRenderer() {
    }

    public boolean isUsingCustomInputs(Context context) {
        TypedValue isUsingCustomInputs;
        Resources.Theme theme = context.getTheme();
        if (theme.resolveAttribute(R.attr.adaptiveUsingCustomChoiceSetInputs, isUsingCustomInputs = new TypedValue(), true)) {
            return isUsingCustomInputs.data != 0;
        }
        return false;
    }

    public static ChoiceSetInputRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ChoiceSetInputRenderer();
        }
        return s_instance;
    }

    public View renderCheckBoxSet(RenderedAdaptiveCard renderedCard, Context context, ChoiceSetInput choiceSetInput, HostConfig hostConfig, RenderArgs renderArgs) {
        ValidatedCheckBoxLayout checkBoxLayout = new ValidatedCheckBoxLayout(context, ChoiceSetInputRenderer.getColor(hostConfig.GetForegroundColor(ContainerStyle.Default, ForegroundColor.Attention, false)));
        Vector<CheckBox> checkBoxList = new Vector<CheckBox>();
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        long size = choiceInputVector.size();
        String value = choiceSetInput.GetValue();
        Vector<String> defaults = new Vector<String>();
        defaults.addAll(Arrays.asList(value.split(",")));
        final CheckBoxSetInputHandler checkBoxSetInputHandler = new CheckBoxSetInputHandler(choiceSetInput, checkBoxList);
        checkBoxSetInputHandler.setView((View)checkBoxLayout);
        checkBoxLayout.setTag(new TagContent((BaseCardElement)choiceSetInput, checkBoxSetInputHandler));
        int i = 0;
        while ((long)i < size) {
            ChoiceInput choiceInput = choiceInputVector.get(i);
            CheckBox checkBox = new CheckBox(context);
            checkBox.setMinimumHeight(context.getResources().getDimensionPixelSize(R.dimen.check_box_min_height));
            checkBox.setText((CharSequence)choiceInput.GetTitle());
            if (!choiceSetInput.GetWrap()) {
                checkBox.setMaxLines(1);
                checkBox.setEllipsize(TextUtils.TruncateAt.END);
            }
            if (defaults.contains(choiceInput.GetValue())) {
                checkBox.setChecked(true);
            }
            checkBoxList.add(checkBox);
            checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    CardRendererRegistration.getInstance().notifyInputChange(checkBoxSetInputHandler.getId(), checkBoxSetInputHandler.getInput());
                }
            });
            checkBox.setOnTouchListener(new FocusableChoiceListener<CheckBox>((CheckBox)checkBoxList.get(0)));
            checkBoxLayout.addView((View)checkBox);
            ++i;
        }
        renderedCard.registerInputHandler((IInputHandler)checkBoxSetInputHandler, renderArgs.getContainerCardId());
        return checkBoxLayout;
    }

    public View renderRadioGroup(RenderedAdaptiveCard renderedCard, Context context, ChoiceSetInput choiceSetInput, HostConfig hostConfig, RenderArgs renderArgs) {
        ValidatedRadioGroup radioGroup = new ValidatedRadioGroup(context, ChoiceSetInputRenderer.getColor(hostConfig.GetForegroundColor(ContainerStyle.Default, ForegroundColor.Attention, false)));
        final RadioGroupInputHandler radioGroupInputHandler = new RadioGroupInputHandler(choiceSetInput);
        radioGroupInputHandler.setView((View)radioGroup);
        radioGroup.setTag(new TagContent((BaseCardElement)choiceSetInput, radioGroupInputHandler));
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        long size = choiceInputVector.size();
        String value = choiceSetInput.GetValue();
        int i = 0;
        while ((long)i < size) {
            ChoiceInput choiceInput = choiceInputVector.get(i);
            RadioButton radioButton = new RadioButton(context);
            ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -2);
            radioButton.setLayoutParams(params);
            radioButton.setMinimumHeight(context.getResources().getDimensionPixelSize(R.dimen.radio_button_min_height));
            radioButton.setId(i);
            if (!choiceSetInput.GetWrap()) {
                radioButton.setMaxLines(1);
                radioButton.setEllipsize(TextUtils.TruncateAt.END);
            }
            radioButton.setText((CharSequence)choiceInput.GetTitle());
            if (choiceInput.GetValue().equals(value)) {
                radioButton.setChecked(true);
            }
            radioGroup.addView((View)radioButton);
            radioButton.setOnTouchListener(new FocusableChoiceListener<RadioButton>((RadioButton)radioGroup.getChildAt(0)));
            ++i;
        }
        renderedCard.registerInputHandler((IInputHandler)radioGroupInputHandler, renderArgs.getContainerCardId());
        radioGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup group, int checkedId) {
                CardRendererRegistration.getInstance().notifyInputChange(radioGroupInputHandler.getId(), radioGroupInputHandler.getInput());
            }
        });
        return radioGroup;
    }

    public View renderComboBox(RenderedAdaptiveCard renderedCard, final Context context, ChoiceSetInput choiceSetInput, HostConfig hostConfig, RenderArgs renderArgs) {
        boolean needsOuterLayout;
        Vector<String> titleList = new Vector<String>();
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        long size = choiceInputVector.size();
        int selection = 0;
        String value = choiceSetInput.GetValue();
        int i = 0;
        while ((long)i < size) {
            ChoiceInput choiceInput = choiceInputVector.get(i);
            titleList.addElement(choiceInput.GetTitle());
            if (choiceInput.GetValue().equals(value)) {
                selection = i;
            }
            ++i;
        }
        boolean hasEmptyDefault = value.isEmpty();
        if (hasEmptyDefault) {
            String placeholder = choiceSetInput.GetPlaceholder();
            if (placeholder.isEmpty()) {
                placeholder = " ";
            }
            titleList.addElement(placeholder);
            selection = (int)size;
        }
        boolean usingCustomInputs = this.isUsingCustomInputs(context);
        ValidatedSpinner spinner = new ValidatedSpinner(context, usingCustomInputs);
        final ComboBoxInputHandler comboBoxInputHandler = new ComboBoxInputHandler(choiceSetInput);
        boolean isRequired = choiceSetInput.GetIsRequired();
        ValidatedSpinnerLayout inputLayout = null;
        boolean bl = needsOuterLayout = isRequired && !usingCustomInputs;
        if (needsOuterLayout) {
            inputLayout = new ValidatedSpinnerLayout(context, ChoiceSetInputRenderer.getColor(hostConfig.GetForegroundColor(ContainerStyle.Default, ForegroundColor.Attention, false)));
            inputLayout.setTag(new TagContent((BaseCardElement)choiceSetInput, comboBoxInputHandler));
            comboBoxInputHandler.setView((View)inputLayout);
        } else {
            spinner.setTag(new TagContent((BaseCardElement)choiceSetInput, comboBoxInputHandler));
            comboBoxInputHandler.setView((View)spinner);
        }
        renderedCard.registerInputHandler((IInputHandler)comboBoxInputHandler, renderArgs.getContainerCardId());
        class WrappedTextSpinnerAdapter
        extends TextSpinnerAdapter {
            WrappedTextSpinnerAdapter(Context context2, int resource, Vector<String> items, boolean hasEmptyDefault) {
                class TextSpinnerAdapter
                extends ArrayAdapter<String> {
                    private final ArrayList<String> m_items;
                    private boolean m_hasEmptyDefault;

                    TextSpinnerAdapter(Context context2, int resource, Vector<String> items, boolean hasEmptyDefault) {
                        super(context2, resource, items);
                        this.m_hasEmptyDefault = false;
                        this.m_hasEmptyDefault = hasEmptyDefault;
                        this.m_items = new ArrayList<String>(items);
                    }

                    public View getDropDownView(int position, View convertView, @NonNull ViewGroup parent) {
                        View spinnerView = super.getDropDownView(position, convertView, parent);
                        TextView spinnerTextView = (TextView)spinnerView;
                        String talkbackAnnouncement = context.getResources().getString(R.string.spinner_talkback_announcement, new Object[]{this.m_items.get(position), position + 1, this.m_items.size()});
                        spinnerTextView.setContentDescription((CharSequence)talkbackAnnouncement);
                        return spinnerView;
                    }

                    public int getCount() {
                        if (this.m_hasEmptyDefault) {
                            return this.m_items.size() - 1;
                        }
                        return this.m_items.size();
                    }
                }
                super((ChoiceSetInputRenderer)this$0, context2, resource, items, hasEmptyDefault, (Context)var6_6);
            }

            @NonNull
            public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
                View view = super.getView(position, convertView, parent);
                TextView txtView = (TextView)view.findViewById(16908308);
                txtView.setSingleLine(false);
                return view;
            }
        }
        TextSpinnerAdapter spinnerArrayAdapter = choiceSetInput.GetWrap() ? new WrappedTextSpinnerAdapter(context, 17367048, titleList, hasEmptyDefault) : new TextSpinnerAdapter(context, 17367048, titleList, hasEmptyDefault);
        spinnerArrayAdapter.setDropDownViewResource(0x1090009);
        spinner.setAdapter((SpinnerAdapter)spinnerArrayAdapter);
        spinner.setSelection(selection);
        spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                CardRendererRegistration.getInstance().notifyInputChange(comboBoxInputHandler.getId(), comboBoxInputHandler.getInput());
            }

            public void onNothingSelected(AdapterView<?> parent) {
                CardRendererRegistration.getInstance().notifyInputChange(comboBoxInputHandler.getId(), comboBoxInputHandler.getInput());
            }
        });
        spinner.setFocusable(true);
        if (needsOuterLayout) {
            inputLayout.addView((View)spinner);
            return inputLayout;
        }
        return spinner;
    }

    public View renderFilteredComboBox(RenderedAdaptiveCard renderedCard, Context context, ChoiceSetInput choiceSetInput, HostConfig hostConfig, RenderArgs renderArgs) {
        boolean needsOuterLayout;
        Vector<String> titleList = new Vector<String>();
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        long size = choiceInputVector.size();
        int valueIndex = -1;
        String value = choiceSetInput.GetValue();
        int i = 0;
        while ((long)i < size) {
            ChoiceInput choiceInput = choiceInputVector.get(i);
            titleList.addElement(choiceInput.GetTitle());
            if (choiceInput.GetValue().equals(value)) {
                valueIndex = i;
            }
            ++i;
        }
        boolean usingCustomInputs = this.isUsingCustomInputs(context);
        ValidatedAutoCompleteTextView autoCompleteTextView = new ValidatedAutoCompleteTextView(context, usingCustomInputs);
        autoCompleteTextView.setThreshold(0);
        final AutoCompleteTextViewHandler autoCompleteTextInputHandler = new AutoCompleteTextViewHandler(choiceSetInput);
        boolean isRequired = choiceSetInput.GetIsRequired();
        ValidatedSpinnerLayout inputLayout = null;
        boolean bl = needsOuterLayout = !usingCustomInputs;
        if (needsOuterLayout) {
            inputLayout = new ValidatedSpinnerLayout(context, ChoiceSetInputRenderer.getColor(hostConfig.GetForegroundColor(ContainerStyle.Default, ForegroundColor.Attention, false)));
            inputLayout.setTag(new TagContent((BaseCardElement)choiceSetInput, autoCompleteTextInputHandler));
            autoCompleteTextInputHandler.setView((View)inputLayout);
        } else {
            autoCompleteTextView.setTag(new TagContent((BaseCardElement)choiceSetInput, autoCompleteTextInputHandler));
            autoCompleteTextInputHandler.setView((View)autoCompleteTextView);
        }
        renderedCard.registerInputHandler((IInputHandler)autoCompleteTextInputHandler, renderArgs.getContainerCardId());
        class FilteredChoiceSetAdapter
        extends ArrayAdapter<String> {
            boolean m_mustWrap;
            List<String> m_items;
            List<String> m_originalItemsList;
            Filter m_substringFilter;

            FilteredChoiceSetAdapter(Context context, int resource, Vector<String> items, boolean mustWrap) {
                super(context, resource, items);
                this.m_mustWrap = false;
                this.m_substringFilter = new Filter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected Filter.FilterResults performFiltering(CharSequence constraint) {
                        Filter.FilterResults filterResults;
                        Filter.FilterResults filterResults2 = filterResults = new Filter.FilterResults();
                        synchronized (filterResults2) {
                            List<Object> filteredSuggestions = new ArrayList();
                            if (!TextUtils.isEmpty((CharSequence)constraint)) {
                                String lowerCaseConstraint = constraint.toString().toLowerCase();
                                if (Build.VERSION.SDK_INT >= 24) {
                                    Predicate<String> bySubstring = choice -> choice.toLowerCase().contains(lowerCaseConstraint);
                                    filteredSuggestions = m_originalItemsList.stream().filter(bySubstring).collect(Collectors.toList());
                                } else {
                                    for (String choice2 : m_originalItemsList) {
                                        if (!choice2.toLowerCase().contains(lowerCaseConstraint)) continue;
                                        filteredSuggestions.add(choice2);
                                    }
                                }
                            } else {
                                filteredSuggestions = m_originalItemsList;
                            }
                            filterResults.values = filteredSuggestions;
                            filterResults.count = filteredSuggestions.size();
                            return filterResults;
                        }
                    }

                    protected void publishResults(CharSequence constraint, Filter.FilterResults filterResults) {
                        if (filterResults != null && filterResults.count > 0) {
                            m_items = (ArrayList)filterResults.values;
                            this.notifyDataSetChanged();
                        } else {
                            this.notifyDataSetInvalidated();
                        }
                    }
                };
                this.m_mustWrap = mustWrap;
                this.m_items = items;
                this.m_originalItemsList = new ArrayList<String>(items);
            }

            public int getCount() {
                return this.m_items.size();
            }

            public String getItem(int pos) {
                return this.m_items.get(pos);
            }

            @NonNull
            public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
                View view = super.getView(position, convertView, parent);
                TextView txtView = (TextView)view.findViewById(16908308);
                if (this.m_mustWrap) {
                    txtView.setSingleLine(false);
                }
                return view;
            }

            @NonNull
            public Filter getFilter() {
                return this.m_substringFilter;
            }
        }
        autoCompleteTextView.setAdapter((ListAdapter)new FilteredChoiceSetAdapter(context, 0x1090011, titleList, choiceSetInput.GetWrap()));
        autoCompleteTextView.setFocusable(true);
        if (valueIndex != -1) {
            autoCompleteTextView.setText(titleList.get(valueIndex));
        }
        autoCompleteTextView.setOnTouchListener(new View.OnTouchListener((AutoCompleteTextView)autoCompleteTextView){
            final /* synthetic */ AutoCompleteTextView val$autoCompleteTextView;
            {
                this.val$autoCompleteTextView = autoCompleteTextView;
            }

            public boolean onTouch(View v, MotionEvent event) {
                this.val$autoCompleteTextView.showDropDown();
                return false;
            }
        });
        autoCompleteTextView.setOnKeyListener(new View.OnKeyListener((AutoCompleteTextView)autoCompleteTextView){
            final /* synthetic */ AutoCompleteTextView val$autoCompleteTextView;
            {
                this.val$autoCompleteTextView = autoCompleteTextView;
            }

            public boolean onKey(View view, int i, KeyEvent keyEvent) {
                this.val$autoCompleteTextView.showDropDown();
                return false;
            }
        });
        autoCompleteTextView.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                CardRendererRegistration.getInstance().notifyInputChange(autoCompleteTextInputHandler.getId(), autoCompleteTextInputHandler.getInput());
            }

            public void onNothingSelected(AdapterView<?> parent) {
                CardRendererRegistration.getInstance().notifyInputChange(autoCompleteTextInputHandler.getId(), autoCompleteTextInputHandler.getInput());
            }
        });
        if (needsOuterLayout) {
            inputLayout.addView((View)autoCompleteTextView);
            return inputLayout;
        }
        return autoCompleteTextView;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) throws Exception {
        if (!hostConfig.GetSupportsInteractivity()) {
            renderedCard.addWarning(new AdaptiveWarning(3, "Input.ChoiceSet is not allowed"));
            return null;
        }
        ChoiceSetInput choiceSetInput = Util.castTo(baseCardElement, ChoiceSetInput.class);
        View inputView = null;
        if (choiceSetInput.GetIsMultiSelect()) {
            inputView = this.renderCheckBoxSet(renderedCard, context, choiceSetInput, hostConfig, renderArgs);
        } else if (choiceSetInput.GetChoiceSetStyle() == ChoiceSetStyle.Expanded) {
            inputView = this.renderRadioGroup(renderedCard, context, choiceSetInput, hostConfig, renderArgs);
        } else if (choiceSetInput.GetChoiceSetStyle() == ChoiceSetStyle.Compact) {
            inputView = this.renderComboBox(renderedCard, context, choiceSetInput, hostConfig, renderArgs);
        } else if (choiceSetInput.GetChoiceSetStyle() == ChoiceSetStyle.Filtered) {
            inputView = this.renderFilteredComboBox(renderedCard, context, choiceSetInput, hostConfig, renderArgs);
        } else {
            throw new IllegalArgumentException("ChoiceSet Input, " + choiceSetInput.GetId() + ", contains invalid style, " + choiceSetInput.GetChoiceSetStyle().toString() + ".");
        }
        viewGroup.addView(inputView);
        return inputView;
    }

    public static class FocusableChoiceListener<T extends CompoundButton>
    implements View.OnTouchListener {
        private T m_firstView;

        public FocusableChoiceListener(T firstView) {
            this.m_firstView = firstView;
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            if (motionEvent.getAction() == 1) {
                this.m_firstView.setFocusableInTouchMode(false);
                this.m_firstView.clearFocus();
                CompoundButton clickableElement = (CompoundButton)view;
                if (clickableElement instanceof CheckBox) {
                    clickableElement.setChecked(!clickableElement.isChecked());
                } else {
                    clickableElement.setChecked(true);
                }
            }
            return true;
        }
    }
}

