/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.fragment.app.FragmentManager;
import com.google.android.flexbox.FlexboxLayout;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.CardElementType;
import io.adaptivecards.objectmodel.Column;
import io.adaptivecards.objectmodel.ColumnSet;
import io.adaptivecards.objectmodel.ColumnVector;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.FeatureRegistration;
import io.adaptivecards.objectmodel.HeightType;
import io.adaptivecards.objectmodel.HorizontalAlignment;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.IBaseCardElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.layout.SelectableFlexboxLayout;
import io.adaptivecards.renderer.readonly.ColumnRenderer;
import io.adaptivecards.renderer.readonly.ContainerRenderer;
import io.adaptivecards.renderer.registration.CardRendererRegistration;

public class ColumnSetRenderer
extends BaseCardElementRenderer {
    private static ColumnSetRenderer s_instance = null;

    protected ColumnSetRenderer() {
    }

    public static ColumnSetRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ColumnSetRenderer();
        }
        return s_instance;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) throws Exception {
        ColumnSet columnSet = Util.castTo(baseCardElement, ColumnSet.class);
        IBaseCardElementRenderer columnRenderer = CardRendererRegistration.getInstance().getRenderer(CardElementType.Column.toString());
        if (columnRenderer == null) {
            throw new UnknownError(CardElementType.Column.toString() + " is not a registered renderer.");
        }
        ColumnVector columnVector = columnSet.GetColumns();
        long columnVectorSize = columnVector.size();
        SelectableFlexboxLayout columnSetLayout = new SelectableFlexboxLayout(context);
        columnSetLayout.setFlexWrap(0);
        columnSetLayout.setFlexDirection(0);
        columnSetLayout.setFocusable(true);
        columnSetLayout.setFocusableInTouchMode(true);
        ContainerStyle parentContainerStyle = renderArgs.getContainerStyle();
        ContainerStyle styleForThis = ContainerRenderer.getLocalContainerStyle(columnSet, parentContainerStyle);
        int i = 0;
        while ((long)i < columnVectorSize) {
            Column column = columnVector.get(i);
            if (columnSet.GetMinHeight() > column.GetMinHeight()) {
                column.SetMinHeight(columnSet.GetMinHeight());
            }
            RenderArgs columnRenderArgs = new RenderArgs(renderArgs);
            columnRenderArgs.setContainerStyle(styleForThis);
            columnRenderArgs.setHorizontalAlignment(HorizontalAlignment.Left);
            columnRenderArgs.setAncestorHasSelectAction(renderArgs.getAncestorHasSelectAction() || columnSet.GetSelectAction() != null);
            FeatureRegistration featureRegistration = CardRendererRegistration.getInstance().getFeatureRegistration();
            CardRendererRegistration.getInstance().renderElementAndPerformFallback(renderedCard, context, fragmentManager, column, (ViewGroup)columnSetLayout, cardActionHandler, hostConfig, columnRenderArgs, featureRegistration);
            ++i;
        }
        ContainerRenderer.setSelectAction(renderedCard, columnSet.GetSelectAction(), (View)columnSetLayout, cardActionHandler, renderArgs);
        TagContent tagContent = new TagContent(columnSet);
        if (columnSet.GetHeight() == HeightType.Stretch) {
            LinearLayout stretchLayout = new LinearLayout(context);
            stretchLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
            stretchLayout.setOrientation(1);
            columnSetLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
            tagContent.SetStretchContainer((View)stretchLayout);
            stretchLayout.addView((View)columnSetLayout);
            viewGroup.addView((View)stretchLayout);
        } else {
            columnSetLayout.setLayoutParams((ViewGroup.LayoutParams)new FlexboxLayout.LayoutParams(-1, -2));
            viewGroup.addView((View)columnSetLayout);
        }
        columnSetLayout.setTag(tagContent);
        ContainerRenderer.applyPadding(styleForThis, parentContainerStyle, (ViewGroup)columnSetLayout, hostConfig);
        ContainerRenderer.applyContainerStyle(styleForThis, parentContainerStyle, (ViewGroup)columnSetLayout, hostConfig);
        ContainerRenderer.applyBleed(columnSet, (ViewGroup)columnSetLayout, context, hostConfig);
        return columnSetLayout;
    }

    private static void normalizeWeights(ColumnVector columns) {
        Float relativeWidth;
        float totalWeight = 0.0f;
        for (Column c : columns) {
            relativeWidth = ColumnRenderer.getRelativeWidth(c);
            if (relativeWidth == null) continue;
            totalWeight += relativeWidth.floatValue();
        }
        for (Column c : columns) {
            relativeWidth = ColumnRenderer.getRelativeWidth(c);
            if (relativeWidth == null || !(totalWeight > 0.0f)) continue;
            c.SetWidth(String.valueOf(relativeWidth.floatValue() / totalWeight));
        }
    }
}

