/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.layout;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

public class HorizontalFlowLayout
extends RelativeLayout {
    public HorizontalFlowLayout(Context context) {
        super(context);
    }

    public HorizontalFlowLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public HorizontalFlowLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int requiredWidth = this.measureRequiredWidth(this.getPaddingLeft(), this.getPaddingRight());
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        if (widthMode == 0 || widthMode == Integer.MIN_VALUE && requiredWidth < width) {
            width = requiredWidth;
        }
        int requiredHeight = this.measureRequiredHeight(width, this.getPaddingTop(), this.getPaddingBottom(), this.getPaddingLeft(), this.getPaddingRight());
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (heightMode == 0 || heightMode == Integer.MIN_VALUE && requiredHeight < height) {
            height = requiredHeight;
        }
        this.setMeasuredDimension(width, height);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int xpos = this.getPaddingStart();
        int ypos = this.getPaddingTop();
        int line_height = 0;
        int width = r - l;
        for (int i = 0; i < this.getChildCount(); ++i) {
            int childMarginBottom;
            int childMarginTop;
            int childMarginEnd;
            int childMarginStart;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            if (child.getLayoutParams() != null && child.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams childMarginLayoutParams = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
                childMarginStart = childMarginLayoutParams.getMarginStart();
                childMarginEnd = childMarginLayoutParams.getMarginEnd();
                childMarginTop = childMarginLayoutParams.topMargin;
                childMarginBottom = childMarginLayoutParams.bottomMargin;
            } else {
                childMarginStart = 0;
                childMarginEnd = 0;
                childMarginTop = 0;
                childMarginBottom = 0;
            }
            if (xpos + childMarginStart + childWidth + childMarginEnd + this.getPaddingEnd() > width) {
                xpos = this.getPaddingStart();
                ypos += line_height;
                line_height = childHeight + childMarginTop + childMarginBottom;
            } else {
                line_height = Math.max(line_height, childMarginTop + childHeight + childMarginBottom);
            }
            int childLeft = this.getLayoutDirection() == 0 ? xpos : width - (xpos += childMarginStart) - childWidth;
            child.layout(childLeft, ypos + childMarginTop, childLeft + childWidth, ypos + childMarginTop + childHeight);
            xpos += childWidth + childMarginEnd;
        }
    }

    int measureRequiredHeight(int width, int paddingTop, int paddingBottom, int paddingLeft, int paddingRight) {
        int xpos = paddingLeft;
        int ypos = paddingTop;
        int line_height = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            int childMarginBottom;
            int childMarginTop;
            int childMarginRight;
            int childMarginLeft;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            if (child.getLayoutParams() != null && child.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams childMarginLayoutParams = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
                childMarginLeft = childMarginLayoutParams.leftMargin;
                childMarginRight = childMarginLayoutParams.rightMargin;
                childMarginTop = childMarginLayoutParams.topMargin;
                childMarginBottom = childMarginLayoutParams.bottomMargin;
            } else {
                childMarginLeft = 0;
                childMarginRight = 0;
                childMarginTop = 0;
                childMarginBottom = 0;
            }
            if (xpos + childMarginLeft + childWidth + childMarginRight + paddingRight > width) {
                xpos = paddingLeft;
                ypos += line_height;
                line_height = childMarginTop + childHeight + childMarginBottom;
            } else {
                line_height = Math.max(line_height, childMarginTop + childHeight + childMarginBottom);
            }
            xpos += childMarginLeft + childWidth + childMarginRight;
        }
        return ypos += line_height + paddingBottom;
    }

    int measureRequiredWidth(int paddingLeft, int paddingRight) {
        int requiredWidth = paddingLeft + paddingRight;
        for (int i = 0; i < this.getChildCount(); ++i) {
            int childMarginRight;
            int childMarginLeft;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int childWidth = child.getMeasuredWidth();
            if (child.getLayoutParams() != null && child.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams childMarginLayoutParams = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
                childMarginLeft = childMarginLayoutParams.leftMargin;
                childMarginRight = childMarginLayoutParams.rightMargin;
            } else {
                childMarginLeft = 0;
                childMarginRight = 0;
            }
            requiredWidth += childMarginLeft + childWidth + childMarginRight;
        }
        return requiredWidth;
    }
}

