/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.inputhandler;

import android.text.TextUtils;
import android.view.View;
import android.widget.CheckBox;
import io.adaptivecards.objectmodel.BaseInputElement;
import io.adaptivecards.objectmodel.ChoiceInputVector;
import io.adaptivecards.objectmodel.ChoiceSetInput;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.inputhandler.BaseInputHandler;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class CheckBoxSetInputHandler
extends BaseInputHandler {
    private List<CheckBox> m_checkBoxList;

    public CheckBoxSetInputHandler(BaseInputElement baseInputElement, List<CheckBox> checkBoxList, RenderedAdaptiveCard renderedAdaptiveCard, long cardId) {
        super(baseInputElement, renderedAdaptiveCard, cardId);
        this.m_checkBoxList = checkBoxList;
    }

    protected List<CheckBox> getCheckBox() {
        return this.m_checkBoxList;
    }

    @Override
    public String getInput() {
        ChoiceSetInput choiceSetInput = (ChoiceSetInput)this.m_baseInputElement;
        Vector<String> resultList = new Vector<String>();
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        for (int index = 0; index < this.m_checkBoxList.size(); ++index) {
            if (!this.m_checkBoxList.get(index).isChecked()) continue;
            resultList.addElement(choiceInputVector.get(index).GetValue());
        }
        return TextUtils.join((CharSequence)",", resultList);
    }

    @Override
    public void setInput(String values) {
        ChoiceSetInput choiceSetInput = (ChoiceSetInput)this.m_baseInputElement;
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        if (values.isEmpty()) {
            for (int i = 0; i < choiceInputVector.size(); ++i) {
                this.m_checkBoxList.get(i).setChecked(false);
            }
            return;
        }
        List<String> listValues = Arrays.asList(values.split(";"));
        for (int i = 0; i < choiceInputVector.size(); ++i) {
            if (listValues.contains(choiceInputVector.get(i).GetValue())) {
                this.m_checkBoxList.get(i).setChecked(true);
                continue;
            }
            this.m_checkBoxList.get(i).setChecked(false);
        }
    }

    @Override
    public void registerInputObserver() {
        for (CheckBox checkBox : this.m_checkBoxList) {
            checkBox.setOnCheckedChangeListener((buttonView, isChecked) -> this.notifyAllInputWatchers());
        }
        this.addValueChangedActionInputWatcher();
    }

    @Override
    public void setFocusToView() {
        if (this.m_checkBoxList.size() > 0) {
            Util.forceFocus((View)this.m_checkBoxList.get(0));
            this.m_checkBoxList.get(0).sendAccessibilityEvent(32768);
        }
    }

    @Override
    public void resetValue() {
        ChoiceSetInput choiceSetInput = Util.castTo(this.m_baseInputElement, ChoiceSetInput.class);
        this.setInput(choiceSetInput.GetValue());
    }
}

