/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import com.google.android.flexbox.FlexboxLayout;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.Spacing;
import io.adaptivecards.objectmodel.SpacingConfig;
import io.adaptivecards.renderer.IBaseCardElementRenderer;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import java.util.Set;

public abstract class BaseCardElementRenderer
implements IBaseCardElementRenderer {
    protected static long getSpacingSize(Spacing spacing, SpacingConfig defaultSpacingConfig) {
        long spacingSize = 0L;
        if (spacing == Spacing.None) {
            return 0L;
        }
        if (spacing == Spacing.Default) {
            spacingSize = defaultSpacingConfig.getDefaultSpacing();
        } else if (spacing == Spacing.ExtraLarge) {
            spacingSize = defaultSpacingConfig.getExtraLargeSpacing();
        } else if (spacing == Spacing.Large) {
            spacingSize = defaultSpacingConfig.getLargeSpacing();
        } else if (spacing == Spacing.Medium) {
            spacingSize = defaultSpacingConfig.getMediumSpacing();
        } else if (spacing == Spacing.Small) {
            spacingSize = defaultSpacingConfig.getSmallSpacing();
        } else if (spacing == Spacing.Padding) {
            spacingSize = defaultSpacingConfig.getPaddingSpacing();
        } else {
            throw new IllegalArgumentException("Unknown spacing style: " + spacing.toString());
        }
        return (int)spacingSize;
    }

    protected static int getColor(String colorCode) {
        return Color.parseColor((String)colorCode);
    }

    @Nullable
    public static View setSpacingAndSeparator(Context context, ViewGroup viewGroup, Spacing spacing, boolean separator, HostConfig hostConfig, boolean isHorizontalSpacing, boolean isImageSet) {
        if (viewGroup.getChildCount() <= 0) {
            return null;
        }
        int spacingSize = Util.dpToPixels(context, BaseCardElementRenderer.getSpacingSize(spacing, hostConfig.GetSpacing()));
        int separatorThickness = Util.dpToPixels(context, hostConfig.GetSeparator().getLineThickness());
        int separatorColor = Color.parseColor((String)hostConfig.GetSeparator().getLineColor());
        ImageView view = new ImageView(context);
        if (isHorizontalSpacing || isImageSet) {
            LinearLayout.LayoutParams params;
            if (separator && separatorThickness > 0) {
                view.setBackgroundColor(separatorColor);
                params = new LinearLayout.LayoutParams(isHorizontalSpacing ? -1 : separatorThickness, isHorizontalSpacing ? separatorThickness : -1);
                params.setMargins(isHorizontalSpacing ? 0 : spacingSize / 2, isHorizontalSpacing ? spacingSize / 2 : 0, isHorizontalSpacing ? 0 : spacingSize / 2, isHorizontalSpacing ? spacingSize / 2 : 0);
            } else {
                params = new LinearLayout.LayoutParams(isHorizontalSpacing ? -1 : spacingSize, isHorizontalSpacing ? spacingSize : (isImageSet ? 0 : -1));
            }
            view.setLayoutParams((ViewGroup.LayoutParams)params);
        } else {
            FlexboxLayout.LayoutParams params;
            if (separator && separatorThickness > 0) {
                view.setBackgroundColor(separatorColor);
                params = new FlexboxLayout.LayoutParams(separatorThickness, -1);
                params.setMargins(spacingSize / 2, 0, spacingSize / 2, 0);
            } else {
                params = new FlexboxLayout.LayoutParams(spacingSize, -1);
            }
            params.setFlexShrink(0.0f);
            params.setFlexGrow(0.0f);
            view.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        view.setTag((Object)new TagContent(true));
        viewGroup.addView((View)view);
        return view;
    }

    public static View setSpacingAndSeparator(Context context, ViewGroup viewGroup, Spacing spacing, boolean separator, HostConfig hostConfig, boolean horizontalLine) {
        return BaseCardElementRenderer.setSpacingAndSeparator(context, viewGroup, spacing, separator, hostConfig, horizontalLine, false);
    }

    @Nullable
    public static TagContent getTagContent(View view) {
        Object tag;
        if (view != null && (tag = view.getTag()) != null && tag instanceof TagContent) {
            return (TagContent)tag;
        }
        return null;
    }

    protected static void setVisibility(boolean isVisible, View elementView, Set<ViewGroup> viewGroupsToUpdate) {
        int visibility;
        View separator = null;
        TagContent tagContent = BaseCardElementRenderer.getTagContent(elementView);
        int n = visibility = isVisible ? 0 : 8;
        if (tagContent != null) {
            View stretchContainer;
            separator = tagContent.GetSeparator();
            ViewGroup viewGroup = tagContent.GetViewContainer();
            if (viewGroupsToUpdate != null && viewGroup != null) {
                viewGroupsToUpdate.add(viewGroup);
            }
            if ((stretchContainer = tagContent.GetStretchContainer()) != null) {
                stretchContainer.setVisibility(visibility);
            }
        }
        if (separator != null) {
            separator.setVisibility(visibility);
        }
        elementView.setVisibility(visibility);
    }

    public static void setVisibility(boolean isVisible, View elementView) {
        BaseCardElementRenderer.setVisibility(isVisible, elementView, null);
    }

    protected static void setMinHeight(long minHeight, View view, Context context) {
        if (minHeight != 0L) {
            view.setMinimumHeight(Util.dpToPixels(context, (int)minHeight));
        }
    }

    public static void applyRtl(Boolean rtl, ViewGroup layout2) {
        if (rtl == null) {
            layout2.setLayoutDirection(2);
        } else if (rtl.booleanValue()) {
            layout2.setLayoutDirection(1);
        } else {
            layout2.setLayoutDirection(0);
        }
    }
}

