/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.view.View;
import android.widget.ImageView;
import com.caverock.androidsvg.SVG;
import io.adaptivecards.objectmodel.AdaptiveCardObjectModel;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.http.HttpRequestHelper;
import io.adaptivecards.renderer.http.HttpRequestResult;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00040\u0001B%\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ)\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00042\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0017\"\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00042\u0006\u0010\u001a\u001a\u00020\u0002H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u0002H\u0002J\u0018\u0010\"\u001a\u00020#2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0004H\u0014J\u0018\u0010%\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u0002H\u0016J\u001a\u0010'\u001a\u00020#2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+H\u0016R\u000e\u0010\t\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006,"}, d2={"Lio/adaptivecards/renderer/FluentIconImageLoaderAsync;", "Landroid/os/AsyncTask;", "", "Ljava/lang/Void;", "Lio/adaptivecards/renderer/http/HttpRequestResult;", "renderedCard", "Lio/adaptivecards/renderer/RenderedAdaptiveCard;", "iconSize", "", "iconColor", "view", "Landroid/view/View;", "(Lio/adaptivecards/renderer/RenderedAdaptiveCard;JLjava/lang/String;Landroid/view/View;)V", "getIconSize", "()J", "getRenderedCard", "()Lio/adaptivecards/renderer/RenderedAdaptiveCard;", "viewReference", "Ljava/lang/ref/WeakReference;", "getViewReference", "()Ljava/lang/ref/WeakReference;", "doInBackground", "args", "", "([Ljava/lang/String;)Lio/adaptivecards/renderer/http/HttpRequestResult;", "fetchIcon", "svgURL", "getDrawableFromSVG", "Landroid/graphics/drawable/BitmapDrawable;", "svgString", "context", "Landroid/content/Context;", "getSvgString", "svgPath", "onPostExecute", "", "result", "parseSvgString", "Lcom/caverock/androidsvg/SVG;", "renderFluentIcon", "drawable", "Landroid/graphics/drawable/Drawable;", "flipInRtl", "", "adaptivecards_release"})
public class FluentIconImageLoaderAsync
extends AsyncTask<String, Void, HttpRequestResult<String>> {
    @NotNull
    private final RenderedAdaptiveCard renderedCard;
    private final long iconSize;
    @NotNull
    private final String iconColor;
    @NotNull
    private final WeakReference<View> viewReference;

    public FluentIconImageLoaderAsync(@NotNull RenderedAdaptiveCard renderedCard, long iconSize, @NotNull String iconColor, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)renderedCard, (String)"renderedCard");
        Intrinsics.checkNotNullParameter((Object)iconColor, (String)"iconColor");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.renderedCard = renderedCard;
        this.iconSize = iconSize;
        this.iconColor = iconColor;
        this.viewReference = new WeakReference<View>(view);
    }

    @NotNull
    public final RenderedAdaptiveCard getRenderedCard() {
        return this.renderedCard;
    }

    public final long getIconSize() {
        return this.iconSize;
    }

    @NotNull
    public final WeakReference<View> getViewReference() {
        return this.viewReference;
    }

    @Nullable
    protected HttpRequestResult<String> doInBackground(String ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return args.length == 0 ? (HttpRequestResult<String>)null : this.fetchIcon(args[0]);
    }

    protected void onPostExecute(@Nullable HttpRequestResult<String> result) {
        block4: {
            View view;
            View view2 = view = (View)this.viewReference.get();
            if (view2 == null) break block4;
            View it = view2;
            boolean bl = false;
            HttpRequestResult<String> httpRequestResult = result;
            boolean bl2 = httpRequestResult != null ? httpRequestResult.isSuccessful() : false;
            if (bl2) {
                JSONObject jsonResponse = new JSONObject(result.getResult());
                try {
                    JSONArray svgPath = jsonResponse.getJSONArray("svgPaths");
                    boolean flipInRtl = jsonResponse.optBoolean("flipInRtl", false);
                    Object object = svgPath.get(0);
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    String svgString = this.getSvgString((String)object);
                    Context context = it.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"it.context");
                    BitmapDrawable drawable = this.getDrawableFromSVG(svgString, context);
                    this.renderFluentIcon((Drawable)drawable, flipInRtl);
                }
                catch (Exception e) {
                    this.renderFluentIcon(null, false);
                }
            }
        }
    }

    public void renderFluentIcon(@Nullable Drawable drawable, boolean flipInRtl) {
        View view = (View)this.viewReference.get();
        if (view != null && view instanceof ImageView) {
            ((ImageView)view).setImageDrawable(drawable);
            if (Intrinsics.areEqual((Object)this.renderedCard.getAdaptiveCard().GetRtl(), (Object)flipInRtl)) {
                ((ImageView)view).setScaleX(-1.0f);
            }
        }
    }

    private final HttpRequestResult<String> fetchIcon(String svgURL) {
        HttpRequestResult<String> httpRequestResult;
        try {
            byte[] responseBytes = HttpRequestHelper.get(svgURL);
            Intrinsics.checkNotNullExpressionValue((Object)responseBytes, (String)"responseBytes");
            byte[] byArray = responseBytes;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            httpRequestResult = new HttpRequestResult<String>(new String(byArray, charset2));
        }
        catch (Exception e) {
            HttpRequestResult<String> httpRequestResult2;
            String unavailableIconURL = AdaptiveCardObjectModel.getBaseIconCDNUrl() + "/Square/Square" + this.iconSize + "Filled.json";
            try {
                byte[] responseBytes = HttpRequestHelper.get(unavailableIconURL);
                Intrinsics.checkNotNullExpressionValue((Object)responseBytes, (String)"responseBytes");
                byte[] byArray = responseBytes;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                Charset charset3 = charset;
                httpRequestResult2 = new HttpRequestResult<String>(new String(byArray, charset3));
            }
            catch (Exception e2) {
                httpRequestResult2 = null;
            }
            httpRequestResult = httpRequestResult2;
        }
        return httpRequestResult;
    }

    private final String getSvgString(String svgPath) {
        return "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"" + this.iconSize + "\" height=\"" + this.iconSize + "\" viewBox=\"0 0 " + this.iconSize + ' ' + this.iconSize + "\"> <path d=\"" + svgPath + "\"/></svg>";
    }

    @NotNull
    public SVG parseSvgString(@NotNull Context context, @NotNull String svgString) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)svgString, (String)"svgString");
        SVG svg = SVG.getFromString((String)svgString);
        svg.setDocumentWidth((float)Util.dpToPixels(context, this.iconSize));
        svg.setDocumentHeight((float)Util.dpToPixels(context, this.iconSize));
        Intrinsics.checkNotNullExpressionValue((Object)svg, (String)"svg");
        return svg;
    }

    private final BitmapDrawable getDrawableFromSVG(String svgString, Context context) {
        int n;
        SVG svg = this.parseSvgString(context, svgString);
        Picture picture = svg.renderToPicture();
        Bitmap bitmap = Bitmap.createBitmap((int)picture.getWidth(), (int)picture.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        picture.draw(canvas);
        BitmapDrawable drawable = new BitmapDrawable(context.getResources(), bitmap);
        try {
            n = Color.parseColor((String)this.iconColor);
        }
        catch (IllegalArgumentException e) {
            n = -16777216;
        }
        int color = n;
        drawable.setColorFilter(color, PorterDuff.Mode.SRC_IN);
        return drawable;
    }
}

