/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.inputhandler;

import android.widget.EditText;
import androidx.fragment.app.FragmentManager;
import io.adaptivecards.objectmodel.BaseInputElement;
import io.adaptivecards.objectmodel.TimeInput;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.input.TimeInputRenderer;
import io.adaptivecards.renderer.inputhandler.TextInputHandler;
import io.adaptivecards.renderer.readonly.RendererUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TimeInputHandler
extends TextInputHandler {
    private FragmentManager m_fragmentManager;
    public static final String TIME_FORMAT_SUBMIT = "kk:mm";
    public static SimpleDateFormat s_simpleDateFormat = new SimpleDateFormat("kk:mm");

    public TimeInputHandler(BaseInputElement baseInputElement, FragmentManager fragmentManager, RenderedAdaptiveCard renderedAdaptiveCard, long cardId) {
        super(baseInputElement, renderedAdaptiveCard, (Long)cardId);
        this.m_fragmentManager = fragmentManager;
    }

    public FragmentManager getFragmentManager() {
        return this.m_fragmentManager;
    }

    @Override
    public String getInput() {
        EditText editText = this.getEditText();
        try {
            String text = editText.getText().toString();
            Date time = DateFormat.getTimeInstance(3).parse(text);
            return s_simpleDateFormat.format(time);
        }
        catch (ParseException e) {
            return editText.getText().toString();
        }
    }

    @Override
    public boolean isValidOnSpecifics(String timeInputValue) {
        String maxTime;
        TimeInput timeInput = Util.tryCastTo(this.m_baseInputElement, TimeInput.class);
        if (timeInput == null) {
            return false;
        }
        if (!timeInput.GetIsRequired() && timeInputValue.isEmpty()) {
            return true;
        }
        if (!RendererUtil.isValidTime(timeInputValue)) {
            return false;
        }
        Date currentTime = null;
        try {
            currentTime = this.getCurrentValue(timeInputValue);
        }
        catch (Exception e) {
            return false;
        }
        String minTime = timeInput.GetMin();
        if (!minTime.isEmpty()) {
            try {
                Date min = this.getCurrentValue(minTime);
                if (!this.beforeOrSame(min, currentTime)) {
                    return false;
                }
            }
            catch (Exception min) {
                // empty catch block
            }
        }
        if (!(maxTime = timeInput.GetMax()).isEmpty()) {
            try {
                Date max = RendererUtil.getTime(maxTime).getTime();
                if (!this.beforeOrSame(currentTime, max)) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private Date getCurrentValue(String timeInputValue) throws Exception {
        String formattedTime = TimeInputRenderer.getTimeFormat().format(RendererUtil.getTime(timeInputValue).getTime());
        Date currentTime = TimeInputRenderer.getTimeFormat().parse(formattedTime);
        Calendar currentValueDate = Calendar.getInstance();
        currentValueDate.setTime(currentTime);
        Date currentDate = new Date();
        Calendar currentDateCalendar = Calendar.getInstance();
        currentDateCalendar.setTime(currentDate);
        currentDateCalendar.set(11, currentValueDate.get(11));
        currentDateCalendar.set(12, currentValueDate.get(12));
        currentTime = currentDateCalendar.getTime();
        return currentTime;
    }

    private boolean beforeOrSame(Date before, Date after) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(before);
        int beforeHour = calendar.get(11);
        int beforeMinute = calendar.get(12);
        calendar.setTime(after);
        int afterHour = calendar.get(11);
        int afterMinute = calendar.get(12);
        return beforeHour < afterHour || beforeHour == afterHour && beforeMinute <= afterMinute;
    }

    @Override
    public String getDefaultValue() {
        if (Util.isOfType(this.m_baseInputElement, TimeInput.class)) {
            return Util.castTo(this.m_baseInputElement, TimeInput.class).GetValue();
        }
        return super.getDefaultValue();
    }
}

