/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.inputhandler;

import android.widget.CheckBox;
import io.adaptivecards.objectmodel.BaseInputElement;
import io.adaptivecards.objectmodel.ToggleInput;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.inputhandler.BaseInputHandler;

public class ToggleInputHandler
extends BaseInputHandler {
    public ToggleInputHandler(BaseInputElement baseInputElement, RenderedAdaptiveCard renderedAdaptiveCard, long cardId) {
        super(baseInputElement, renderedAdaptiveCard, cardId);
    }

    protected CheckBox getCheckBox() {
        return (CheckBox)this.m_view;
    }

    @Override
    public String getInput() {
        ToggleInput toggleInput = (ToggleInput)this.m_baseInputElement;
        CheckBox checkBox = this.getCheckBox();
        return checkBox.isChecked() ? toggleInput.GetValueOn() : toggleInput.GetValueOff();
    }

    @Override
    public void setInput(String value) {
        ToggleInput toggleInput = (ToggleInput)this.m_baseInputElement;
        CheckBox checkBox = this.getCheckBox();
        checkBox.setChecked(value.equals(toggleInput.GetValueOn()));
    }

    @Override
    public boolean isValid() {
        return this.isValid(true);
    }

    @Override
    public boolean isValid(boolean showError) {
        boolean isValid = true;
        if (this.m_baseInputElement.GetIsRequired()) {
            isValid = this.getCheckBox().isChecked();
        }
        if (showError) {
            this.showValidationErrors(isValid);
        }
        return isValid;
    }

    @Override
    public void registerInputObserver() {
        this.getCheckBox().setOnCheckedChangeListener((buttonView, isChecked) -> this.notifyAllInputWatchers());
        this.addValueChangedActionInputWatcher();
    }

    @Override
    public String getDefaultValue() {
        if (Util.isOfType(this.m_baseInputElement, ToggleInput.class)) {
            return Util.castTo(this.m_baseInputElement, ToggleInput.class).GetValue();
        }
        return super.getDefaultValue();
    }

    @Override
    public void setFocusToView() {
        Util.forceFocus(this.m_view);
        this.m_view.sendAccessibilityEvent(32768);
    }
}

