/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.layout;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.core.content.res.ResourcesCompat;
import io.adaptivecards.R;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.RatingColor;
import io.adaptivecards.objectmodel.RatingInput;
import io.adaptivecards.objectmodel.RatingSize;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.layout.RatingStarInputViewListener;
import io.adaptivecards.renderer.readonly.RatingElementRendererUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0001#B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u001c\u001a\u00020\u0015J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010!\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\"\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/adaptivecards/renderer/layout/RatingStarInputView;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "hostConfig", "Lio/adaptivecards/objectmodel/HostConfig;", "ratingInput", "Lio/adaptivecards/objectmodel/RatingInput;", "(Landroid/content/Context;Lio/adaptivecards/objectmodel/HostConfig;Lio/adaptivecards/objectmodel/RatingInput;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "color", "Lio/adaptivecards/objectmodel/RatingColor;", "listener", "Lio/adaptivecards/renderer/layout/RatingStarInputViewListener;", "maxStarsCount", "rating", "", "ratingStars", "", "Landroid/widget/ImageView;", "size", "Lio/adaptivecards/objectmodel/RatingSize;", "value", "getRating", "getStarDrawable", "Landroid/graphics/drawable/Drawable;", "initStars", "", "setRating", "setRatingStarInputViewListener", "Companion", "adaptivecards_release"})
public final class RatingStarInputView
extends LinearLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double value;
    private int maxStarsCount;
    private RatingColor color;
    @NotNull
    private RatingSize size;
    @NotNull
    private final List<ImageView> ratingStars;
    private double rating;
    private HostConfig hostConfig;
    @Nullable
    private RatingStarInputViewListener listener;
    private static final int RIGHT_MARGIN = 12;

    public RatingStarInputView(@NotNull Context context, @NotNull HostConfig hostConfig, @NotNull RatingInput ratingInput) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)hostConfig, (String)"hostConfig");
        Intrinsics.checkNotNullParameter((Object)ratingInput, (String)"ratingInput");
        super(context);
        this.maxStarsCount = 5;
        this.size = RatingSize.Medium;
        this.ratingStars = new ArrayList();
        this.setSaveEnabled(true);
        this.maxStarsCount = RangesKt.coerceAtMost((int)((int)ratingInput.GetMax()), (int)5);
        this.value = RangesKt.coerceAtMost((double)ratingInput.GetValue(), (double)5.0);
        RatingColor ratingColor = ratingInput.GetRatingColor();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ratingColor), (String)"ratingInput.GetRatingColor()");
        this.color = ratingColor;
        this.rating = this.value;
        RatingSize ratingSize = ratingInput.GetRatingSize();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ratingSize), (String)"ratingInput.GetRatingSize()");
        this.size = ratingSize;
        this.hostConfig = hostConfig;
        this.initStars(context);
    }

    public RatingStarInputView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.maxStarsCount = 5;
        this.size = RatingSize.Medium;
        this.ratingStars = new ArrayList();
        this.initStars(context);
    }

    public RatingStarInputView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.maxStarsCount = 5;
        this.size = RatingSize.Medium;
        this.ratingStars = new ArrayList();
        this.initStars(context);
    }

    private final void initStars(Context context) {
        this.setOrientation(0);
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        int rightMargin = Util.dpToPixels(context, 12.0f);
        int n = this.maxStarsCount;
        for (int index = 0; index < n; ++index) {
            ImageView star;
            ImageView imageView;
            ImageView $this$initStars_u24lambda_u2d1 = imageView = (star = new ImageView(context));
            boolean bl = false;
            $this$initStars_u24lambda_u2d1.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2, 0.0f));
            $this$initStars_u24lambda_u2d1.setContentDescription((CharSequence)("Rating Star " + index + "+1"));
            $this$initStars_u24lambda_u2d1.setImageDrawable(this.getStarDrawable());
            RatingColor ratingColor = this.color;
            if (ratingColor == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"color");
                ratingColor = null;
            }
            boolean bl2 = (double)index < this.value;
            HostConfig hostConfig = this.hostConfig;
            if (hostConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"hostConfig");
                hostConfig = null;
            }
            $this$initStars_u24lambda_u2d1.setColorFilter(RatingElementRendererUtil.INSTANCE.getInputStarColor(ratingColor, bl2, hostConfig));
            $this$initStars_u24lambda_u2d1.setActivated(index < (int)this.value);
            $this$initStars_u24lambda_u2d1.setOnClickListener(arg_0 -> RatingStarInputView.initStars$lambda-1$lambda-0(this, index, arg_0));
            this.ratingStars.add(star);
            ViewGroup.LayoutParams layoutParams = star.getLayoutParams();
            if (layoutParams == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
            }
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)layoutParams;
            if (index < this.maxStarsCount - 1) {
                params.rightMargin = rightMargin;
            }
            this.addView((View)star, (ViewGroup.LayoutParams)params);
        }
    }

    public final double getRating() {
        return this.rating;
    }

    public final void setRatingStarInputViewListener(@NotNull RatingStarInputViewListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listener = listener;
    }

    public final void setRating(double rating) {
        block1: {
            this.rating = rating;
            int n = this.maxStarsCount;
            for (int i = 0; i < n; ++i) {
                this.ratingStars.get(i).setActivated(i < (int)rating);
            }
            RatingStarInputViewListener ratingStarInputViewListener = this.listener;
            if (ratingStarInputViewListener == null) break block1;
            ratingStarInputViewListener.onRatingChanged();
        }
    }

    private final Drawable getStarDrawable() {
        return WhenMappings.$EnumSwitchMapping$0[this.size.ordinal()] == 1 ? ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.rating_star_selector_large, null) : ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.rating_star_selector_medium, null);
    }

    private static final void initStars$lambda-1$lambda-0(RatingStarInputView this$0, int $index, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.setRating($index + 1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/adaptivecards/renderer/layout/RatingStarInputView$Companion;", "", "()V", "RIGHT_MARGIN", "", "adaptivecards_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RatingSize.values().length];
            nArray[RatingSize.Large.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

