/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentManager;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.CompoundButton;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.ForegroundColor;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.IconStyle;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.FluentIconImageLoaderAsync;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.readonly.ContainerRenderer;

public class CompoundButtonRenderer
extends BaseCardElementRenderer {
    private static CompoundButtonRenderer s_instance = null;

    protected CompoundButtonRenderer() {
    }

    public static CompoundButtonRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new CompoundButtonRenderer();
        }
        return s_instance;
    }

    @Override
    @Nullable
    public View render(@NonNull RenderedAdaptiveCard renderedCard, @NonNull Context context, @NonNull FragmentManager fragmentManager, @NonNull ViewGroup viewGroup, @NonNull BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, @NonNull HostConfig hostConfig, @NonNull RenderArgs renderArgs) throws Exception {
        CompoundButton compoundButton = Util.castTo(baseCardElement, CompoundButton.class);
        ViewGroup compoundButtonLayout = this.getCompoundButtonLayout(context, compoundButton, renderedCard, hostConfig);
        compoundButtonLayout.setTag((Object)new TagContent(compoundButton));
        viewGroup.addView((View)compoundButtonLayout);
        ContainerRenderer.setSelectAction(renderedCard, compoundButton.GetSelectAction(), (View)compoundButtonLayout, cardActionHandler, renderArgs);
        return compoundButtonLayout;
    }

    private ViewGroup getCompoundButtonLayout(Context context, CompoundButton compoundButton, RenderedAdaptiveCard renderedCard, HostConfig hostConfig) {
        String foregroundColor = hostConfig.GetForegroundColor(ContainerStyle.Default, ForegroundColor.Dark, false);
        String backgroundColor = hostConfig.GetBackgroundColor(ContainerStyle.Default);
        RelativeLayout layout2 = new RelativeLayout(context);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
        layout2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        layout2.setBackgroundColor(Color.parseColor((String)backgroundColor));
        boolean isIconSet = compoundButton.getIcon() != null && !compoundButton.getIcon().GetName().isEmpty();
        ImageView imageView = new ImageView(context);
        imageView.setId(View.generateViewId());
        RelativeLayout.LayoutParams imageParams = new RelativeLayout.LayoutParams(-2, -2);
        imageParams.addRule(20, -1);
        imageParams.addRule(15, -1);
        imageView.setPadding(this.dpToPx(2, context), this.dpToPx(2, context), this.dpToPx(2, context), this.dpToPx(2, context));
        imageView.setLayoutParams((ViewGroup.LayoutParams)imageParams);
        layout2.addView((View)imageView);
        if (!isIconSet) {
            imageView.setVisibility(8);
        } else {
            boolean isFilledStyle = compoundButton.getIcon().getIconStyle() == IconStyle.Filled;
            String svgInfoURL = compoundButton.getIcon().GetSVGInfoURL();
            String foregroundColorIcon = hostConfig.GetForegroundColor(ContainerStyle.Default, compoundButton.getIcon().getForgroundColor(), false);
            FluentIconImageLoaderAsync fluentIconImageLoaderAsync = new FluentIconImageLoaderAsync(renderedCard, Util.getFluentIconSize(compoundButton.getIcon().getIconSize()), foregroundColorIcon, isFilledStyle, (View)imageView);
            fluentIconImageLoaderAsync.execute(new String[]{svgInfoURL});
        }
        TextView titleTextView = new TextView(context);
        titleTextView.setId(View.generateViewId());
        titleTextView.setText((CharSequence)compoundButton.getTitle());
        titleTextView.setTextColor(Color.parseColor((String)foregroundColor));
        titleTextView.setEllipsize(TextUtils.TruncateAt.END);
        titleTextView.setMaxLines(1);
        titleTextView.setTypeface(null, 1);
        RelativeLayout.LayoutParams titleParams = new RelativeLayout.LayoutParams(-2, -2);
        titleParams.addRule(17, imageView.getId());
        titleParams.addRule(15, -1);
        int leftPadding = isIconSet ? this.dpToPx(8, context) : this.dpToPx(0, context);
        titleTextView.setPadding(leftPadding, this.dpToPx(8, context), this.dpToPx(8, context), this.dpToPx(8, context));
        titleTextView.setLayoutParams((ViewGroup.LayoutParams)titleParams);
        layout2.addView((View)titleTextView);
        TextView badgeTextView = new TextView(context);
        badgeTextView.setId(View.generateViewId());
        badgeTextView.setText((CharSequence)compoundButton.getBadge());
        badgeTextView.setTextColor(Color.parseColor((String)backgroundColor));
        badgeTextView.setBackground((Drawable)this.getBadgeBackground(context, hostConfig.GetCompoundButtonConfig().getBadgeConfig().getBackgroundColor()));
        badgeTextView.setPadding(this.dpToPx(4, context), this.dpToPx(4, context), this.dpToPx(4, context), this.dpToPx(4, context));
        RelativeLayout.LayoutParams badgeParams = new RelativeLayout.LayoutParams(-2, -2);
        badgeParams.addRule(17, titleTextView.getId());
        badgeParams.addRule(15, -1);
        badgeTextView.setLayoutParams((ViewGroup.LayoutParams)badgeParams);
        if (compoundButton.getBadge().isEmpty()) {
            badgeTextView.setVisibility(8);
        }
        layout2.addView((View)badgeTextView);
        TextView descriptionTextView = new TextView(context);
        descriptionTextView.setId(View.generateViewId());
        descriptionTextView.setText((CharSequence)compoundButton.getDescription());
        descriptionTextView.setTextColor(Color.parseColor((String)foregroundColor));
        descriptionTextView.setMaxLines(5);
        RelativeLayout.LayoutParams descriptionParams = new RelativeLayout.LayoutParams(-1, -2);
        descriptionParams.addRule(3, titleTextView.getId());
        descriptionParams.topMargin = isIconSet ? this.dpToPx(36, context) : this.dpToPx(30, context);
        descriptionTextView.setPadding(this.dpToPx(2, context), this.dpToPx(2, context), this.dpToPx(2, context), this.dpToPx(2, context));
        descriptionTextView.setLayoutParams((ViewGroup.LayoutParams)descriptionParams);
        if (compoundButton.getDescription().isEmpty()) {
            descriptionTextView.setVisibility(8);
        }
        layout2.addView((View)descriptionTextView);
        return layout2;
    }

    private int dpToPx(int dp, Context context) {
        float density = context.getResources().getDisplayMetrics().density;
        return Math.round((float)dp * density);
    }

    private GradientDrawable getBadgeBackground(Context context, String backgroundColor) {
        GradientDrawable badgeBackground = new GradientDrawable();
        badgeBackground.setShape(0);
        badgeBackground.setColor(Color.parseColor((String)backgroundColor));
        badgeBackground.setCornerRadius((float)this.dpToPx(190, context));
        return badgeBackground;
    }
}

