/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.adaptivecards.objectmodel.AdaptiveCard;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.inputhandler.BaseInputHandler;
import io.adaptivecards.renderer.inputhandler.IInputHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class RenderedAdaptiveCard {
    private View view;
    private Vector<AdaptiveWarning> warnings = new Vector();
    private Vector<IInputHandler> handlers = new Vector();
    private AdaptiveCard adaptiveCard;
    private Map<Long, Long> submitActionCard;
    private Map<Long, Map<String, IInputHandler>> inputsInCard;
    private Map<Long, Long> parentCardForCard;
    private Map<String, String> prevalidatedInputs;
    private boolean lastValidationResult = false;

    protected RenderedAdaptiveCard(AdaptiveCard adaptiveCard) {
        this.adaptiveCard = adaptiveCard;
        this.submitActionCard = new HashMap<Long, Long>();
        this.inputsInCard = new HashMap<Long, Map<String, IInputHandler>>();
        this.parentCardForCard = new HashMap<Long, Long>();
        this.prevalidatedInputs = new HashMap<String, String>();
    }

    public View getView() {
        return this.view;
    }

    public void addWarning(AdaptiveWarning warning) {
        this.warnings.add(warning);
    }

    public Vector<AdaptiveWarning> getWarnings() {
        return this.warnings;
    }

    public void registerInputHandler(IInputHandler handler, RenderArgs renderArgs) {
        this.registerInputHandler(handler, renderArgs.getContainerCardId());
    }

    public void registerInputHandler(IInputHandler handler, long cardId) {
        if (!this.inputsInCard.containsKey(cardId)) {
            this.inputsInCard.put(cardId, new HashMap());
        }
        this.inputsInCard.get(cardId).put(handler.getId(), handler);
        this.handlers.add(handler);
    }

    public Map<String, String> getInputs() {
        return this.prevalidatedInputs;
    }

    public void setParentToCard(long cardId, long parentCardId) {
        this.parentCardForCard.put(cardId, parentCardId);
    }

    public void setCardForSubmitAction(long actionId, long parentCardId) {
        this.submitActionCard.put(actionId, parentCardId);
    }

    @NonNull
    public Vector<IInputHandler> getInputsToValidate(long clickedActionId) {
        Long cardId = this.submitActionCard.get(clickedActionId);
        Vector<IInputHandler> inputHandlers = new Vector<IInputHandler>();
        while (cardId != null && cardId != -1L) {
            Map<String, IInputHandler> inputHandlersMap = this.getInputsHandlerFromCardId(cardId);
            if (inputHandlersMap != null && inputHandlersMap.values() != null) {
                inputHandlers.addAll(inputHandlersMap.values());
            }
            cardId = this.parentCardForCard.get(cardId);
        }
        return inputHandlers;
    }

    @Nullable
    public Map<String, IInputHandler> getInputsHandlerFromCardId(long cardId) {
        return this.inputsInCard.get(cardId);
    }

    protected boolean areInputsValid(long actionId) {
        boolean allInputsAreValid = true;
        boolean hasSetFocusToElement = false;
        HashMap<String, String> validatedInputs = new HashMap<String, String>();
        Vector<IInputHandler> inputsToValidate = this.getInputsToValidate(actionId);
        for (IInputHandler i : inputsToValidate) {
            if (allInputsAreValid &= i.isValid()) {
                validatedInputs.put(i.getId(), i.getInput());
            }
            if (allInputsAreValid || hasSetFocusToElement) continue;
            BaseInputHandler baseInputHandler = (BaseInputHandler)i;
            baseInputHandler.setFocusToView();
            hasSetFocusToElement = true;
        }
        if (allInputsAreValid) {
            this.prevalidatedInputs = validatedInputs;
        }
        this.lastValidationResult = allInputsAreValid;
        return this.lastValidationResult;
    }

    public boolean areInputsValid() {
        return this.lastValidationResult;
    }

    public AdaptiveCard getAdaptiveCard() {
        return this.adaptiveCard;
    }

    public void setView(View view) {
        this.view = view;
    }

    public void registerSubmitableAction(View renderedAction, RenderArgs renderArgs) {
        long actionId = Util.getViewId(renderedAction);
        this.setCardForSubmitAction(actionId, renderArgs.getContainerCardId());
    }

    protected boolean isActionSubmitable(View action) {
        long actionId = action.getId();
        return this.submitActionCard.containsKey(actionId);
    }

    protected void clearValidatedInputs() {
        this.prevalidatedInputs.clear();
        this.lastValidationResult = false;
    }
}

