/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.action;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import androidx.appcompat.widget.TooltipCompat;
import androidx.fragment.app.FragmentManager;
import io.adaptivecards.R;
import io.adaptivecards.objectmodel.ActionAlignment;
import io.adaptivecards.objectmodel.ActionType;
import io.adaptivecards.objectmodel.ActionsOrientation;
import io.adaptivecards.objectmodel.BaseActionElement;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.ExecuteAction;
import io.adaptivecards.objectmodel.ForegroundColor;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.IconPlacement;
import io.adaptivecards.objectmodel.SubmitAction;
import io.adaptivecards.renderer.BaseActionElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.inputhandler.IInputHandler;
import io.adaptivecards.renderer.inputhandler.InputUtils;
import java.util.Vector;

public class ActionElementRenderer
extends BaseActionElementRenderer {
    private static ActionElementRenderer s_instance = null;

    protected ActionElementRenderer() {
    }

    public static ActionElementRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ActionElementRenderer();
        }
        return s_instance;
    }

    private static Button createButtonWithTheme(Context context, int theme) {
        ContextThemeWrapper themedContext = new ContextThemeWrapper(context, theme);
        return new Button((Context)themedContext);
    }

    protected static Button getButtonForStyle(Context context, String style, HostConfig hostConfig) {
        boolean isPositiveStyle = style.equalsIgnoreCase("Positive");
        boolean isDestructiveStyle = style.equalsIgnoreCase("Destructive");
        if (isPositiveStyle || isDestructiveStyle) {
            Resources.Theme theme = context.getTheme();
            TypedValue buttonStyle = new TypedValue();
            if (isPositiveStyle) {
                if (theme.resolveAttribute(R.attr.adaptiveActionPositive, buttonStyle, true)) {
                    return ActionElementRenderer.createButtonWithTheme(context, buttonStyle.data);
                }
                Button button = new Button(context);
                button.getBackground().setColorFilter(ActionElementRenderer.getColor(hostConfig.GetForegroundColor(ContainerStyle.Default, ForegroundColor.Accent, false)), PorterDuff.Mode.MULTIPLY);
                return button;
            }
            if (theme.resolveAttribute(R.attr.adaptiveActionDestructive, buttonStyle, true)) {
                return ActionElementRenderer.createButtonWithTheme(context, buttonStyle.data);
            }
            Button button = new Button(context);
            button.getBackground().setColorFilter(ActionElementRenderer.getColor(hostConfig.GetForegroundColor(ContainerStyle.Default, ForegroundColor.Attention, false)), PorterDuff.Mode.MULTIPLY);
            return button;
        }
        return new Button(context);
    }

    public Button renderButton(Context context, ViewGroup viewGroup, BaseActionElement baseActionElement, HostConfig hostConfig, RenderedAdaptiveCard renderedCard, RenderArgs renderArgs) {
        LinearLayout.LayoutParams layoutParams;
        TypedValue buttonStyle = new TypedValue();
        if (baseActionElement.GetElementType() == ActionType.ShowCard && context.getTheme().resolveAttribute(R.attr.adaptiveShowCardAction, buttonStyle, true)) {
            context = new ContextThemeWrapper(context, buttonStyle.data);
        }
        Button button = ActionElementRenderer.getButtonForStyle(context, baseActionElement.GetStyle(), hostConfig);
        if (Util.isOfType(baseActionElement, ExecuteAction.class) || Util.isOfType(baseActionElement, SubmitAction.class)) {
            long actionId = Util.getViewId((View)button);
            renderedCard.setCardForSubmitAction(actionId, renderArgs.getContainerCardId());
        }
        this.setButtonEnabledState(baseActionElement, button, renderedCard);
        button.setText((CharSequence)baseActionElement.GetTitle());
        if (!TextUtils.isEmpty((CharSequence)baseActionElement.GetTooltip())) {
            TooltipCompat.setTooltipText((View)button, (CharSequence)baseActionElement.GetTooltip());
        }
        ActionAlignment alignment = hostConfig.GetActions().getActionAlignment();
        ActionsOrientation orientation = hostConfig.GetActions().getActionsOrientation();
        if (orientation == ActionsOrientation.Horizontal) {
            layoutParams = new LinearLayout.LayoutParams(-2, -1);
            long spacing = hostConfig.GetActions().getButtonSpacing();
            layoutParams.rightMargin = Util.dpToPixels(context, spacing);
        } else {
            layoutParams = new LinearLayout.LayoutParams(-1, -1);
        }
        if (alignment == ActionAlignment.Stretch) {
            layoutParams.weight = 1.0f;
        }
        button.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        int minHeight = context.getResources().getDimensionPixelSize(R.dimen.action_min_height);
        button.post(() -> Util.expandClickArea((View)button, minHeight));
        String iconUrl = baseActionElement.GetIconUrl();
        String svgInfoURL = baseActionElement.GetSVGInfoURL();
        if (!iconUrl.isEmpty()) {
            IconPlacement iconPlacement = hostConfig.GetActions().getIconPlacement();
            if (!renderArgs.getAllowAboveTitleIconPlacement()) {
                iconPlacement = IconPlacement.LeftOfTitle;
            }
            Util.loadIcon(context, (View)button, iconUrl, svgInfoURL, hostConfig, renderedCard, iconPlacement);
        }
        if (baseActionElement.GetElementType() == ActionType.OpenUrl) {
            button.setContentDescription((CharSequence)Util.getOpenUrlAnnouncement(context, baseActionElement.GetTitle()));
        }
        viewGroup.addView((View)button);
        return button;
    }

    protected void setButtonEnabledState(BaseActionElement baseActionElement, Button button, RenderedAdaptiveCard adaptiveCard) {
        if (!baseActionElement.GetIsEnabled()) {
            button.setEnabled(false);
        } else if (Util.isOfType(baseActionElement, ExecuteAction.class)) {
            ExecuteAction executeAction = Util.castTo(baseActionElement, ExecuteAction.class);
            if (executeAction.GetConditionallyEnabled()) {
                this.addInputWatcherForConditionallyEnabledAction(adaptiveCard, button);
            }
        } else if (Util.isOfType(baseActionElement, SubmitAction.class)) {
            SubmitAction submitAction = Util.castTo(baseActionElement, SubmitAction.class);
            if (submitAction.GetConditionallyEnabled()) {
                this.addInputWatcherForConditionallyEnabledAction(adaptiveCard, button);
            }
        } else {
            button.setEnabled(true);
        }
    }

    private void addInputWatcherForConditionallyEnabledAction(RenderedAdaptiveCard adaptiveCard, Button button) {
        Vector<IInputHandler> inputHandlers = adaptiveCard.getInputsToValidate(Util.getViewId((View)button));
        button.setEnabled(InputUtils.isAnyInputValid(inputHandlers));
        for (IInputHandler inputHandler : inputHandlers) {
            inputHandler.addInputWatcher((id2, val) -> button.setEnabled(InputUtils.isAnyInputValid(inputHandlers)));
        }
    }

    @Override
    public Button render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseActionElement baseActionElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) {
        if (cardActionHandler == null) {
            throw new IllegalArgumentException("Action Handler is null.");
        }
        Button button = this.renderButton(context, viewGroup, baseActionElement, hostConfig, renderedCard, renderArgs);
        button.setOnClickListener((View.OnClickListener)new BaseActionElementRenderer.ActionOnClickListener(renderedCard, context, fragmentManager, viewGroup, baseActionElement, cardActionHandler, hostConfig, renderArgs));
        return button;
    }
}

