/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentManager;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.CompoundButton;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.ForegroundColor;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.IconStyle;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.FluentIconImageLoaderAsync;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.readonly.ContainerRenderer;

public class CompoundButtonRenderer
extends BaseCardElementRenderer {
    private static CompoundButtonRenderer s_instance = null;

    protected CompoundButtonRenderer() {
    }

    public static CompoundButtonRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new CompoundButtonRenderer();
        }
        return s_instance;
    }

    @Override
    @Nullable
    public View render(@NonNull RenderedAdaptiveCard renderedCard, @NonNull Context context, @NonNull FragmentManager fragmentManager, @NonNull ViewGroup viewGroup, @NonNull BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, @NonNull HostConfig hostConfig, @NonNull RenderArgs renderArgs) throws Exception {
        CompoundButton compoundButton = Util.castTo(baseCardElement, CompoundButton.class);
        ViewGroup compoundButtonLayout = this.getCompoundButtonLayout(context, compoundButton, renderedCard, hostConfig, renderArgs);
        compoundButtonLayout.setTag((Object)new TagContent(compoundButton));
        viewGroup.addView((View)compoundButtonLayout);
        ContainerRenderer.setSelectAction(renderedCard, compoundButton.GetSelectAction(), (View)compoundButtonLayout, cardActionHandler, renderArgs);
        return compoundButtonLayout;
    }

    private ViewGroup getCompoundButtonLayout(Context context, CompoundButton compoundButton, RenderedAdaptiveCard renderedCard, HostConfig hostConfig, RenderArgs renderArgs) {
        ContainerStyle style = renderArgs.getContainerStyle();
        String foregroundColor = hostConfig.GetForegroundColor(style, ForegroundColor.Default, false);
        String backgroundColor = hostConfig.GetBackgroundColor(style);
        LinearLayout layout2 = new LinearLayout(context);
        layout2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        layout2.setOrientation(1);
        int paddingPx = this.dpToPx(context, 16);
        layout2.setPadding(paddingPx, paddingPx, paddingPx, paddingPx);
        boolean isIconSet = compoundButton.getIcon() != null && !compoundButton.getIcon().GetName().isEmpty();
        LinearLayout innerLayout = new LinearLayout(context);
        innerLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        innerLayout.setOrientation(0);
        innerLayout.setGravity(16);
        ImageView imageView = new ImageView(context);
        imageView.setId(View.generateViewId());
        LinearLayout.LayoutParams iconParams = new LinearLayout.LayoutParams(-2, -2);
        iconParams.setMarginEnd(this.dpToPx(context, 8));
        imageView.setLayoutParams((ViewGroup.LayoutParams)iconParams);
        if (!isIconSet) {
            imageView.setVisibility(8);
        } else {
            boolean isFilledStyle = compoundButton.getIcon().getIconStyle() == IconStyle.Filled;
            String svgInfoURL = compoundButton.getIcon().GetSVGInfoURL();
            String foregroundColorIcon = hostConfig.GetForegroundColor(ContainerStyle.Default, compoundButton.getIcon().getForgroundColor(), false);
            FluentIconImageLoaderAsync fluentIconImageLoaderAsync = new FluentIconImageLoaderAsync(renderedCard, Util.getFluentIconSize(compoundButton.getIcon().getIconSize()), foregroundColorIcon, isFilledStyle, (View)imageView);
            fluentIconImageLoaderAsync.execute(new String[]{svgInfoURL});
        }
        TextView titleTextView = new TextView(context);
        titleTextView.setId(View.generateViewId());
        LinearLayout.LayoutParams titleParams = new LinearLayout.LayoutParams(-2, -2);
        titleParams.setMarginEnd(this.dpToPx(context, 8));
        titleTextView.setLayoutParams((ViewGroup.LayoutParams)titleParams);
        titleTextView.setEllipsize(TextUtils.TruncateAt.END);
        titleTextView.setSingleLine(true);
        titleTextView.setTypeface(null, 1);
        titleTextView.setTextSize(17.0f);
        titleTextView.setTextColor(Color.parseColor((String)foregroundColor));
        titleTextView.setText((CharSequence)compoundButton.getTitle());
        TextView badgeTextView = new TextView(context);
        badgeTextView.setId(View.generateViewId());
        LinearLayout.LayoutParams badgeParams = new LinearLayout.LayoutParams(-2, -2);
        badgeTextView.setLayoutParams((ViewGroup.LayoutParams)badgeParams);
        badgeTextView.setTextSize(12.0f);
        badgeTextView.setTextColor(Color.parseColor((String)backgroundColor));
        badgeTextView.setBackground(this.createCustomDrawable(context, hostConfig.GetCompoundButtonConfig().getBadgeConfig().getBackgroundColor(), 12));
        badgeTextView.setPadding(this.dpToPx(context, 8), this.dpToPx(context, 3), this.dpToPx(context, 8), this.dpToPx(context, 3));
        badgeTextView.setText((CharSequence)compoundButton.getBadge());
        if (compoundButton.getBadge().isEmpty()) {
            badgeTextView.setVisibility(8);
        }
        innerLayout.addView((View)imageView);
        innerLayout.addView((View)titleTextView);
        innerLayout.addView((View)badgeTextView);
        TextView descriptionTextView = new TextView(context);
        descriptionTextView.setId(View.generateViewId());
        LinearLayout.LayoutParams descriptionParams = new LinearLayout.LayoutParams(-2, -2);
        descriptionTextView.setLayoutParams((ViewGroup.LayoutParams)descriptionParams);
        descriptionTextView.setTextSize(15.0f);
        descriptionTextView.setTextColor(Color.parseColor((String)foregroundColor));
        descriptionTextView.setText((CharSequence)compoundButton.getDescription());
        if (compoundButton.getDescription().isEmpty()) {
            descriptionTextView.setVisibility(8);
        }
        layout2.addView((View)innerLayout);
        layout2.addView((View)descriptionTextView);
        layout2.setBackground(this.createCustomOuterDrawable(context, hostConfig.GetCompoundButtonConfig().getBorderColor()));
        return layout2;
    }

    public Drawable createCustomOuterDrawable(Context context, String borderColour) {
        GradientDrawable drawable2 = new GradientDrawable();
        drawable2.setShape(0);
        drawable2.setColor(0xFFFFFF);
        int strokeWidth = this.dpToPx(context, 1);
        drawable2.setStroke(strokeWidth, Color.parseColor((String)borderColour));
        float cornerRadius = this.dpToPx(context, 12);
        drawable2.setCornerRadius(cornerRadius);
        return drawable2;
    }

    public Drawable createCustomDrawable(Context context, String backgroundColor, int cornerRadius) {
        GradientDrawable drawable2 = new GradientDrawable();
        drawable2.setShape(0);
        drawable2.setColor(Color.parseColor((String)backgroundColor));
        float cornerRadiusPx = this.dpToPx(context, cornerRadius);
        drawable2.setCornerRadii(new float[]{cornerRadiusPx, cornerRadiusPx, cornerRadiusPx, cornerRadiusPx, cornerRadiusPx, cornerRadiusPx, cornerRadiusPx, cornerRadiusPx});
        return drawable2;
    }

    private int dpToPx(Context context, int dp) {
        float density = context.getResources().getDisplayMetrics().density;
        return Math.round((float)dp * density);
    }
}

