/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.view.View;
import android.widget.ImageView;
import com.caverock.androidsvg.SVG;
import io.adaptivecards.objectmodel.AdaptiveCardObjectModel;
import io.adaptivecards.renderer.FluentIconImageLoaderAsync;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.http.HttpRequestHelper;
import io.adaptivecards.renderer.http.HttpRequestResult;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 /2\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00040\u0001:\u0001/B-\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ)\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00042\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0017\"\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00042\u0006\u0010\u001a\u001a\u00020\u0002H\u0002J\u0010\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0004H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0002H\u0002J\u0018\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\bH\u0002J\u0018\u0010\"\u001a\u00020#2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0004H\u0014J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\u0010\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020\u0002H\u0002J\u001a\u0010+\u001a\u00020#2\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020\u000bH\u0016R\u000e\u0010\t\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00060"}, d2={"Lio/adaptivecards/renderer/FluentIconImageLoaderAsync;", "Landroid/os/AsyncTask;", "", "Ljava/lang/Void;", "Lio/adaptivecards/renderer/http/HttpRequestResult;", "renderedCard", "Lio/adaptivecards/renderer/RenderedAdaptiveCard;", "targetIconSize", "", "iconColor", "isFilledStyle", "", "view", "Landroid/view/View;", "(Lio/adaptivecards/renderer/RenderedAdaptiveCard;JLjava/lang/String;ZLandroid/view/View;)V", "getRenderedCard", "()Lio/adaptivecards/renderer/RenderedAdaptiveCard;", "viewReference", "Ljava/lang/ref/WeakReference;", "getViewReference", "()Ljava/lang/ref/WeakReference;", "doInBackground", "args", "", "([Ljava/lang/String;)Lio/adaptivecards/renderer/http/HttpRequestResult;", "fetchIconInfo", "svgURL", "fetchUnavailableIconInfo", "getDrawableFromSVG", "Landroid/graphics/drawable/BitmapDrawable;", "svgString", "getSvgString", "svgPath", "size", "onPostExecute", "", "result", "parseSvgString", "Lcom/caverock/androidsvg/SVG;", "context", "Landroid/content/Context;", "processResponseAndRenderFluentIcon", "response", "renderFluentIcon", "drawable", "Landroid/graphics/drawable/Drawable;", "flipInRtl", "Companion", "adaptivecards_release"})
public class FluentIconImageLoaderAsync
extends AsyncTask<String, Void, HttpRequestResult<String>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RenderedAdaptiveCard renderedCard;
    private final long targetIconSize;
    @NotNull
    private final String iconColor;
    private boolean isFilledStyle;
    @NotNull
    private final WeakReference<View> viewReference;
    @NotNull
    public static final String FILLED_STYLE = "filled";
    @NotNull
    public static final String REGULAR_STYLE = "regular";
    @NotNull
    public static final String SQUARE_ICON = "Square";
    @NotNull
    public static final String FLIP_IN_RTL_PROPERTY = "flipInRtl";

    public FluentIconImageLoaderAsync(@NotNull RenderedAdaptiveCard renderedCard, long targetIconSize, @NotNull String iconColor, boolean isFilledStyle, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)renderedCard, (String)"renderedCard");
        Intrinsics.checkNotNullParameter((Object)iconColor, (String)"iconColor");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.renderedCard = renderedCard;
        this.targetIconSize = targetIconSize;
        this.iconColor = iconColor;
        this.isFilledStyle = isFilledStyle;
        this.viewReference = new WeakReference<View>(view);
    }

    @NotNull
    public final RenderedAdaptiveCard getRenderedCard() {
        return this.renderedCard;
    }

    @NotNull
    public final WeakReference<View> getViewReference() {
        return this.viewReference;
    }

    @Nullable
    protected HttpRequestResult<String> doInBackground(String ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return args.length == 0 ? (HttpRequestResult<String>)null : this.fetchIconInfo(args[0]);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onPostExecute(@Nullable HttpRequestResult<String> result) {
        HttpRequestResult<String> httpRequestResult = result;
        boolean bl = httpRequestResult != null ? httpRequestResult.isSuccessful() : false;
        if (bl) {
            String string2 = result.getResult();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"result.result");
            if (((CharSequence)string2).length() > 0) {
                String string3 = result.getResult();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"result.result");
                this.processResponseAndRenderFluentIcon(string3);
                return;
            }
        }
        this.renderFluentIcon(null, false);
    }

    public void renderFluentIcon(@Nullable Drawable drawable, boolean flipInRtl) {
        View view = (View)this.viewReference.get();
        if (view != null && view instanceof ImageView) {
            ((ImageView)view).setImageDrawable(drawable);
            if (Intrinsics.areEqual((Object)this.renderedCard.getAdaptiveCard().GetRtl(), (Object)flipInRtl)) {
                ((ImageView)view).setScaleX(-1.0f);
            }
        }
    }

    private final HttpRequestResult<String> fetchIconInfo(String svgURL) {
        HttpRequestResult<String> httpRequestResult;
        try {
            byte[] byArray = HttpRequestHelper.get(svgURL);
            if (byArray == null) {
                throw new Exception("Failed to fetch icon info");
            }
            byte[] responseBytes = byArray;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            httpRequestResult = new HttpRequestResult<String>(new String(responseBytes, charset2));
        }
        catch (Exception e) {
            httpRequestResult = this.fetchUnavailableIconInfo();
        }
        return httpRequestResult;
    }

    private final void processResponseAndRenderFluentIcon(String response) {
        try {
            JSONObject responseJsonObject = new JSONObject(response);
            String style = this.isFilledStyle ? FILLED_STYLE : REGULAR_STYLE;
            boolean flipInRtl = responseJsonObject.optBoolean(FLIP_IN_RTL_PROPERTY, false);
            JSONObject styleJsonObject = responseJsonObject.getJSONObject(style);
            Iterator iterator = styleJsonObject.keys();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"styleJsonObject.keys()");
            List availableFluentIconSizes2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)processResponseAndRenderFluentIcon.availableFluentIconSizes.1.INSTANCE));
            long availableIconSizeClosestToGivenSize = Util.getSizeClosestToGivenSize(availableFluentIconSizes2, this.targetIconSize);
            Object object = styleJsonObject.getJSONArray(String.valueOf(availableIconSizeClosestToGivenSize)).get(0);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String svgPath = (String)object;
            String svgPathString = this.getSvgString(svgPath, availableIconSizeClosestToGivenSize);
            BitmapDrawable drawable = this.getDrawableFromSVG(svgPathString);
            this.renderFluentIcon((Drawable)drawable, flipInRtl);
        }
        catch (Exception e) {
            this.renderFluentIcon(null, false);
        }
    }

    private final HttpRequestResult<String> fetchUnavailableIconInfo() {
        HttpRequestResult<String> httpRequestResult;
        this.isFilledStyle = true;
        String unavailableIconURL = AdaptiveCardObjectModel.getBaseIconCDNUrl() + "/Square/Square.json";
        try {
            byte[] responseBytes = HttpRequestHelper.get(unavailableIconURL);
            Intrinsics.checkNotNullExpressionValue((Object)responseBytes, (String)"responseBytes");
            byte[] byArray = responseBytes;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            httpRequestResult = new HttpRequestResult<String>(new String(byArray, charset2));
        }
        catch (Exception e) {
            httpRequestResult = null;
        }
        return httpRequestResult;
    }

    private final String getSvgString(String svgPath, long size) {
        return "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"" + this.targetIconSize + "\" height=\"" + this.targetIconSize + "\" viewBox=\"0 0 " + size + ' ' + size + "\"> <path d=\"" + svgPath + "\"/></svg>";
    }

    @NotNull
    public SVG parseSvgString(@NotNull Context context, @NotNull String svgString) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)svgString, (String)"svgString");
        SVG svg = SVG.getFromString((String)svgString);
        svg.setDocumentWidth((float)Util.dpToPixels(context, this.targetIconSize));
        svg.setDocumentHeight((float)Util.dpToPixels(context, this.targetIconSize));
        Intrinsics.checkNotNullExpressionValue((Object)svg, (String)"svg");
        return svg;
    }

    private final BitmapDrawable getDrawableFromSVG(String svgString) {
        View view = (View)this.viewReference.get();
        if (view != null) {
            int n;
            View it = view;
            boolean bl = false;
            Context context = it.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"it.context");
            SVG svg = this.parseSvgString(context, svgString);
            Picture picture = svg.renderToPicture();
            Bitmap bitmap = Bitmap.createBitmap((int)picture.getWidth(), (int)picture.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            picture.draw(canvas);
            BitmapDrawable drawable = new BitmapDrawable(it.getContext().getResources(), bitmap);
            try {
                n = Color.parseColor((String)this.iconColor);
            }
            catch (IllegalArgumentException e) {
                n = -16777216;
            }
            int color = n;
            drawable.setColorFilter(color, PorterDuff.Mode.SRC_IN);
            return drawable;
        }
        return null;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/adaptivecards/renderer/FluentIconImageLoaderAsync$Companion;", "", "()V", "FILLED_STYLE", "", "FLIP_IN_RTL_PROPERTY", "REGULAR_STYLE", "SQUARE_ICON", "adaptivecards_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

