/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.objectmodel;

import io.adaptivecards.objectmodel.AdaptiveCardObjectModelJNI;
import io.adaptivecards.objectmodel.GridArea;
import java.util.AbstractList;
import java.util.RandomAccess;

public class GridAreaVector
extends AbstractList<GridArea>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected GridAreaVector(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(GridAreaVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                AdaptiveCardObjectModelJNI.delete_GridAreaVector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public GridAreaVector(GridArea[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (GridArea element : initialElements) {
            this.add(element);
        }
    }

    public GridAreaVector(Iterable<GridArea> initialElements) {
        this();
        for (GridArea element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public GridArea get(int index) {
        return this.doGet(index);
    }

    @Override
    public GridArea set(int index, GridArea e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(GridArea e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, GridArea e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public GridArea remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public GridAreaVector() {
        this(AdaptiveCardObjectModelJNI.new_GridAreaVector__SWIG_0(), true);
    }

    public GridAreaVector(GridAreaVector other) {
        this(AdaptiveCardObjectModelJNI.new_GridAreaVector__SWIG_1(GridAreaVector.getCPtr(other), other), true);
    }

    public long capacity() {
        return AdaptiveCardObjectModelJNI.GridAreaVector_capacity(this.swigCPtr, this);
    }

    public void reserve(long n) {
        AdaptiveCardObjectModelJNI.GridAreaVector_reserve(this.swigCPtr, this, n);
    }

    @Override
    public boolean isEmpty() {
        return AdaptiveCardObjectModelJNI.GridAreaVector_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        AdaptiveCardObjectModelJNI.GridAreaVector_clear(this.swigCPtr, this);
    }

    public GridAreaVector(int count, GridArea value) {
        this(AdaptiveCardObjectModelJNI.new_GridAreaVector__SWIG_2(count, GridArea.getCPtr(value), value), true);
    }

    private int doSize() {
        return AdaptiveCardObjectModelJNI.GridAreaVector_doSize(this.swigCPtr, this);
    }

    private void doAdd(GridArea x) {
        AdaptiveCardObjectModelJNI.GridAreaVector_doAdd__SWIG_0(this.swigCPtr, this, GridArea.getCPtr(x), x);
    }

    private void doAdd(int index, GridArea x) {
        AdaptiveCardObjectModelJNI.GridAreaVector_doAdd__SWIG_1(this.swigCPtr, this, index, GridArea.getCPtr(x), x);
    }

    private GridArea doRemove(int index) {
        long cPtr = AdaptiveCardObjectModelJNI.GridAreaVector_doRemove(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new GridArea(cPtr, true);
    }

    private GridArea doGet(int index) {
        long cPtr = AdaptiveCardObjectModelJNI.GridAreaVector_doGet(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new GridArea(cPtr, true);
    }

    private GridArea doSet(int index, GridArea val) {
        long cPtr = AdaptiveCardObjectModelJNI.GridAreaVector_doSet(this.swigCPtr, this, index, GridArea.getCPtr(val), val);
        return cPtr == 0L ? null : new GridArea(cPtr, true);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        AdaptiveCardObjectModelJNI.GridAreaVector_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

