/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.graphics.Color;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentManager;
import com.google.android.flexbox.FlexboxLayout;
import io.adaptivecards.objectmodel.AdaptiveCard;
import io.adaptivecards.objectmodel.BaseActionElementVector;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.HeightType;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.Layout;
import io.adaptivecards.objectmodel.LayoutContainerType;
import io.adaptivecards.renderer.AdaptiveFallbackException;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.IActionLayoutRenderer;
import io.adaptivecards.renderer.IOverflowActionRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.layout.StretchableElementLayout;
import io.adaptivecards.renderer.readonly.ContainerRenderer;
import io.adaptivecards.renderer.registration.CardRendererRegistration;

public class AdaptiveCardRenderer {
    public static final String VERSION = "1.6";
    private static AdaptiveCardRenderer s_instance = null;
    private HostConfig defaultHostConfig = new HostConfig();

    protected AdaptiveCardRenderer() {
    }

    public static AdaptiveCardRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new AdaptiveCardRenderer();
        }
        return s_instance;
    }

    public RenderedAdaptiveCard render(Context context, FragmentManager fragmentManager, AdaptiveCard adaptiveCard, ICardActionHandler cardActionHandler) {
        return this.render(context, fragmentManager, adaptiveCard, cardActionHandler, this.defaultHostConfig);
    }

    public RenderedAdaptiveCard render(Context context, FragmentManager fragmentManager, AdaptiveCard adaptiveCard, ICardActionHandler cardActionHandler, @Nullable IOverflowActionRenderer overflowActionRenderer) {
        return this.render(context, fragmentManager, adaptiveCard, cardActionHandler, overflowActionRenderer, this.defaultHostConfig);
    }

    public RenderedAdaptiveCard render(Context context, FragmentManager fragmentManager, AdaptiveCard adaptiveCard, ICardActionHandler cardActionHandler, HostConfig hostConfig) {
        return this.render(context, fragmentManager, adaptiveCard, cardActionHandler, null, hostConfig);
    }

    public RenderedAdaptiveCard render(Context context, FragmentManager fragmentManager, AdaptiveCard adaptiveCard, ICardActionHandler cardActionHandler, @Nullable IOverflowActionRenderer overflowActionRenderer, HostConfig hostConfig) {
        RenderedAdaptiveCard result = new RenderedAdaptiveCard(adaptiveCard);
        CardRendererRegistration.getInstance().registerOverflowActionRenderer(overflowActionRenderer);
        View cardView = this.internalRender(result, context, fragmentManager, adaptiveCard, cardActionHandler, hostConfig, false, -1L);
        result.setView(cardView);
        return result;
    }

    private void renderCardElements(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, AdaptiveCard adaptiveCard, ICardActionHandler cardActionHandler, HostConfig hostConfig, ViewGroup cardLayout, RenderArgs renderArgs, Layout layoutToApply) {
        try {
            CardRendererRegistration.getInstance().renderElements(renderedCard, context, fragmentManager, cardLayout, adaptiveCard.GetBody(), cardActionHandler, hostConfig, renderArgs, layoutToApply);
        }
        catch (AdaptiveFallbackException adaptiveFallbackException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public View internalRender(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, AdaptiveCard adaptiveCard, ICardActionHandler cardActionHandler, HostConfig hostConfig, boolean isInlineShowCard, long containerCardId) {
        if (hostConfig == null) {
            throw new IllegalArgumentException("hostConfig is null");
        }
        if (renderedCard == null) {
            throw new IllegalArgumentException("renderedCard is null");
        }
        LinearLayout rootLayout = new LinearLayout(context);
        rootLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        rootLayout.setOrientation(1);
        rootLayout.setClipChildren(false);
        rootLayout.setClipToPadding(false);
        Layout layoutToApply = Util.getLayoutToApply(adaptiveCard.GetLayouts(), hostConfig);
        long cardMinHeight = adaptiveCard.GetMinHeight();
        StretchableElementLayout cardLayout = new StretchableElementLayout(context, adaptiveCard.GetHeight() == HeightType.Stretch || cardMinHeight != 0L);
        cardLayout.setTag(adaptiveCard);
        cardLayout.setClipChildren(false);
        cardLayout.setClipToPadding(false);
        BaseCardElementRenderer.setMinHeight(cardMinHeight, (View)rootLayout, context);
        BaseCardElementRenderer.applyRtl(adaptiveCard.GetRtl(), (ViewGroup)cardLayout);
        ContainerRenderer.applyVerticalContentAlignment((ViewGroup)cardLayout, adaptiveCard.GetVerticalContentAlignment(), layoutToApply);
        cardLayout.setOrientation(1);
        int padding = Util.dpToPixels(context, hostConfig.GetSpacing().getPaddingSpacing());
        cardLayout.setPadding(padding, padding, padding, padding);
        rootLayout.addView((View)cardLayout);
        ContainerStyle style = ContainerStyle.Default;
        if (isInlineShowCard && hostConfig.GetActions().getShowCard().getStyle() != ContainerStyle.None) {
            style = hostConfig.GetActions().getShowCard().getStyle();
        }
        if (hostConfig.GetAdaptiveCard().getAllowCustomStyle() && adaptiveCard.GetStyle() != ContainerStyle.None) {
            style = adaptiveCard.GetStyle();
        }
        RenderArgs renderArgs = new RenderArgs();
        renderArgs.setContainerStyle(style);
        renderArgs.setAncestorHasSelectAction(adaptiveCard.GetSelectAction() != null);
        long cardId = Util.getViewId((View)rootLayout);
        renderArgs.setContainerCardId(cardId);
        renderedCard.setParentToCard(cardId, containerCardId);
        String color = hostConfig.GetBackgroundColor(style);
        cardLayout.setBackgroundColor(Color.parseColor((String)color));
        if (layoutToApply.GetLayoutContainerType() == LayoutContainerType.Flow) {
            FlexboxLayout flexboxLayout = AdaptiveCardRenderer.getFlexboxContainerForLayout(context);
            Util.setHorizontalAlignmentForFlowLayout(flexboxLayout, layoutToApply);
            this.renderCardElements(renderedCard, context, fragmentManager, adaptiveCard, cardActionHandler, hostConfig, (ViewGroup)flexboxLayout, renderArgs, layoutToApply);
            ContainerRenderer.applyItemFillForFlowLayout(layoutToApply, (ViewGroup)flexboxLayout);
            cardLayout.addView((View)flexboxLayout);
        } else {
            this.renderCardElements(renderedCard, context, fragmentManager, adaptiveCard, cardActionHandler, hostConfig, (ViewGroup)cardLayout, renderArgs, layoutToApply);
        }
        if (hostConfig.GetSupportsInteractivity()) {
            BaseActionElementVector baseActionElementList = adaptiveCard.GetActions();
            if (baseActionElementList != null && baseActionElementList.size() > 0) {
                Pair<BaseActionElementVector, BaseActionElementVector> actionElementVectorPair = Util.splitActionsByMode(baseActionElementList, hostConfig, renderedCard);
                BaseActionElementVector primaryElementVector = (BaseActionElementVector)actionElementVectorPair.first;
                BaseActionElementVector secondaryElementVector = (BaseActionElementVector)actionElementVectorPair.second;
                LinearLayout showCardsLayout = new LinearLayout(context);
                showCardsLayout.setBackgroundColor(Color.parseColor((String)color));
                showCardsLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
                rootLayout.addView((View)showCardsLayout);
                IActionLayoutRenderer actionLayoutRenderer = CardRendererRegistration.getInstance().getActionLayoutRenderer();
                if (actionLayoutRenderer != null) {
                    try {
                        renderArgs.setRootLevelActions(!isInlineShowCard);
                        View actionButtonsLayout = actionLayoutRenderer.renderActions(renderedCard, context, fragmentManager, (ViewGroup)cardLayout, primaryElementVector, cardActionHandler, hostConfig, renderArgs);
                        if (!secondaryElementVector.isEmpty()) {
                            IActionLayoutRenderer secondaryActionLayoutRenderer = CardRendererRegistration.getInstance().getOverflowActionLayoutRenderer();
                            StretchableElementLayout rootActionLayout = actionButtonsLayout instanceof ViewGroup ? (ViewGroup)actionButtonsLayout : cardLayout;
                            secondaryActionLayoutRenderer.renderActions(renderedCard, context, fragmentManager, (ViewGroup)rootActionLayout, secondaryElementVector, cardActionHandler, hostConfig, renderArgs);
                        }
                    }
                    catch (AdaptiveFallbackException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            renderedCard.addWarning(new AdaptiveWarning(3, "Interactivity is not allowed. Actions not rendered."));
        }
        ContainerRenderer.setBackgroundImage(renderedCard, context, adaptiveCard.GetBackgroundImage(), hostConfig, (ViewGroup)cardLayout);
        ContainerRenderer.setSelectAction(renderedCard, renderedCard.getAdaptiveCard().GetSelectAction(), (View)rootLayout, cardActionHandler, renderArgs);
        return rootLayout;
    }

    private static FlexboxLayout getFlexboxContainerForLayout(Context context) {
        FlexboxLayout flexboxLayout = new FlexboxLayout(context);
        flexboxLayout.setFlexDirection(0);
        flexboxLayout.setFlexWrap(1);
        flexboxLayout.setLayoutParams((ViewGroup.LayoutParams)new FlexboxLayout.LayoutParams(-1, -2));
        return flexboxLayout;
    }
}

