/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentManager;
import com.google.android.flexbox.FlexboxLayout;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.CompoundButton;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.ForegroundColor;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.IconStyle;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.FluentIconImageLoaderAsync;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.readonly.ContainerRenderer;

public class CompoundButtonRenderer
extends BaseCardElementRenderer {
    private static CompoundButtonRenderer s_instance = null;

    protected CompoundButtonRenderer() {
    }

    public static CompoundButtonRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new CompoundButtonRenderer();
        }
        return s_instance;
    }

    @Override
    @Nullable
    public View render(@NonNull RenderedAdaptiveCard renderedCard, @NonNull Context context, @NonNull FragmentManager fragmentManager, @NonNull ViewGroup viewGroup, @NonNull BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, @NonNull HostConfig hostConfig, @NonNull RenderArgs renderArgs) throws Exception {
        CompoundButton compoundButton = Util.castTo(baseCardElement, CompoundButton.class);
        ViewGroup compoundButtonLayout = this.getCompoundButtonLayout(context, compoundButton, renderedCard, hostConfig, renderArgs);
        compoundButtonLayout.setTag((Object)new TagContent(compoundButton));
        viewGroup.addView((View)compoundButtonLayout);
        ContainerRenderer.setSelectAction(renderedCard, compoundButton.GetSelectAction(), (View)compoundButtonLayout, cardActionHandler, renderArgs);
        return compoundButtonLayout;
    }

    private ViewGroup getCompoundButtonLayout(Context context, CompoundButton compoundButton, RenderedAdaptiveCard renderedCard, HostConfig hostConfig, RenderArgs renderArgs) {
        ContainerStyle style = renderArgs.getContainerStyle();
        String foregroundColor = hostConfig.GetForegroundColor(style, ForegroundColor.Default, false);
        String backgroundColor = hostConfig.GetBackgroundColor(style);
        FlexboxLayout flexboxLayout = new FlexboxLayout(context);
        FlexboxLayout.LayoutParams flexboxLayoutParams = new FlexboxLayout.LayoutParams(-1, -2);
        flexboxLayout.setLayoutParams((ViewGroup.LayoutParams)flexboxLayoutParams);
        flexboxLayout.setFlexDirection(2);
        int paddingPx = this.dpToPx(context, 16);
        flexboxLayout.setPadding(paddingPx, paddingPx, paddingPx, paddingPx);
        FlexboxLayout headerLayout = new FlexboxLayout(context);
        FlexboxLayout.LayoutParams headerLayoutParams = new FlexboxLayout.LayoutParams(-2, -2);
        headerLayout.setFlexDirection(0);
        headerLayout.setFlexWrap(1);
        headerLayout.setJustifyContent(0);
        headerLayout.setAlignItems(2);
        headerLayout.setLayoutParams((ViewGroup.LayoutParams)headerLayoutParams);
        boolean isIconSet = compoundButton.getIcon() != null && !compoundButton.getIcon().GetName().isEmpty();
        ImageView imageView = new ImageView(context);
        LinearLayout.LayoutParams imageLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        imageLayoutParams.setMarginEnd(this.dpToPx(context, 8));
        imageView.setLayoutParams((ViewGroup.LayoutParams)imageLayoutParams);
        if (!isIconSet) {
            imageView.setVisibility(8);
        } else {
            boolean isFilledStyle = compoundButton.getIcon().getIconStyle() == IconStyle.Filled;
            String svgInfoURL = compoundButton.getIcon().GetSVGInfoURL();
            String foregroundColorIcon = hostConfig.GetForegroundColor(ContainerStyle.Default, compoundButton.getIcon().getForgroundColor(), false);
            FluentIconImageLoaderAsync fluentIconImageLoaderAsync = new FluentIconImageLoaderAsync(renderedCard, Util.getFluentIconSize(compoundButton.getIcon().getIconSize()), foregroundColorIcon, isFilledStyle, (View)imageView);
            fluentIconImageLoaderAsync.execute(new String[]{svgInfoURL});
        }
        LinearLayout.LayoutParams titleLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        titleLayoutParams.setMarginEnd(this.dpToPx(context, 8));
        TextView titleTextView = new TextView(context);
        titleTextView.setLayoutParams((ViewGroup.LayoutParams)titleLayoutParams);
        titleTextView.setText((CharSequence)compoundButton.getTitle());
        titleTextView.setSingleLine();
        titleTextView.setTextSize(17.0f);
        titleTextView.setTextColor(Color.parseColor((String)foregroundColor));
        titleTextView.setEllipsize(TextUtils.TruncateAt.END);
        titleTextView.setTypeface(null, 1);
        TextView badgeTextView = new TextView(context);
        LinearLayout.LayoutParams badgeLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        badgeTextView.setLayoutParams((ViewGroup.LayoutParams)badgeLayoutParams);
        badgeTextView.setTextSize(12.0f);
        badgeTextView.setText((CharSequence)compoundButton.getBadge());
        badgeTextView.setTextColor(Color.parseColor((String)backgroundColor));
        badgeTextView.setBackground(this.createCustomDrawable(context, hostConfig.GetCompoundButtonConfig().getBadgeConfig().getBackgroundColor(), 12));
        badgeTextView.setPadding(this.dpToPx(context, 8), this.dpToPx(context, 3), this.dpToPx(context, 8), this.dpToPx(context, 3));
        if (compoundButton.getBadge().isEmpty()) {
            badgeTextView.setVisibility(8);
        }
        headerLayout.addView((View)imageView);
        headerLayout.addView((View)titleTextView);
        headerLayout.addView((View)badgeTextView);
        flexboxLayout.addView((View)headerLayout);
        TextView descriptionTextView = new TextView(context);
        FlexboxLayout.LayoutParams descriptionLayoutParams = new FlexboxLayout.LayoutParams(-2, -2);
        descriptionTextView.setLayoutParams((ViewGroup.LayoutParams)descriptionLayoutParams);
        descriptionTextView.setTextSize(15.0f);
        descriptionTextView.setText((CharSequence)compoundButton.getDescription());
        descriptionTextView.setTextColor(Color.parseColor((String)foregroundColor));
        descriptionTextView.setLayoutParams((ViewGroup.LayoutParams)descriptionLayoutParams);
        if (compoundButton.getDescription().isEmpty()) {
            descriptionTextView.setVisibility(8);
        }
        flexboxLayout.addView((View)descriptionTextView);
        flexboxLayout.setBackground(this.createCustomOuterDrawable(context, hostConfig.GetCompoundButtonConfig().getBorderColor()));
        return flexboxLayout;
    }

    public Drawable createCustomOuterDrawable(Context context, String borderColour) {
        GradientDrawable drawable2 = new GradientDrawable();
        drawable2.setShape(0);
        drawable2.setColor(0xFFFFFF);
        int strokeWidth = this.dpToPx(context, 1);
        drawable2.setStroke(strokeWidth, Color.parseColor((String)borderColour));
        float cornerRadius = this.dpToPx(context, 12);
        drawable2.setCornerRadius(cornerRadius);
        return drawable2;
    }

    public Drawable createCustomDrawable(Context context, String backgroundColor, int cornerRadius) {
        GradientDrawable drawable2 = new GradientDrawable();
        drawable2.setShape(0);
        drawable2.setColor(Color.parseColor((String)backgroundColor));
        float cornerRadiusPx = this.dpToPx(context, cornerRadius);
        drawable2.setCornerRadii(new float[]{cornerRadiusPx, cornerRadiusPx, cornerRadiusPx, cornerRadiusPx, cornerRadiusPx, cornerRadiusPx, cornerRadiusPx, cornerRadiusPx});
        return drawable2;
    }

    private int dpToPx(Context context, int dp) {
        float density = context.getResources().getDisplayMetrics().density;
        return Math.round((float)dp * density);
    }
}

