/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.os.AsyncTask;
import android.util.DisplayMetrics;
import android.util.Pair;
import android.util.TypedValue;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import com.google.android.flexbox.FlexboxLayout;
import io.adaptivecards.R;
import io.adaptivecards.objectmodel.BaseActionElement;
import io.adaptivecards.objectmodel.BaseActionElementVector;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.BaseElement;
import io.adaptivecards.objectmodel.BaseInputElement;
import io.adaptivecards.objectmodel.CharVector;
import io.adaptivecards.objectmodel.Column;
import io.adaptivecards.objectmodel.FlowLayout;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.HostWidth;
import io.adaptivecards.objectmodel.HostWidthConfig;
import io.adaptivecards.objectmodel.IconPlacement;
import io.adaptivecards.objectmodel.IconSize;
import io.adaptivecards.objectmodel.JsonValue;
import io.adaptivecards.objectmodel.Layout;
import io.adaptivecards.objectmodel.LayoutContainerType;
import io.adaptivecards.objectmodel.LayoutVector;
import io.adaptivecards.objectmodel.Mode;
import io.adaptivecards.objectmodel.ParseContext;
import io.adaptivecards.objectmodel.TargetWidthType;
import io.adaptivecards.renderer.ActionElementRendererFluentIconImageLoaderAsync;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.IOverflowActionRenderer;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.action.ActionElementRendererIconImageLoaderAsync;
import io.adaptivecards.renderer.registration.CardRendererRegistration;
import io.adaptivecards.renderer.registration.FeatureFlagResolverUtility;
import java.lang.reflect.Method;
import java.util.List;

public final class Util {
    private static final String FLUENT_ICON_URL_PREFIX = "icon:";

    public static int dpToPixels(Context context, float dp) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        int returnVal = (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)metrics);
        return returnVal;
    }

    public static void expandClickArea(@NonNull View viewToIncreaseClickArea, int adjustedMinSize) {
        Rect delegateArea = new Rect();
        viewToIncreaseClickArea.getHitRect(delegateArea);
        int widthOffset = (int)((float)(adjustedMinSize - delegateArea.width()) / 2.0f);
        int heightOffset = (int)((float)(adjustedMinSize - delegateArea.height()) / 2.0f);
        delegateArea.left -= widthOffset;
        delegateArea.right += widthOffset;
        delegateArea.top -= heightOffset;
        delegateArea.bottom += heightOffset;
        TouchDelegate touchDelegate = new TouchDelegate(delegateArea, viewToIncreaseClickArea);
        if (viewToIncreaseClickArea.getParent() instanceof View) {
            ((View)viewToIncreaseClickArea.getParent()).setTouchDelegate(touchDelegate);
        }
    }

    public static byte[] getBytes(CharVector charVector) {
        long vectorSize = charVector.size();
        byte[] byteArray = new byte[(int)vectorSize];
        int i = 0;
        while ((long)i < vectorSize) {
            byteArray[i] = (byte)charVector.get(i).charValue();
            ++i;
        }
        return byteArray;
    }

    public static void forceFocus(View v) {
        boolean focusableInTouchMode = v.isFocusableInTouchMode();
        v.setFocusable(true);
        v.setFocusableInTouchMode(true);
        v.requestFocusFromTouch();
        v.setFocusableInTouchMode(focusableInTouchMode);
    }

    public static Bitmap scaleBitmapToHeight(float height, Bitmap bitmap) {
        BitmapDrawable d = new BitmapDrawable(null, bitmap);
        float scaleRatio = height / (float)d.getIntrinsicHeight();
        float width = scaleRatio * (float)d.getIntrinsicWidth();
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)width), (int)((int)height), (boolean)false);
    }

    public static HostWidth convertHostCardContainerToHostWidth(int hostCardContainer, HostWidthConfig hostWidthConfig) {
        if (hostCardContainer <= 0 || hostWidthConfig == null || hostWidthConfig.getVeryNarrow() == 0L || hostWidthConfig.getNarrow() == 0L || hostWidthConfig.getStandard() == 0L) {
            return HostWidth.Default;
        }
        HostWidth hostWidth = (long)hostCardContainer <= hostWidthConfig.getVeryNarrow() ? HostWidth.VeryNarrow : ((long)hostCardContainer > hostWidthConfig.getVeryNarrow() && (long)hostCardContainer <= hostWidthConfig.getNarrow() ? HostWidth.Narrow : ((long)hostCardContainer > hostWidthConfig.getNarrow() && (long)hostCardContainer <= hostWidthConfig.getStandard() ? HostWidth.Standard : HostWidth.Wide));
        return hostWidth;
    }

    public static void MoveChildrenViews(ViewGroup origin, ViewGroup destination, Layout layoutToApply, HostConfig hostConfig) {
        int childCount = origin.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View v = origin.getChildAt(i);
            origin.removeView(v);
            if (layoutToApply.GetLayoutContainerType() == LayoutContainerType.Flow && destination instanceof FlexboxLayout) {
                v.setLayoutParams((ViewGroup.LayoutParams)Util.generateLayoutParamsForFlowLayoutItems(destination.getContext(), layoutToApply, hostConfig));
            }
            destination.addView(v);
        }
    }

    public static void setHorizontalAlignmentForFlowLayout(FlexboxLayout flexboxLayout, Layout layout2) {
        FlowLayout flowLayout = Util.castTo(layout2, FlowLayout.class);
        switch (flowLayout.GetHorizontalAlignment()) {
            case Right: {
                flexboxLayout.setJustifyContent(1);
                break;
            }
            case Left: {
                flexboxLayout.setJustifyContent(0);
                break;
            }
            default: {
                flexboxLayout.setJustifyContent(2);
            }
        }
    }

    public static FlexboxLayout.LayoutParams generateLayoutParamsForFlowLayoutItems(Context context, Layout layoutToApply, HostConfig hostConfig) {
        FlowLayout flowLayout = Util.castTo(layoutToApply, FlowLayout.class);
        int valueNotDefinedIndicator = 0;
        int itemWidth = Util.isValueDefined(flowLayout.GetItemPixelWidth()) ? Util.dpToPixels(context, flowLayout.GetItemPixelWidth()) : -2;
        int maxItemWidth = Util.isValueDefined(flowLayout.GetMaxItemPixelWidth()) ? Util.dpToPixels(context, flowLayout.GetMaxItemPixelWidth()) : valueNotDefinedIndicator;
        int minItemWidth = Util.isValueDefined(flowLayout.GetMinItemPixelWidth()) ? Util.dpToPixels(context, flowLayout.GetMinItemPixelWidth()) : valueNotDefinedIndicator;
        int widthToApply = itemWidth;
        if (maxItemWidth != valueNotDefinedIndicator && (itemWidth == -2 || itemWidth >= maxItemWidth)) {
            widthToApply = maxItemWidth;
        }
        FlexboxLayout.LayoutParams params = new FlexboxLayout.LayoutParams(widthToApply, -2);
        int rowSpacing = Util.dpToPixels(context, BaseCardElementRenderer.getSpacingSize(flowLayout.GetRowSpacing(), hostConfig.GetSpacing()));
        int columnSpacing = Util.dpToPixels(context, BaseCardElementRenderer.getSpacingSize(flowLayout.GetColumnSpacing(), hostConfig.GetSpacing()));
        params.setMargins(rowSpacing, columnSpacing, rowSpacing, columnSpacing);
        if (minItemWidth != valueNotDefinedIndicator) {
            params.setMinWidth(minItemWidth);
        }
        if (maxItemWidth != valueNotDefinedIndicator) {
            params.setMaxWidth(maxItemWidth);
        }
        return params;
    }

    public static Layout getLayoutToApply(LayoutVector layouts, HostConfig hostConfig) {
        LayoutContainerType layoutContainerType;
        Layout layoutToApply = new Layout();
        layoutToApply.SetLayoutContainerType(LayoutContainerType.None);
        HostWidthConfig hostWidthConfig = hostConfig.getHostWidth();
        int hostCardContainer = CardRendererRegistration.getInstance().getHostCardContainer();
        HostWidth hostWidth = Util.convertHostCardContainerToHostWidth(hostCardContainer, hostWidthConfig);
        if (layouts != null) {
            for (int i = 0; i < layouts.size(); ++i) {
                Layout currentLayout = layouts.get(i);
                if (currentLayout.GetLayoutContainerType() == LayoutContainerType.None) continue;
                if (currentLayout.MeetsTargetWidthRequirement(hostWidth)) {
                    layoutToApply = currentLayout;
                    break;
                }
                if (currentLayout.GetTargetWidth() != TargetWidthType.Default) continue;
                layoutToApply = currentLayout;
            }
        }
        if ((layoutContainerType = layoutToApply.GetLayoutContainerType()) == LayoutContainerType.Flow && FeatureFlagResolverUtility.INSTANCE.isFlowLayoutEnabled() || layoutContainerType == LayoutContainerType.AreaGrid && FeatureFlagResolverUtility.INSTANCE.isGridLayoutEnabled()) {
            return layoutToApply;
        }
        Layout defaultStackLayout = new Layout();
        defaultStackLayout.SetLayoutContainerType(LayoutContainerType.Stack);
        defaultStackLayout.SetTargetWidth(TargetWidthType.Default);
        return defaultStackLayout;
    }

    private static boolean isValueDefined(int inputValue) {
        int undefinedValueIndicator = -1;
        return inputValue != undefinedValueIndicator;
    }

    @Nullable
    public static BaseCardElement tryCastToBaseCardElement(BaseElement baseElement) {
        try {
            return Util.castToBaseCardElement(baseElement);
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    public static BaseCardElement castToBaseCardElement(BaseElement baseElement) throws ClassCastException {
        BaseCardElement baseCardElement;
        if (baseElement instanceof BaseCardElement) {
            baseCardElement = (BaseCardElement)baseElement;
        } else {
            baseCardElement = BaseCardElement.dynamic_cast(baseElement);
            if (baseCardElement == null) {
                throw new ClassCastException("Unable to convert BaseElement to BaseCardElement object model.");
            }
        }
        return baseCardElement;
    }

    public static <T extends BaseCardElement> boolean isOfType(BaseCardElement cardElement, Class<T> cardElementType) {
        return Util.tryCastTo(cardElement, cardElementType) != null;
    }

    public static ViewGroup getMockLayout(Context context, BaseCardElement baseCardElement) {
        if (Util.isOfType(baseCardElement, Column.class)) {
            return new FlexboxLayout(context);
        }
        return new LinearLayout(context);
    }

    public static <T extends BaseCardElement> T tryCastTo(BaseCardElement cardElement, Class<T> cardElementType) {
        try {
            return Util.castTo(cardElement, cardElementType);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T extends BaseCardElement> T castTo(BaseCardElement cardElement, Class<T> cardElementType) throws ClassCastException {
        try {
            BaseCardElement castedElement = null;
            if (cardElementType.isAssignableFrom(cardElement.getClass())) {
                castedElement = cardElement;
            } else {
                Method dynamicCastMethod = cardElementType.getMethod("dynamic_cast", BaseCardElement.class);
                castedElement = (BaseCardElement)dynamicCastMethod.invoke(null, cardElement);
                if (castedElement == null) {
                    throw new InternalError("Unable to convert " + cardElement.getClass().getName() + " to " + cardElementType.getName() + " object model.");
                }
            }
            return (T)castedElement;
        }
        catch (Exception e) {
            throw new ClassCastException("Unable to find dynamic_cast method in " + cardElementType.getName() + ".");
        }
    }

    public static <T extends Layout> T castTo(Layout layout2, Class<T> layoutType) throws ClassCastException {
        try {
            Layout castedElement = null;
            if (layoutType.isAssignableFrom(layout2.getClass())) {
                castedElement = layout2;
            } else {
                Method dynamicCastMethod = layoutType.getMethod("dynamic_cast", Layout.class);
                castedElement = (Layout)dynamicCastMethod.invoke(null, layout2);
                if (castedElement == null) {
                    throw new InternalError("Unable to convert " + layout2.getClass().getName() + " to " + layoutType.getName() + " object model.");
                }
            }
            return (T)castedElement;
        }
        catch (Exception e) {
            throw new ClassCastException("Unable to find dynamic_cast method in " + layoutType.getName() + ".");
        }
    }

    @Nullable
    public static BaseActionElement tryCastToBaseActionElement(BaseElement baseElement) {
        try {
            return Util.castToBaseActionElement(baseElement);
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    public static BaseActionElement castToBaseActionElement(BaseElement baseElement) throws ClassCastException {
        BaseActionElement baseActionElement;
        if (baseElement instanceof BaseActionElement) {
            baseActionElement = (BaseActionElement)baseElement;
        } else {
            baseActionElement = BaseActionElement.dynamic_cast(baseElement);
            if (baseActionElement == null) {
                throw new ClassCastException("Unable to convert BaseElement to BaseCardElement object model.");
            }
        }
        return baseActionElement;
    }

    public static <T extends BaseActionElement> boolean isOfType(BaseActionElement actionElement, Class<T> actionElementType) {
        return Util.tryCastTo(actionElement, actionElementType) != null;
    }

    public static <T extends BaseActionElement> T tryCastTo(BaseActionElement actionElement, Class<T> actionElementType) {
        try {
            return Util.castTo(actionElement, actionElementType);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Dimension(unit=0)
    public static int pixelToDp(@NonNull Context context, @Px int px) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return Math.round((float)px / displayMetrics.density);
    }

    public static <T extends BaseActionElement> T castTo(BaseActionElement actionElement, Class<T> actionElementType) throws ClassCastException {
        try {
            BaseActionElement castedElement = null;
            if (actionElementType.isAssignableFrom(actionElement.getClass())) {
                castedElement = actionElement;
            } else {
                Method dynamicCastMethod = actionElementType.getMethod("dynamic_cast", BaseActionElement.class);
                castedElement = (BaseActionElement)dynamicCastMethod.invoke(null, actionElement);
                if (castedElement == null) {
                    throw new InternalError("Unable to convert " + actionElement.getClass().getName() + " to " + actionElementType.getName() + " object model.");
                }
            }
            return (T)castedElement;
        }
        catch (Exception e) {
            throw new ClassCastException("Unable to find dynamic_cast method in " + actionElementType.getName() + ".");
        }
    }

    private static void CopyActionProperties(BaseActionElement origin, BaseActionElement dest) {
        dest.SetId(origin.GetId());
        dest.SetIconUrl(origin.GetIconUrl());
        dest.SetStyle(origin.GetStyle());
        dest.SetTitle(origin.GetTitle());
        dest.SetFallbackContent(origin.GetFallbackContent());
        dest.SetFallbackType(origin.GetFallbackType());
        dest.SetTooltip(origin.GetTooltip());
    }

    public static void deserializeBaseActionProperties(ParseContext context, JsonValue value, BaseActionElement actionElement) {
        BaseActionElement baseActionElement = BaseActionElement.DeserializeBaseProperties(context, value);
        Util.CopyActionProperties(baseActionElement, actionElement);
    }

    public static void deserializeBaseActionPropertiesFromString(ParseContext context, String jsonString, BaseActionElement actionElement) {
        BaseActionElement baseActionElement = BaseActionElement.DeserializeBasePropertiesFromString(context, jsonString);
        Util.CopyActionProperties(baseActionElement, actionElement);
    }

    private static void CopyCardElementProperties(BaseCardElement origin, BaseCardElement dest) {
        dest.SetId(origin.GetId());
        dest.SetHeight(origin.GetHeight());
        dest.SetIsVisible(origin.GetIsVisible());
        dest.SetSeparator(origin.GetSeparator());
        dest.SetSpacing(origin.GetSpacing());
        dest.SetFallbackContent(origin.GetFallbackContent());
        dest.SetFallbackType(origin.GetFallbackType());
    }

    public static void deserializeBaseCardElementProperties(ParseContext context, JsonValue value, BaseCardElement cardElement) {
        BaseCardElement baseCardElement = BaseCardElement.DeserializeBaseProperties(context, value);
        Util.CopyCardElementProperties(baseCardElement, cardElement);
    }

    public static void deserializeBaseCardElementPropertiesFromString(ParseContext context, String jsonString, BaseCardElement cardElement) {
        BaseCardElement baseCardElement = BaseCardElement.DeserializeBasePropertiesFromString(context, jsonString);
        Util.CopyCardElementProperties(baseCardElement, cardElement);
    }

    private static void CopyInputProperties(BaseInputElement origin, BaseInputElement dest) {
        Util.CopyCardElementProperties(origin, dest);
        dest.SetIsRequired(origin.GetIsRequired());
        dest.SetErrorMessage(origin.GetErrorMessage());
        dest.SetLabel(origin.GetLabel());
    }

    public static void deserializeBaseInputProperties(ParseContext context, JsonValue value, BaseInputElement inputElement) {
        BaseInputElement baseInputElement = BaseInputElement.DeserializeBaseProperties(context, value);
        Util.CopyInputProperties(baseInputElement, inputElement);
    }

    public static void deserializeBaseInputPropertiesFromString(ParseContext context, String jsonString, BaseInputElement inputElement) {
        BaseInputElement baseInputElement = BaseInputElement.DeserializeBasePropertiesFromString(context, jsonString);
        Util.CopyInputProperties(baseInputElement, inputElement);
    }

    public static long getViewId(View view) {
        if (view.getId() == -1) {
            view.setId(View.generateViewId());
        }
        return view.getId();
    }

    public static Pair<BaseActionElementVector, BaseActionElementVector> splitActionsByMode(@NonNull BaseActionElementVector actionElements, @NonNull HostConfig hostConfig, @NonNull RenderedAdaptiveCard renderedCard) {
        long maxActions = hostConfig.GetActions().getMaxActions();
        BaseActionElementVector primaryActionElementVector = new BaseActionElementVector();
        BaseActionElementVector secondaryActionElementVector = new BaseActionElementVector();
        for (BaseActionElement actionElement : actionElements) {
            if (actionElement.GetMode() == Mode.Secondary) {
                secondaryActionElementVector.add(actionElement);
                continue;
            }
            primaryActionElementVector.add(actionElement);
        }
        int primaryElementsSize = primaryActionElementVector.size();
        if ((long)primaryElementsSize > maxActions) {
            List excessElements = primaryActionElementVector.subList((int)maxActions, primaryElementsSize);
            IOverflowActionRenderer overflowActionRenderer = CardRendererRegistration.getInstance().getOverflowActionRenderer();
            if (overflowActionRenderer != null && overflowActionRenderer.shouldAllowMoreThanMaxActionsInOverflowMenu()) {
                secondaryActionElementVector.addAll(excessElements);
            } else {
                renderedCard.addWarning(new AdaptiveWarning(4, "A maximum of " + maxActions + " actions are allowed"));
            }
            excessElements.clear();
        }
        return new Pair((Object)primaryActionElementVector, (Object)secondaryActionElementVector);
    }

    public static void loadIcon(Context context, View view, String iconUrl, String svgInfoURL, HostConfig hostConfig, RenderedAdaptiveCard renderedCard, IconPlacement iconPlacement) {
        if (!iconUrl.startsWith(FLUENT_ICON_URL_PREFIX)) {
            ActionElementRendererIconImageLoaderAsync imageLoader = new ActionElementRendererIconImageLoaderAsync(renderedCard, view, hostConfig.GetImageBaseUrl(), iconPlacement, hostConfig.GetActions().getIconSize(), hostConfig.GetSpacing().getDefaultSpacing(), context);
            imageLoader.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[]{iconUrl});
        } else {
            long fluentIconSize = 24L;
            int color2 = ((Button)view).getCurrentTextColor();
            String hexColor = String.format("#%06X", 0xFFFFFF & color2);
            boolean isFilledStyle = iconUrl.contains("filled");
            ActionElementRendererFluentIconImageLoaderAsync fluentIconLoaderAsync = new ActionElementRendererFluentIconImageLoaderAsync(renderedCard, fluentIconSize, isFilledStyle, view, hexColor, iconPlacement, hostConfig.GetSpacing().getDefaultSpacing(), hostConfig.GetActions().getIconSize());
            fluentIconLoaderAsync.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[]{svgInfoURL});
        }
    }

    public static long getFluentIconSize(IconSize iconSize) {
        long _size = 24L;
        switch (iconSize) {
            case xxSmall: {
                _size = 16L;
                break;
            }
            case xSmall: {
                _size = 20L;
                break;
            }
            case Small: {
                _size = 24L;
                break;
            }
            case Standard: {
                _size = 32L;
                break;
            }
            case Medium: {
                _size = 48L;
                break;
            }
            case Large: {
                _size = 56L;
                break;
            }
            case xLarge: {
                _size = 72L;
                break;
            }
            case xxLarge: {
                _size = 96L;
            }
        }
        return _size;
    }

    static long getSizeClosestToGivenSize(List<Long> availableSizes, Long targetIconSize) {
        long minDiff = Long.MAX_VALUE;
        long closestSize = targetIconSize;
        for (Long availableSize : availableSizes) {
            long diff = Math.abs(availableSize - targetIconSize);
            if (diff >= minDiff) continue;
            minDiff = diff;
            closestSize = availableSize;
        }
        return closestSize;
    }

    public static String getOpenUrlAnnouncement(Context context, String urlTitle) {
        return context.getResources().getString(R.string.open_url_announcement, new Object[]{urlTitle});
    }
}

