/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.input.customcontrols;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.util.TypedValue;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.appcompat.widget.AppCompatAutoCompleteTextView;
import androidx.core.content.ContextCompat;
import io.adaptivecards.R;
import io.adaptivecards.renderer.input.customcontrols.IValidatedInputView;

public class ValidatedAutoCompleteTextView
extends AppCompatAutoCompleteTextView
implements IValidatedInputView {
    private boolean m_isInvalid = false;
    private boolean m_isUsingCustomInputs = false;
    private static final int[] STATE_INPUT_INVALID = new int[]{R.attr.state_error};

    public ValidatedAutoCompleteTextView(Context context) {
        super(context);
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.m_isInvalid = false;
        this.verifyIfUsingCustomInputs(context);
    }

    public ValidatedAutoCompleteTextView(Context context, boolean usingCustomInputs) {
        this(context);
        this.m_isUsingCustomInputs = usingCustomInputs;
        if (this.m_isUsingCustomInputs) {
            this.setBackground(ContextCompat.getDrawable((Context)context, (int)R.drawable.adaptive_choiceset_compact_background));
        }
    }

    public boolean enoughToFilter() {
        return true;
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (focused) {
            this.performFiltering((CharSequence)this.getText(), 0);
        }
    }

    public void verifyIfUsingCustomInputs(Context context) {
        TypedValue isUsingCustomInputs;
        Resources.Theme theme = context.getTheme();
        this.m_isUsingCustomInputs = theme.resolveAttribute(R.attr.adaptiveUsingCustomTextInputs, isUsingCustomInputs = new TypedValue(), true) ? isUsingCustomInputs.data != 0 : false;
    }

    @Override
    public void setValidationResult(boolean isValid) {
        if (this.m_isUsingCustomInputs) {
            this.setInputInvalid(!isValid);
        }
    }

    public void setInputInvalid(boolean isInvalid) {
        this.m_isInvalid = isInvalid;
        this.refreshDrawableState();
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.m_isInvalid) {
            ValidatedAutoCompleteTextView.mergeDrawableStates((int[])drawableState, (int[])STATE_INPUT_INVALID);
        }
        return drawableState;
    }
}

