/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentManager;
import com.google.android.flexbox.FlexboxLayout;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.Column;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.HorizontalAlignment;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.Layout;
import io.adaptivecards.objectmodel.LayoutContainerType;
import io.adaptivecards.renderer.AdaptiveFallbackException;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.readonly.ContainerRenderer;
import io.adaptivecards.renderer.registration.CardRendererRegistration;
import io.adaptivecards.renderer.registration.FeatureFlagResolverUtility;
import java.util.Locale;

public class ColumnRenderer
extends BaseCardElementRenderer {
    private static ColumnRenderer s_instance = null;
    private final String g_columnSizeAuto = "auto";
    private final String g_columnSizeStretch = "stretch";

    protected ColumnRenderer() {
    }

    public static ColumnRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ColumnRenderer();
        }
        return s_instance;
    }

    @Nullable
    static Float getRelativeWidth(Column column) {
        try {
            String columnSize = column.GetWidth().toLowerCase(Locale.getDefault());
            return Float.valueOf(Float.parseFloat(columnSize));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    private ViewGroup setColumnWidth(RenderedAdaptiveCard renderedCard, Context context, Column column, ViewGroup columnLayout) {
        String columnSize = column.GetWidth().toLowerCase(Locale.getDefault());
        long pixelWidth = column.GetPixelWidth();
        Float relativeWidth = ColumnRenderer.getRelativeWidth(column);
        FlexboxLayout.LayoutParams layoutParams = new FlexboxLayout.LayoutParams(0, -1);
        if (pixelWidth != 0L) {
            layoutParams.setFlexGrow(0.0f);
            layoutParams.setFlexShrink(0.0f);
            layoutParams.setWidth(Util.dpToPixels(context, pixelWidth));
        } else if (relativeWidth != null) {
            layoutParams.setFlexGrow(relativeWidth.floatValue());
            layoutParams.setFlexShrink(1.0f);
            layoutParams.setFlexBasisPercent(0.0f);
        } else if (TextUtils.isEmpty((CharSequence)columnSize) || columnSize.equals("stretch")) {
            layoutParams.setFlexGrow(1.0f);
            layoutParams.setFlexShrink(1.0f);
            layoutParams.setFlexBasisPercent(0.0f);
        } else {
            layoutParams.setFlexGrow(0.0f);
            layoutParams.setFlexShrink(1.0f);
            layoutParams.setWidth(-2);
            if (!columnSize.equals("auto")) {
                renderedCard.addWarning(new AdaptiveWarning(7, "Column Width (" + column.GetWidth() + ") is not a valid weight ('auto', 'stretch', <integer>)."));
            }
        }
        columnLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return columnLayout;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) throws Exception {
        boolean isFlowLayout;
        Column column = Util.castTo(baseCardElement, Column.class);
        Layout layoutToApply = Util.getLayoutToApply(column.GetLayouts(), hostConfig);
        ViewGroup columnLayout = ColumnRenderer.getAppropriateContainerForLayout(context, layoutToApply, column);
        View separator = null;
        boolean bl = isFlowLayout = layoutToApply.GetLayoutContainerType() == LayoutContainerType.Flow;
        if (!isFlowLayout) {
            separator = ColumnRenderer.setSpacingAndSeparator(context, viewGroup, column.GetSpacing(), column.GetSeparator(), hostConfig, false);
        }
        ColumnRenderer.setVisibility(baseCardElement.GetIsVisible(), (View)columnLayout);
        this.setColumnWidth(renderedCard, context, column, columnLayout);
        ColumnRenderer.setMinHeight(column.GetMinHeight(), (View)columnLayout, context);
        ContainerStyle containerStyle = renderArgs.getContainerStyle();
        ContainerStyle styleForThis = ContainerRenderer.getLocalContainerStyle(column, containerStyle);
        RenderArgs columnRenderArgs = new RenderArgs(renderArgs);
        columnRenderArgs.setContainerStyle(styleForThis);
        columnRenderArgs.setHorizontalAlignment(HorizontalAlignment.Left);
        columnRenderArgs.setAncestorHasSelectAction(renderArgs.getAncestorHasSelectAction() || column.GetSelectAction() != null);
        if (!column.GetItems().isEmpty()) {
            try {
                CardRendererRegistration.getInstance().renderElements(renderedCard, context, fragmentManager, columnLayout, column.GetItems(), cardActionHandler, hostConfig, columnRenderArgs, layoutToApply);
                if (FeatureFlagResolverUtility.INSTANCE.isItemFitToFillEnabledForColumn()) {
                    ContainerRenderer.applyItemFillForFlowLayout(layoutToApply, columnLayout);
                }
            }
            catch (AdaptiveFallbackException e) {
                if (separator != null) {
                    viewGroup.removeView(separator);
                }
                throw e;
            }
        }
        ContainerRenderer.setBackgroundImage(renderedCard, context, column.GetBackgroundImage(), hostConfig, columnLayout);
        ContainerRenderer.applyVerticalContentAlignment(columnLayout, column.GetVerticalContentAlignment(), layoutToApply);
        ContainerRenderer.applyPadding(styleForThis, renderArgs.getContainerStyle(), columnLayout, hostConfig, column.GetShowBorder());
        ContainerRenderer.applyContainerStyle(styleForThis, renderArgs.getContainerStyle(), columnLayout, hostConfig);
        ContainerRenderer.applyBleed(column, columnLayout, context, hostConfig);
        ContainerRenderer.applyBorder(styleForThis, columnLayout, hostConfig, column.GetElementType(), column.GetShowBorder());
        ContainerRenderer.applyRoundedCorners(columnLayout, hostConfig, column.GetElementType(), column.GetRoundedCorners());
        BaseCardElementRenderer.applyRtl(column.GetRtl(), columnLayout);
        ContainerRenderer.setSelectAction(renderedCard, column.GetSelectAction(), (View)columnLayout, cardActionHandler, renderArgs);
        viewGroup.addView((View)columnLayout);
        return columnLayout;
    }

    private static ViewGroup getAppropriateContainerForLayout(Context context, Layout layoutToApply, Column column) {
        FlexboxLayout layoutContainer;
        if (layoutToApply.GetLayoutContainerType() == LayoutContainerType.Flow) {
            FlexboxLayout flexboxLayout = new FlexboxLayout(context);
            flexboxLayout.setFlexDirection(0);
            flexboxLayout.setFlexWrap(1);
            Util.setHorizontalAlignmentForFlowLayout(flexboxLayout, layoutToApply);
            flexboxLayout.setTag((Object)new TagContent(column));
            layoutContainer = flexboxLayout;
        } else {
            LinearLayout columnLayout = new LinearLayout(context);
            columnLayout.setOrientation(1);
            columnLayout.setTag((Object)new TagContent(column));
            columnLayout.setFocusable(true);
            columnLayout.setFocusableInTouchMode(true);
            layoutContainer = columnLayout;
        }
        return layoutContainer;
    }
}

