/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.fragment.app.FragmentManager;
import io.adaptivecards.R;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.HeightType;
import io.adaptivecards.objectmodel.HorizontalAlignment;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.Icon;
import io.adaptivecards.objectmodel.IconStyle;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.FluentIconImageLoaderAsync;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.readonly.ContainerRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002JJ\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\""}, d2={"Lio/adaptivecards/renderer/readonly/FluentIconsRenderer;", "Lio/adaptivecards/renderer/BaseCardElementRenderer;", "()V", "applyHorizontalAlignment", "", "constraints", "Landroidx/constraintlayout/widget/ConstraintSet;", "id", "", "renderArgs", "Lio/adaptivecards/renderer/RenderArgs;", "createConstraints", "context", "Landroid/content/Context;", "icon", "Lio/adaptivecards/objectmodel/Icon;", "imageView", "Landroid/widget/ImageView;", "createContainer", "Landroidx/constraintlayout/widget/ConstraintLayout;", "render", "Landroid/view/View;", "renderedCard", "Lio/adaptivecards/renderer/RenderedAdaptiveCard;", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "viewGroup", "Landroid/view/ViewGroup;", "baseCardElement", "Lio/adaptivecards/objectmodel/BaseCardElement;", "cardActionHandler", "Lio/adaptivecards/renderer/actionhandler/ICardActionHandler;", "hostConfig", "Lio/adaptivecards/objectmodel/HostConfig;", "adaptivecards_release"})
public final class FluentIconsRenderer
extends BaseCardElementRenderer {
    @NotNull
    public static final FluentIconsRenderer INSTANCE = new FluentIconsRenderer();

    private FluentIconsRenderer() {
    }

    @Override
    @NotNull
    public View render(@NotNull RenderedAdaptiveCard renderedCard, @NotNull Context context, @NotNull FragmentManager fragmentManager, @NotNull ViewGroup viewGroup, @NotNull BaseCardElement baseCardElement, @Nullable ICardActionHandler cardActionHandler, @NotNull HostConfig hostConfig, @NotNull RenderArgs renderArgs) {
        Intrinsics.checkNotNullParameter((Object)renderedCard, (String)"renderedCard");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"viewGroup");
        Intrinsics.checkNotNullParameter((Object)baseCardElement, (String)"baseCardElement");
        Intrinsics.checkNotNullParameter((Object)hostConfig, (String)"hostConfig");
        Intrinsics.checkNotNullParameter((Object)renderArgs, (String)"renderArgs");
        Icon icon = Util.castTo(baseCardElement, Icon.class);
        ImageView view = new ImageView(context);
        String svgURL = icon.GetSVGInfoURL();
        String foregroundColor = hostConfig.GetForegroundColor(ContainerStyle.Default, icon.getForgroundColor(), false);
        boolean isFilledStyle = icon.getIconStyle() == IconStyle.Filled;
        long l = Util.getFluentIconSize(icon.getIconSize());
        Intrinsics.checkNotNullExpressionValue((Object)foregroundColor, (String)"foregroundColor");
        FluentIconImageLoaderAsync fluentIconImageLoaderAsync = new FluentIconImageLoaderAsync(renderedCard, l, foregroundColor, isFilledStyle, (View)view);
        Object[] objectArray = new String[]{svgURL};
        fluentIconImageLoaderAsync.execute(objectArray);
        TagContent tagContent = new TagContent(icon);
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"icon");
        ConstraintLayout container = this.createContainer(context, icon);
        tagContent.SetStretchContainer((View)container);
        container.addView((View)view);
        this.createConstraints(context, icon, view, renderArgs).applyTo(container);
        viewGroup.addView((View)container);
        view.setTag((Object)tagContent);
        ContainerRenderer.setSelectAction(renderedCard, icon.GetSelectAction(), (View)view, cardActionHandler, renderArgs);
        BaseCardElementRenderer.setVisibility(baseCardElement.GetIsVisible(), (View)view);
        return (View)view;
    }

    private final ConstraintLayout createContainer(Context context, Icon icon) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.image_constraint_layout, null);
        if (view == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout");
        }
        ConstraintLayout container = (ConstraintLayout)view;
        if (icon.GetHeight() == HeightType.Stretch) {
            container.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        } else {
            container.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        }
        return container;
    }

    private final ConstraintSet createConstraints(Context context, Icon icon, ImageView imageView, RenderArgs renderArgs) {
        ConstraintSet constraints = new ConstraintSet();
        if (imageView.getId() == -1) {
            imageView.setId(View.generateViewId());
        }
        int id2 = imageView.getId();
        constraints.clone(context, R.layout.image_constraint_layout);
        constraints.constrainWidth(id2, 0);
        constraints.constrainDefaultWidth(id2, 1);
        constraints.connect(id2, 6, R.id.leftBarrier, 6);
        constraints.connect(id2, 7, R.id.rightBarrier, 7);
        imageView.setAdjustViewBounds(true);
        imageView.setScaleType(ImageView.ScaleType.FIT_START);
        constraints.constrainHeight(id2, -2);
        constraints.connect(id2, 3, 0, 3);
        this.applyHorizontalAlignment(constraints, id2, renderArgs);
        this.applyHorizontalAlignment(constraints, R.id.widthPlaceholder, renderArgs);
        constraints.constrainWidth(R.id.widthPlaceholder, Util.dpToPixels(context, Util.getFluentIconSize(icon.getIconSize())));
        return constraints;
    }

    private final void applyHorizontalAlignment(ConstraintSet constraints, int id2, RenderArgs renderArgs) {
        HorizontalAlignment horizontalAlignment = HorizontalAlignment.Left;
        if (renderArgs.getHorizontalAlignment() != null) {
            HorizontalAlignment horizontalAlignment2 = renderArgs.getHorizontalAlignment();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)horizontalAlignment2), (String)"renderArgs.horizontalAlignment");
            horizontalAlignment = horizontalAlignment2;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[horizontalAlignment.ordinal()]) {
            case 1: {
                constraints.setHorizontalBias(id2, 0.5f);
                break;
            }
            case 2: {
                constraints.setHorizontalBias(id2, 1.0f);
                break;
            }
            case 3: {
                constraints.setHorizontalBias(id2, 0.0f);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HorizontalAlignment.values().length];
            nArray[HorizontalAlignment.Center.ordinal()] = 1;
            nArray[HorizontalAlignment.Right.ordinal()] = 2;
            nArray[HorizontalAlignment.Left.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

