/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import io.adaptivecards.objectmodel.AreaGridLayout;
import io.adaptivecards.objectmodel.GridArea;
import io.adaptivecards.objectmodel.GridAreaVector;
import io.adaptivecards.objectmodel.StringVector;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\n\u0010\f\u001a\u00020\r*\u00020\bJ\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0004J\n\u0010\u0010\u001a\u00020\n*\u00020\bJ\n\u0010\u0011\u001a\u00020\n*\u00020\bJ\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0004J\n\u0010\u0014\u001a\u00020\u0013*\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/adaptivecards/renderer/AreaGridUtil;", "", "()V", "DEFAULT_COLUMN_WIDTH", "", "PIXEL_SUFFIX", "getAreaAt", "Lio/adaptivecards/objectmodel/GridArea;", "Lio/adaptivecards/objectmodel/AreaGridLayout;", "row", "", "column", "getColumnsVectorWithAutoFill", "Lio/adaptivecards/objectmodel/StringVector;", "getFixedWidth", "", "getMaxColumnsCountFromAreas", "getMaxRowsCountFromAreas", "isAuto", "", "isFixedWidth", "adaptivecards_release"})
public final class AreaGridUtil {
    @NotNull
    public static final AreaGridUtil INSTANCE = new AreaGridUtil();
    @NotNull
    private static final String PIXEL_SUFFIX = "px";
    @NotNull
    public static final String DEFAULT_COLUMN_WIDTH = "auto";

    private AreaGridUtil() {
    }

    @Nullable
    public final GridArea getAreaAt(@NotNull AreaGridLayout $this$getAreaAt, int row, int column) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$getAreaAt, (String)"<this>");
            GridAreaVector gridAreaVector = $this$getAreaAt.GetAreas();
            Intrinsics.checkNotNullExpressionValue((Object)gridAreaVector, (String)"this.GetAreas()");
            List $this$lastOrNull$iv = gridAreaVector;
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                GridArea it = (GridArea)element$iv;
                boolean bl = false;
                if (!(it.GetRow() - 1 == row && it.GetColumn() - 1 == column)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @NotNull
    public final StringVector getColumnsVectorWithAutoFill(@NotNull AreaGridLayout $this$getColumnsVectorWithAutoFill) {
        Intrinsics.checkNotNullParameter((Object)$this$getColumnsVectorWithAutoFill, (String)"<this>");
        int columnCount = this.getMaxColumnsCountFromAreas($this$getColumnsVectorWithAutoFill);
        StringVector columns = new StringVector();
        if ($this$getColumnsVectorWithAutoFill.GetColumns() != null) {
            columns.addAll($this$getColumnsVectorWithAutoFill.GetColumns());
        }
        int remainingColumns = columnCount - columns.size();
        for (int i = 0; i < remainingColumns; ++i) {
            columns.add(DEFAULT_COLUMN_WIDTH);
        }
        return columns;
    }

    public final int getMaxRowsCountFromAreas(@NotNull AreaGridLayout $this$getMaxRowsCountFromAreas) {
        Intrinsics.checkNotNullParameter((Object)$this$getMaxRowsCountFromAreas, (String)"<this>");
        int rowCount = 0;
        for (GridArea area : $this$getMaxRowsCountFromAreas.GetAreas()) {
            rowCount = area.GetRow() > rowCount ? area.GetRow() : rowCount;
        }
        return rowCount;
    }

    public final int getMaxColumnsCountFromAreas(@NotNull AreaGridLayout $this$getMaxColumnsCountFromAreas) {
        Intrinsics.checkNotNullParameter((Object)$this$getMaxColumnsCountFromAreas, (String)"<this>");
        int columnCount = 0;
        for (GridArea area : $this$getMaxColumnsCountFromAreas.GetAreas()) {
            columnCount = area.GetColumn() > columnCount ? area.GetColumn() : columnCount;
        }
        return columnCount;
    }

    public final boolean isFixedWidth(@NotNull String $this$isFixedWidth) {
        Intrinsics.checkNotNullParameter((Object)$this$isFixedWidth, (String)"<this>");
        return StringsKt.endsWith$default((String)$this$isFixedWidth, (String)PIXEL_SUFFIX, (boolean)false, (int)2, null);
    }

    public final float getFixedWidth(@NotNull String $this$getFixedWidth) {
        float f;
        Intrinsics.checkNotNullParameter((Object)$this$getFixedWidth, (String)"<this>");
        if (this.isFixedWidth($this$getFixedWidth)) {
            String string2 = $this$getFixedWidth.substring(0, $this$getFixedWidth.length() - PIXEL_SUFFIX.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            f = Float.parseFloat(string2);
        } else {
            f = 0.0f;
        }
        return f;
    }

    public final boolean isAuto(@NotNull String $this$isAuto) {
        Intrinsics.checkNotNullParameter((Object)$this$isAuto, (String)"<this>");
        return $this$isAuto.equals(DEFAULT_COLUMN_WIDTH);
    }
}

