/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.inputhandler;

import android.view.View;
import io.adaptivecards.objectmodel.BaseInputElement;
import io.adaptivecards.objectmodel.RatingInput;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.inputhandler.BaseInputHandler;
import io.adaptivecards.renderer.layout.RatingStarInputView;
import io.adaptivecards.renderer.layout.RatingStarInputViewListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\nH\u0016\u00a8\u0006\u0014"}, d2={"Lio/adaptivecards/renderer/inputhandler/RatingInputHandler;", "Lio/adaptivecards/renderer/inputhandler/BaseInputHandler;", "baseInputElement", "Lio/adaptivecards/objectmodel/BaseInputElement;", "renderedAdaptiveCard", "Lio/adaptivecards/renderer/RenderedAdaptiveCard;", "cardId", "", "(Lio/adaptivecards/objectmodel/BaseInputElement;Lio/adaptivecards/renderer/RenderedAdaptiveCard;J)V", "getDefaultValue", "", "getInput", "isValid", "", "showError", "registerInputObserver", "", "setFocusToView", "setInput", "input", "adaptivecards_release"})
public final class RatingInputHandler
extends BaseInputHandler {
    public RatingInputHandler(@NotNull BaseInputElement baseInputElement, @Nullable RenderedAdaptiveCard renderedAdaptiveCard, long cardId) {
        Intrinsics.checkNotNullParameter((Object)baseInputElement, (String)"baseInputElement");
        super(baseInputElement, renderedAdaptiveCard, cardId);
    }

    @Override
    @NotNull
    public String getInput() {
        View view = this.m_view;
        if (view == null) {
            throw new NullPointerException("null cannot be cast to non-null type io.adaptivecards.renderer.layout.RatingStarInputView");
        }
        return String.valueOf(((RatingStarInputView)view).getRating());
    }

    @Override
    public void setInput(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        try {
            View view = this.m_view;
            if (view == null) {
                throw new NullPointerException("null cannot be cast to non-null type io.adaptivecards.renderer.layout.RatingStarInputView");
            }
            ((RatingStarInputView)view).setRating(Double.parseDouble(input));
        }
        catch (NumberFormatException e) {
            return;
        }
    }

    @Override
    public void setFocusToView() {
        View view = this.m_view;
        if (view == null) {
            throw new NullPointerException("null cannot be cast to non-null type io.adaptivecards.renderer.layout.RatingStarInputView");
        }
        View focusView = ((RatingStarInputView)view).getChildAt(0);
        Util.forceFocus(focusView);
        focusView.sendAccessibilityEvent(32768);
    }

    @Override
    public boolean isValid(boolean showError) {
        boolean isValid = true;
        if (this.m_baseInputElement.GetIsRequired()) {
            boolean bl;
            try {
                bl = Double.parseDouble(this.getInput()) > 0.0;
            }
            catch (NumberFormatException e) {
                bl = false;
            }
            isValid = bl;
        }
        boolean bl = isValid = isValid && this.isValidOnSpecifics(this.getInput());
        if (showError) {
            this.showValidationErrors(isValid);
        }
        return isValid;
    }

    @Override
    @NotNull
    public String getDefaultValue() {
        if (Util.isOfType(this.m_baseInputElement, RatingInput.class)) {
            RatingInput ratingInput = Util.castTo(this.m_baseInputElement, RatingInput.class);
            return String.valueOf(ratingInput.GetValue());
        }
        String string2 = super.getDefaultValue();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"super.getDefaultValue()");
        return string2;
    }

    @Override
    public void registerInputObserver() {
        View view = this.m_view;
        if (view == null) {
            throw new NullPointerException("null cannot be cast to non-null type io.adaptivecards.renderer.layout.RatingStarInputView");
        }
        ((RatingStarInputView)view).setRatingStarInputViewListener(new RatingStarInputViewListener(this){
            final /* synthetic */ RatingInputHandler this$0;
            {
                this.this$0 = $receiver;
            }

            public void onRatingChanged() {
                this.this$0.notifyAllInputWatchers();
            }
        });
        this.addValueChangedActionInputWatcher();
    }
}

