/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.inputhandler;

import android.text.Editable;
import android.text.TextWatcher;
import android.widget.EditText;
import io.adaptivecards.objectmodel.BaseInputElement;
import io.adaptivecards.objectmodel.TextInput;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.AfterTextChangedListener;
import io.adaptivecards.renderer.inputhandler.BaseInputHandler;
import java.util.regex.Pattern;

public class TextInputHandler
extends BaseInputHandler {
    public TextInputHandler(BaseInputElement baseInputElement, RenderedAdaptiveCard renderedAdaptiveCard, Long cardId) {
        super(baseInputElement, renderedAdaptiveCard, cardId);
    }

    protected EditText getEditText() {
        return (EditText)this.m_view;
    }

    @Override
    public void setInput(String text) {
        this.getEditText().setText((CharSequence)text);
    }

    @Override
    public String getInput() {
        return this.getEditText().getText().toString();
    }

    @Override
    public boolean isValidOnSpecifics(String textInputValue) {
        long maxLength;
        TextInput textInput = Util.tryCastTo(this.m_baseInputElement, TextInput.class);
        if (textInput == null) {
            return false;
        }
        if (!textInput.GetIsRequired() && textInputValue.isEmpty()) {
            return true;
        }
        boolean isValid = true;
        String regex = textInput.GetRegex();
        if (!regex.isEmpty()) {
            isValid = Pattern.matches(regex, textInputValue);
        }
        if ((maxLength = textInput.GetMaxLength()) != 0L) {
            isValid &= (long)textInputValue.length() <= maxLength;
        }
        return isValid;
    }

    @Override
    public void registerInputObserver() {
        this.getEditText().addTextChangedListener((TextWatcher)new AfterTextChangedListener(){

            public void afterTextChanged(Editable editable) {
                TextInputHandler.this.notifyAllInputWatchers();
            }
        });
        this.addValueChangedActionInputWatcher();
    }

    @Override
    public String getDefaultValue() {
        if (Util.isOfType(this.m_baseInputElement, TextInput.class)) {
            return Util.castTo(this.m_baseInputElement, TextInput.class).GetValue();
        }
        return super.getDefaultValue();
    }

    @Override
    public void setFocusToView() {
        Util.forceFocus(this.m_view);
        this.m_view.sendAccessibilityEvent(32768);
    }
}

