/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.layout;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.flexbox.FlexboxLayout;
import io.adaptivecards.objectmodel.AreaGridLayout;
import io.adaptivecards.objectmodel.GridArea;
import io.adaptivecards.objectmodel.StringVector;
import io.adaptivecards.renderer.AreaGridUtil;
import io.adaptivecards.renderer.Util;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006J(\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010 \u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cJ\u001c\u0010!\u001a\u00020\u0012*\u00020\"2\u0006\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006&"}, d2={"Lio/adaptivecards/renderer/layout/AreaGridLayoutView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "areaGridAlignContent", "", "getAreaGridAlignContent", "()I", "setAreaGridAlignContent", "(I)V", "flexboxLayout", "Lcom/google/android/flexbox/FlexboxLayout;", "getFlexboxLayout", "()Lcom/google/android/flexbox/FlexboxLayout;", "setFlexboxLayout", "(Lcom/google/android/flexbox/FlexboxLayout;)V", "addAreaView", "", "view", "Landroid/view/View;", "areaName", "", "rowSpacing", "columnSpacing", "addColumns", "row", "layout", "Lio/adaptivecards/objectmodel/AreaGridLayout;", "columnVector", "Lio/adaptivecards/objectmodel/StringVector;", "addViewAtTheEnd", "setUpAreaGrids", "adjustWidthFromColumnVector", "Lcom/google/android/flexbox/FlexboxLayout$LayoutParams;", "columnValue", "columnSpan", "", "adaptivecards_release"})
public final class AreaGridLayoutView
extends FrameLayout {
    private int areaGridAlignContent;
    public FlexboxLayout flexboxLayout;

    public AreaGridLayoutView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    public final int getAreaGridAlignContent() {
        return this.areaGridAlignContent;
    }

    public final void setAreaGridAlignContent(int n) {
        this.areaGridAlignContent = n;
    }

    @NotNull
    public final FlexboxLayout getFlexboxLayout() {
        FlexboxLayout flexboxLayout = this.flexboxLayout;
        if (flexboxLayout != null) {
            return flexboxLayout;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"flexboxLayout");
        return null;
    }

    public final void setFlexboxLayout(@NotNull FlexboxLayout flexboxLayout) {
        Intrinsics.checkNotNullParameter((Object)flexboxLayout, (String)"<set-?>");
        this.flexboxLayout = flexboxLayout;
    }

    /*
     * WARNING - void declaration
     */
    public final void setUpAreaGrids(@NotNull AreaGridLayout layout) {
        void $this$setUpAreaGrids_u24lambda_u2d0;
        FlexboxLayout flexboxLayout;
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        FlexboxLayout flexboxLayout2 = flexboxLayout = new FlexboxLayout(this.getContext());
        AreaGridLayoutView areaGridLayoutView = this;
        boolean bl = false;
        $this$setUpAreaGrids_u24lambda_u2d0.setFlexDirection(0);
        $this$setUpAreaGrids_u24lambda_u2d0.setFlexWrap(1);
        $this$setUpAreaGrids_u24lambda_u2d0.setAlignContent(this.areaGridAlignContent);
        $this$setUpAreaGrids_u24lambda_u2d0.setLayoutParams((ViewGroup.LayoutParams)new FlexboxLayout.LayoutParams(-1, -2));
        areaGridLayoutView.setFlexboxLayout(flexboxLayout);
        int rowCount = AreaGridUtil.INSTANCE.getMaxRowsCountFromAreas(layout);
        StringVector columnsVector = AreaGridUtil.INSTANCE.getColumnsVectorWithAutoFill(layout);
        for (int row = 0; row < rowCount; ++row) {
            this.addColumns(row, this.getFlexboxLayout(), layout, columnsVector);
        }
        this.addView((View)this.getFlexboxLayout());
    }

    private final void addColumns(int row, FlexboxLayout flexboxLayout, AreaGridLayout layout, StringVector columnVector) {
        int columnCount = columnVector.size();
        boolean isNewRow = false;
        isNewRow = true;
        int nextSkipColumnCount = 0;
        for (int column = 0; column < columnCount; ++column) {
            FrameLayout frameLayout = new FrameLayout(this.getContext());
            frameLayout.setId(column);
            flexboxLayout.addView((View)frameLayout);
            FlexboxLayout.LayoutParams params = new FlexboxLayout.LayoutParams(-2, -2);
            if (AreaGridUtil.INSTANCE.getAreaAt(layout, row, column) != null) {
                FlexboxLayout.LayoutParams layoutParams;
                GridArea area;
                boolean bl = false;
                String areaName = area.GetName();
                frameLayout.setTag((Object)areaName);
                FlexboxLayout.LayoutParams $this$addColumns_u24lambda_u2d2_u24lambda_u2d1 = layoutParams = params;
                boolean bl2 = false;
                $this$addColumns_u24lambda_u2d2_u24lambda_u2d1.setWrapBefore(isNewRow);
                isNewRow = false;
                String string2 = columnVector.get(column);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"columnVector[column]");
                this.adjustWidthFromColumnVector(params, string2, area.GetColumnSpan());
                nextSkipColumnCount = area.GetColumnSpan() - 1;
            } else {
                AreaGridLayoutView $this$addColumns_u24lambda_u2d3 = this;
                boolean bl = false;
                frameLayout.setTag((Object)("r_" + row + " c_" + column));
                if (nextSkipColumnCount == 0) {
                    String string3 = columnVector.get(column);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"columnVector[column]");
                    $this$addColumns_u24lambda_u2d3.adjustWidthFromColumnVector(params, string3, 1.0f);
                } else {
                    params.width = 0;
                    int n = nextSkipColumnCount;
                    nextSkipColumnCount = n + -1;
                }
            }
            frameLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    private final void adjustWidthFromColumnVector(FlexboxLayout.LayoutParams $this$adjustWidthFromColumnVector, String columnValue, float columnSpan) {
        block1: {
            block2: {
                block0: {
                    CharSequence $this$isDigitsOnly$iv = columnValue;
                    boolean $i$f$isDigitsOnly = false;
                    if (!TextUtils.isDigitsOnly((CharSequence)$this$isDigitsOnly$iv)) break block0;
                    $this$adjustWidthFromColumnVector.width = 0;
                    $this$adjustWidthFromColumnVector.setFlexBasisPercent(Float.parseFloat(columnValue) / 100.0f);
                    break block1;
                }
                if (!AreaGridUtil.INSTANCE.isFixedWidth(columnValue)) break block2;
                $this$adjustWidthFromColumnVector.width = Util.dpToPixels(this.getFlexboxLayout().getContext(), AreaGridUtil.INSTANCE.getFixedWidth(columnValue));
                break block1;
            }
            if (!AreaGridUtil.INSTANCE.isAuto(columnValue)) break block1;
            $this$adjustWidthFromColumnVector.width = 0;
            $this$adjustWidthFromColumnVector.setFlexGrow(columnSpan);
        }
    }

    private final void addViewAtTheEnd(View view) {
        FlexboxLayout.LayoutParams param;
        FlexboxLayout.LayoutParams layoutParams;
        FlexboxLayout flexboxLayout = this.getFlexboxLayout();
        if (flexboxLayout != null) {
            flexboxLayout.addView(view);
        }
        FlexboxLayout.LayoutParams $this$addViewAtTheEnd_u24lambda_u2d4 = layoutParams = (param = new FlexboxLayout.LayoutParams(-2, -2));
        boolean bl = false;
        $this$addViewAtTheEnd_u24lambda_u2d4.width = 0;
        $this$addViewAtTheEnd_u24lambda_u2d4.setFlexGrow(1.0f);
        view.setLayoutParams((ViewGroup.LayoutParams)param);
    }

    public final void addAreaView(@NotNull View view, @Nullable String areaName, int rowSpacing, int columnSpacing) {
        block2: {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            FrameLayout frameLayout = (FrameLayout)this.findViewWithTag(areaName);
            if (frameLayout != null) {
                FrameLayout areaFrame = frameLayout;
                boolean bl = false;
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
                layoutParams.setMargins(rowSpacing, columnSpacing, rowSpacing, columnSpacing);
                view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                areaFrame.addView(view);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block2;
            AreaGridLayoutView $this$addAreaView_u24lambda_u2d6 = this;
            boolean bl = false;
            $this$addAreaView_u24lambda_u2d6.addViewAtTheEnd(view);
        }
    }
}

