/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.Button;
import com.caverock.androidsvg.SVG;
import io.adaptivecards.objectmodel.IconPlacement;
import io.adaptivecards.renderer.FluentIconImageLoaderAsync;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0005\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0010J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000bH\u0016J\u001a\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u0007H\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lio/adaptivecards/renderer/ActionElementRendererFluentIconImageLoaderAsync;", "Lio/adaptivecards/renderer/FluentIconImageLoaderAsync;", "renderedCard", "Lio/adaptivecards/renderer/RenderedAdaptiveCard;", "targetIconSize", "", "isFilledStyle", "", "view", "Landroid/view/View;", "iconColor", "", "iconPlacement", "Lio/adaptivecards/objectmodel/IconPlacement;", "padding", "iconSizeFromConfig", "(Lio/adaptivecards/renderer/RenderedAdaptiveCard;JZLandroid/view/View;Ljava/lang/String;Lio/adaptivecards/objectmodel/IconPlacement;JJ)V", "getIconPlacement", "()Lio/adaptivecards/objectmodel/IconPlacement;", "getPadding", "()J", "flipDrawableHorizontally", "Landroid/graphics/drawable/Drawable;", "drawable", "flipInRtl", "parseSvgString", "Lcom/caverock/androidsvg/SVG;", "context", "Landroid/content/Context;", "svgString", "renderFluentIcon", "", "adaptivecards_release"})
public final class ActionElementRendererFluentIconImageLoaderAsync
extends FluentIconImageLoaderAsync {
    @NotNull
    private final IconPlacement iconPlacement;
    private final long padding;
    private final long iconSizeFromConfig;

    public ActionElementRendererFluentIconImageLoaderAsync(@NotNull RenderedAdaptiveCard renderedCard, long targetIconSize, boolean isFilledStyle, @NotNull View view, @NotNull String iconColor, @NotNull IconPlacement iconPlacement, long padding, long iconSizeFromConfig) {
        Intrinsics.checkNotNullParameter((Object)renderedCard, (String)"renderedCard");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)iconColor, (String)"iconColor");
        Intrinsics.checkNotNullParameter((Object)((Object)iconPlacement), (String)"iconPlacement");
        super(renderedCard, targetIconSize, iconColor, isFilledStyle, view);
        this.iconPlacement = iconPlacement;
        this.padding = padding;
        this.iconSizeFromConfig = iconSizeFromConfig;
    }

    @NotNull
    public final IconPlacement getIconPlacement() {
        return this.iconPlacement;
    }

    public final long getPadding() {
        return this.padding;
    }

    @Override
    public void renderFluentIcon(@Nullable Drawable drawable, boolean flipInRtl) {
        block3: {
            View view = (View)this.getViewReference().get();
            if (view == null || !(view instanceof Button)) break block3;
            Drawable[] drawableArray = ((Button)view).getCompoundDrawablesRelative();
            Intrinsics.checkNotNullExpressionValue((Object)drawableArray, (String)"view.compoundDrawablesRelative");
            Drawable[] drawables = drawableArray;
            Drawable drawable2 = drawable;
            if (drawable2 != null) {
                Drawable it = drawable2;
                boolean bl = false;
                Drawable flippedDrawable = this.flipDrawableHorizontally(it, view, flipInRtl);
                if (this.iconPlacement == IconPlacement.AboveTitle) {
                    drawables[1] = flippedDrawable;
                } else {
                    drawables[0] = flippedDrawable;
                    ((Button)view).setCompoundDrawablePadding(Util.dpToPixels(((Button)view).getContext(), this.padding));
                }
                ((Button)view).setCompoundDrawablesRelativeWithIntrinsicBounds(drawables[0], drawables[1], drawables[2], drawables[3]);
            }
        }
    }

    @Override
    @NotNull
    public SVG parseSvgString(@NotNull Context context, @NotNull String svgString) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)svgString, (String)"svgString");
        SVG svg = SVG.getFromString((String)svgString);
        svg.setDocumentWidth((float)Util.dpToPixels(context, this.iconSizeFromConfig));
        svg.setDocumentHeight((float)Util.dpToPixels(context, this.iconSizeFromConfig));
        Intrinsics.checkNotNullExpressionValue((Object)svg, (String)"svg");
        return svg;
    }

    private final Drawable flipDrawableHorizontally(Drawable drawable, View view, boolean flipInRtl) {
        Drawable drawable2;
        if (Intrinsics.areEqual((Object)this.getRenderedCard().getAdaptiveCard().GetRtl(), (Object)flipInRtl)) {
            Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            Matrix matrix = new Matrix();
            matrix.preScale(-1.0f, 1.0f);
            Bitmap flippedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            drawable2 = (Drawable)new BitmapDrawable(view.getResources(), flippedBitmap);
        } else {
            drawable2 = drawable;
        }
        return drawable2;
    }
}

