/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.inputhandler;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.adaptivecards.objectmodel.BaseInputElement;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.inputhandler.IInputHandler;
import io.adaptivecards.renderer.inputhandler.IInputWatcher;
import io.adaptivecards.renderer.inputhandler.ValueChangedActionInputWatcher;
import io.adaptivecards.renderer.layout.StretchableInputLayout;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseInputHandler
implements IInputHandler {
    protected BaseInputElement m_baseInputElement;
    protected View m_view = null;
    private StretchableInputLayout m_inputLayout = null;
    List<IInputWatcher> m_inputWatchers;
    @Nullable
    private RenderedAdaptiveCard m_renderedAdaptiveCard;
    private Long m_cardId;

    public BaseInputHandler(BaseInputElement baseInputElement) {
        this.m_baseInputElement = baseInputElement;
        this.m_inputWatchers = new ArrayList<IInputWatcher>();
    }

    public BaseInputHandler(@NonNull BaseInputElement baseInputElement, @Nullable RenderedAdaptiveCard renderedAdaptiveCard, long cardId) {
        this(baseInputElement);
        this.m_renderedAdaptiveCard = renderedAdaptiveCard;
        this.m_cardId = cardId;
    }

    public void setView(View view) {
        this.m_view = view;
    }

    public BaseInputElement getBaseInputElement() {
        return this.m_baseInputElement;
    }

    @Override
    public String getId() {
        return this.m_baseInputElement.GetId();
    }

    public void setInputLayout(StretchableInputLayout inputLayout) {
        this.m_inputLayout = inputLayout;
    }

    @Override
    public boolean isValid() {
        return this.isValid(true);
    }

    @Override
    public boolean isValid(boolean showError) {
        boolean isValid = true;
        String inputValue = this.getInput();
        if (this.m_baseInputElement.GetIsRequired()) {
            isValid = !inputValue.isEmpty();
        }
        boolean bl = isValid = isValid && this.isValidOnSpecifics(inputValue);
        if (showError) {
            this.showValidationErrors(isValid);
        }
        return isValid;
    }

    @Override
    public boolean isRequiredInput() {
        return this.m_baseInputElement.GetIsRequired();
    }

    public boolean isValidOnSpecifics(String inputValue) {
        return true;
    }

    public void showValidationErrors(boolean isValid) {
        if (this.m_inputLayout != null) {
            this.m_inputLayout.setValidationResult(isValid);
        }
    }

    @Override
    public void addInputWatcher(IInputWatcher observer) {
        this.m_inputWatchers.add(observer);
    }

    protected void addValueChangedActionInputWatcher() {
        if (this.m_baseInputElement.GetValueChangedAction() != null && this.m_renderedAdaptiveCard != null) {
            this.addInputWatcher(new ValueChangedActionInputWatcher(this.m_baseInputElement.GetValueChangedAction(), this.m_renderedAdaptiveCard, this.m_cardId));
        }
    }

    @Override
    public void registerInputObserver() {
    }

    @Override
    public String getDefaultValue() {
        return "";
    }

    protected void notifyAllInputWatchers() {
        for (IInputWatcher watcher : this.m_inputWatchers) {
            watcher.onInputChange(this.getId(), this.getInput());
        }
    }
}

