/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.layout.carousel;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.fragment.app.FragmentManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.flexbox.FlexboxLayout;
import io.adaptivecards.R;
import io.adaptivecards.objectmodel.CarouselPage;
import io.adaptivecards.objectmodel.CarouselPageVector;
import io.adaptivecards.objectmodel.FeatureRegistration;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.registration.CardRendererRegistration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001&B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u001dH\u0016J\u0018\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001dH\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006'"}, d2={"Lio/adaptivecards/renderer/layout/carousel/CarouselPageAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lio/adaptivecards/renderer/layout/carousel/CarouselPageAdapter$CarouselPageHolder;", "pages", "Lio/adaptivecards/objectmodel/CarouselPageVector;", "renderedCard", "Lio/adaptivecards/renderer/RenderedAdaptiveCard;", "cardActionHandler", "Lio/adaptivecards/renderer/actionhandler/ICardActionHandler;", "hostConfig", "Lio/adaptivecards/objectmodel/HostConfig;", "renderArgs", "Lio/adaptivecards/renderer/RenderArgs;", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "(Lio/adaptivecards/objectmodel/CarouselPageVector;Lio/adaptivecards/renderer/RenderedAdaptiveCard;Lio/adaptivecards/renderer/actionhandler/ICardActionHandler;Lio/adaptivecards/objectmodel/HostConfig;Lio/adaptivecards/renderer/RenderArgs;Landroidx/fragment/app/FragmentManager;)V", "getCardActionHandler", "()Lio/adaptivecards/renderer/actionhandler/ICardActionHandler;", "getFragmentManager", "()Landroidx/fragment/app/FragmentManager;", "getHostConfig", "()Lio/adaptivecards/objectmodel/HostConfig;", "getPages", "()Lio/adaptivecards/objectmodel/CarouselPageVector;", "getRenderArgs", "()Lio/adaptivecards/renderer/RenderArgs;", "getRenderedCard", "()Lio/adaptivecards/renderer/RenderedAdaptiveCard;", "getItemCount", "", "onBindViewHolder", "", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "CarouselPageHolder", "adaptivecards_release"})
public final class CarouselPageAdapter
extends RecyclerView.Adapter<CarouselPageHolder> {
    @NotNull
    private final CarouselPageVector pages;
    @NotNull
    private final RenderedAdaptiveCard renderedCard;
    @Nullable
    private final ICardActionHandler cardActionHandler;
    @NotNull
    private final HostConfig hostConfig;
    @NotNull
    private final RenderArgs renderArgs;
    @NotNull
    private final FragmentManager fragmentManager;

    public CarouselPageAdapter(@NotNull CarouselPageVector pages, @NotNull RenderedAdaptiveCard renderedCard, @Nullable ICardActionHandler cardActionHandler, @NotNull HostConfig hostConfig, @NotNull RenderArgs renderArgs, @NotNull FragmentManager fragmentManager) {
        Intrinsics.checkNotNullParameter((Object)pages, (String)"pages");
        Intrinsics.checkNotNullParameter((Object)renderedCard, (String)"renderedCard");
        Intrinsics.checkNotNullParameter((Object)hostConfig, (String)"hostConfig");
        Intrinsics.checkNotNullParameter((Object)renderArgs, (String)"renderArgs");
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        this.pages = pages;
        this.renderedCard = renderedCard;
        this.cardActionHandler = cardActionHandler;
        this.hostConfig = hostConfig;
        this.renderArgs = renderArgs;
        this.fragmentManager = fragmentManager;
    }

    @NotNull
    public final CarouselPageVector getPages() {
        return this.pages;
    }

    @NotNull
    public final RenderedAdaptiveCard getRenderedCard() {
        return this.renderedCard;
    }

    @Nullable
    public final ICardActionHandler getCardActionHandler() {
        return this.cardActionHandler;
    }

    @NotNull
    public final HostConfig getHostConfig() {
        return this.hostConfig;
    }

    @NotNull
    public final RenderArgs getRenderArgs() {
        return this.renderArgs;
    }

    @NotNull
    public final FragmentManager getFragmentManager() {
        return this.fragmentManager;
    }

    public int getItemCount() {
        return this.pages.size();
    }

    @NotNull
    public CarouselPageHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.carousel_item_viewpager, parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
        return new CarouselPageHolder(view);
    }

    public void onBindViewHolder(@NotNull CarouselPageHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        CarouselPage carouselPage = this.pages.get(position);
        Intrinsics.checkNotNullExpressionValue((Object)carouselPage, (String)"pages[position]");
        holder.bind(carouselPage, this.renderedCard, this.cardActionHandler, this.hostConfig, this.renderArgs, this.fragmentManager);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J8\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lio/adaptivecards/renderer/layout/carousel/CarouselPageAdapter$CarouselPageHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "bind", "", "page", "Lio/adaptivecards/objectmodel/CarouselPage;", "renderedCard", "Lio/adaptivecards/renderer/RenderedAdaptiveCard;", "cardActionHandler", "Lio/adaptivecards/renderer/actionhandler/ICardActionHandler;", "hostConfig", "Lio/adaptivecards/objectmodel/HostConfig;", "renderArgs", "Lio/adaptivecards/renderer/RenderArgs;", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "adaptivecards_release"})
    public static final class CarouselPageHolder
    extends RecyclerView.ViewHolder {
        public CarouselPageHolder(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            super(view);
        }

        public final void bind(@NotNull CarouselPage page, @NotNull RenderedAdaptiveCard renderedCard, @Nullable ICardActionHandler cardActionHandler, @NotNull HostConfig hostConfig, @NotNull RenderArgs renderArgs, @NotNull FragmentManager fragmentManager) {
            View childView;
            Intrinsics.checkNotNullParameter((Object)page, (String)"page");
            Intrinsics.checkNotNullParameter((Object)renderedCard, (String)"renderedCard");
            Intrinsics.checkNotNullParameter((Object)hostConfig, (String)"hostConfig");
            Intrinsics.checkNotNullParameter((Object)renderArgs, (String)"renderArgs");
            Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
            FeatureRegistration featureRegistration = CardRendererRegistration.getInstance().getFeatureRegistration();
            ViewGroup root = (ViewGroup)this.itemView;
            root.removeAllViews();
            CardRendererRegistration.getInstance().renderElementAndPerformFallback(renderedCard, root.getContext(), fragmentManager, page, root, cardActionHandler, hostConfig, renderArgs, featureRegistration);
            View view = childView = root.getChildAt(0);
            if (view != null) {
                view.setLayoutParams((ViewGroup.LayoutParams)new FlexboxLayout.LayoutParams(-1, -1));
            }
        }
    }
}

