/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.graphics.Typeface;
import android.os.Build;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.URLSpan;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityManager;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.fragment.app.FragmentManager;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.FontType;
import io.adaptivecards.objectmodel.ForegroundColor;
import io.adaptivecards.objectmodel.HorizontalAlignment;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.TextBlock;
import io.adaptivecards.objectmodel.TextSize;
import io.adaptivecards.objectmodel.TextStyle;
import io.adaptivecards.objectmodel.TextWeight;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.readonly.DateTimeParser;
import io.adaptivecards.renderer.readonly.RendererUtil;
import io.adaptivecards.renderer.readonly.TextRendererUtil;
import java.util.HashMap;
import java.util.List;

public class TextBlockRenderer
extends BaseCardElementRenderer {
    private static TextBlockRenderer s_instance = null;
    private HashMap<TextWeight, Integer> m_textWeightMap = new HashMap();
    private final int g_textWeightDefault = 0;
    private final int g_textWeightBolder = 1;
    private final int g_textWeightLighter = 2;

    protected TextBlockRenderer() {
        this.m_textWeightMap.put(TextWeight.Default, 0);
        this.m_textWeightMap.put(TextWeight.Bolder, 1);
        this.m_textWeightMap.put(TextWeight.Lighter, 2);
    }

    public static TextBlockRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new TextBlockRenderer();
        }
        return s_instance;
    }

    public static void applyHorizontalAlignment(TextView textView, HorizontalAlignment horizontalAlignment, RenderArgs renderArgs) {
        horizontalAlignment = RendererUtil.computeHorizontalAlignment(horizontalAlignment, renderArgs);
        textView.setTextAlignment(TextRendererUtil.getTextAlignment(horizontalAlignment));
    }

    public static void applyTextSize(TextView textView, HostConfig hostConfig, TextStyle textStyle, FontType fontType, TextSize textSize, RenderArgs renderArgs) {
        textSize = TextRendererUtil.computeTextSize(hostConfig, textStyle, textSize, renderArgs);
        fontType = TextRendererUtil.computeFontType(hostConfig, textStyle, fontType, renderArgs);
        textView.setTextSize((float)TextRendererUtil.getTextSize(fontType, textSize, hostConfig));
    }

    public static void applyAccessibilityHeading(@NonNull TextView textView, final @Nullable TextStyle textStyle) {
        ViewCompat.setAccessibilityDelegate((View)textView, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
                super.onInitializeAccessibilityNodeInfo(host, info);
                info.setHeading(textStyle == TextStyle.Heading);
            }
        });
    }

    public static void applyTextFormat(TextView textView, HostConfig hostConfig, TextStyle textStyle, FontType type, TextWeight textWeight, RenderArgs renderArgs) {
        type = TextRendererUtil.computeFontType(hostConfig, textStyle, type, renderArgs);
        Typeface typeface = TextRendererUtil.getTextFormat(hostConfig, type, (textWeight = TextRendererUtil.computeTextWeight(hostConfig, textStyle, textWeight, renderArgs)) == TextWeight.Lighter);
        if (Build.VERSION.SDK_INT >= 28) {
            Typeface weightedTypeface = Typeface.create((Typeface)typeface, (int)((int)hostConfig.GetFontWeight(type, textWeight)), (boolean)false);
            textView.setTypeface(weightedTypeface);
        } else if (textWeight == TextWeight.Bolder) {
            textView.setTypeface(typeface, 1);
        } else {
            textView.setTypeface(typeface);
        }
    }

    public static void applyTextColor(TextView textView, HostConfig hostConfig, TextStyle textStyle, ForegroundColor foregroundColor, Boolean isSubtle, ContainerStyle containerStyle, RenderArgs renderArgs) {
        foregroundColor = TextRendererUtil.computeTextColor(hostConfig, textStyle, foregroundColor, renderArgs);
        isSubtle = TextRendererUtil.computeIsSubtle(hostConfig, textStyle, isSubtle, renderArgs);
        textView.setTextColor(TextBlockRenderer.getColor(TextRendererUtil.getTextColor(foregroundColor, hostConfig, isSubtle, containerStyle)));
    }

    private void applyAccessibilityProperties(final TextView textView, Context context, RendererUtil.SpecialTextHandleResult textHandleResult) {
        if (Build.VERSION.SDK_INT >= 28) {
            textView.setScreenReaderFocusable(true);
        }
        textView.setImportantForAccessibility(1);
        if (textHandleResult.getHasLinks()) {
            textView.setMovementMethod(LinkMovementMethod.getInstance());
            if (textHandleResult.isALink()) {
                textView.setOnKeyListener((View.OnKeyListener)new SingleLinkOnKeyListener((Spannable)new SpannableString(textHandleResult.getHtmlString())));
            }
        }
        final AccessibilityManager am = (AccessibilityManager)context.getSystemService("accessibility");
        am.addAccessibilityStateChangeListener(new AccessibilityManager.AccessibilityStateChangeListener(){

            public void onAccessibilityStateChanged(boolean b) {
                boolean isTalkBackEnabled = TextBlockRenderer.this.isTalkBackEnabled(am);
                if (b && isTalkBackEnabled) {
                    textView.setFocusable(true);
                } else {
                    textView.setFocusable(false);
                }
            }
        });
        textView.setFocusable(this.isTalkBackEnabled(am));
    }

    @Override
    @Nullable
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) throws Exception {
        TextBlock textBlock = Util.castTo(baseCardElement, TextBlock.class);
        TextView textView = new TextView(context);
        textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        textView.setTag((Object)new TagContent(textBlock));
        DateTimeParser parser = new DateTimeParser(textBlock.GetLanguage());
        String textWithFormattedDates = parser.GenerateString(textBlock.GetTextForDateParsing());
        RendererUtil.SpecialTextHandleResult textHandleResult = RendererUtil.handleSpecialTextAndQueryLinks(textWithFormattedDates);
        CharSequence htmlString = textHandleResult.getHtmlString();
        textView.setText(htmlString);
        textView.setEllipsize(TextUtils.TruncateAt.END);
        textView.setOnTouchListener((View.OnTouchListener)new TouchTextView((Spannable)new SpannableString(htmlString)));
        textView.setHorizontallyScrolling(false);
        TextBlockRenderer.applyTextFormat(textView, hostConfig, textBlock.GetStyle(), textBlock.GetFontType(), textBlock.GetTextWeight(), renderArgs);
        TextBlockRenderer.applyTextSize(textView, hostConfig, textBlock.GetStyle(), textBlock.GetFontType(), textBlock.GetTextSize(), renderArgs);
        TextBlockRenderer.applyTextColor(textView, hostConfig, textBlock.GetStyle(), textBlock.GetTextColor(), textBlock.GetIsSubtle(), renderArgs.getContainerStyle(), renderArgs);
        TextBlockRenderer.applyHorizontalAlignment(textView, textBlock.GetHorizontalAlignment(), renderArgs);
        TextBlockRenderer.applyAccessibilityHeading(textView, textBlock.GetStyle());
        this.applyAccessibilityProperties(textView, context, textHandleResult);
        int maxLines = (int)textBlock.GetMaxLines();
        if (maxLines > 0 && textBlock.GetWrap()) {
            textView.setMaxLines(maxLines);
        } else if (!textBlock.GetWrap()) {
            textView.setMaxLines(1);
        }
        viewGroup.addView((View)textView);
        return textView;
    }

    private boolean isTalkBackEnabled(AccessibilityManager am) {
        if (am.isEnabled()) {
            List talkBackInfo = am.getEnabledAccessibilityServiceList(1);
            return !talkBackInfo.isEmpty();
        }
        return false;
    }

    static class TouchTextView
    implements View.OnTouchListener {
        Spannable spannable;

        public TouchTextView(Spannable spannable) {
            this.spannable = spannable;
        }

        public boolean onTouch(View v, MotionEvent event) {
            int action = event.getAction();
            if (!(v instanceof TextView)) {
                return false;
            }
            TextView textView = (TextView)v;
            if (action == 1 || action == 0) {
                int line;
                int x = (int)event.getX();
                int y = (int)event.getY();
                x -= textView.getTotalPaddingLeft();
                y -= textView.getTotalPaddingTop();
                Layout layout2 = textView.getLayout();
                int off = layout2.getOffsetForHorizontal(line = layout2.getLineForVertical(y += textView.getScrollY()), (float)(x += textView.getScrollX()));
                URLSpan[] link = (URLSpan[])this.spannable.getSpans(off, off, URLSpan.class);
                if (link.length != 0) {
                    if (action == 1) {
                        link[0].onClick((View)textView);
                    } else if (action == 0) {
                        Selection.setSelection((Spannable)this.spannable, (int)this.spannable.getSpanStart((Object)link[0]), (int)this.spannable.getSpanEnd((Object)link[0]));
                    }
                    return true;
                }
                Selection.removeSelection((Spannable)this.spannable);
            }
            return false;
        }
    }

    static class SingleLinkOnKeyListener
    implements View.OnKeyListener {
        Spannable spannable;
        URLSpan urlSpan;

        public SingleLinkOnKeyListener(Spannable spannable) {
            this.spannable = spannable;
            URLSpan[] spans = (URLSpan[])spannable.getSpans(0, 1, URLSpan.class);
            this.urlSpan = spans[0];
        }

        public boolean onKey(View view, int i, KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 66) {
                this.urlSpan.onClick(view);
            }
            return false;
        }
    }
}

