/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.fragment.app.FragmentManager;
import com.google.android.flexbox.FlexboxLayout;
import io.adaptivecards.objectmodel.Badge;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.HorizontalAlignment;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.layout.BadgeView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JJ\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\u00020\u0016*\u0004\u0018\u00010\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lio/adaptivecards/renderer/readonly/BadgeRenderer;", "Lio/adaptivecards/renderer/BaseCardElementRenderer;", "()V", "render", "Landroid/view/View;", "renderedCard", "Lio/adaptivecards/renderer/RenderedAdaptiveCard;", "context", "Landroid/content/Context;", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "viewGroup", "Landroid/view/ViewGroup;", "baseCardElement", "Lio/adaptivecards/objectmodel/BaseCardElement;", "cardActionHandler", "Lio/adaptivecards/renderer/actionhandler/ICardActionHandler;", "hostConfig", "Lio/adaptivecards/objectmodel/HostConfig;", "renderArgs", "Lio/adaptivecards/renderer/RenderArgs;", "getLinearLayoutGravity", "", "Lio/adaptivecards/objectmodel/HorizontalAlignment;", "adaptivecards_release"})
public final class BadgeRenderer
extends BaseCardElementRenderer {
    @NotNull
    public static final BadgeRenderer INSTANCE = new BadgeRenderer();

    private BadgeRenderer() {
    }

    @Override
    @NotNull
    public View render(@NotNull RenderedAdaptiveCard renderedCard, @NotNull Context context, @NotNull FragmentManager fragmentManager, @NotNull ViewGroup viewGroup, @NotNull BaseCardElement baseCardElement, @Nullable ICardActionHandler cardActionHandler, @NotNull HostConfig hostConfig, @NotNull RenderArgs renderArgs) {
        Intrinsics.checkNotNullParameter((Object)renderedCard, (String)"renderedCard");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"viewGroup");
        Intrinsics.checkNotNullParameter((Object)baseCardElement, (String)"baseCardElement");
        Intrinsics.checkNotNullParameter((Object)hostConfig, (String)"hostConfig");
        Intrinsics.checkNotNullParameter((Object)renderArgs, (String)"renderArgs");
        Badge badge = Util.castTo(baseCardElement, Badge.class);
        Intrinsics.checkNotNullExpressionValue((Object)badge, (String)"badge");
        BadgeView badgeView = new BadgeView(context, badge, renderedCard, hostConfig);
        badgeView.setTag(new TagContent(badge));
        badgeView.setLayoutParams((ViewGroup.LayoutParams)new FlexboxLayout.LayoutParams(-2, -2));
        if (viewGroup instanceof LinearLayout) {
            LinearLayout.LayoutParams linearLayoutParams = new LinearLayout.LayoutParams(-2, -2);
            linearLayoutParams.gravity = this.getLinearLayoutGravity(badge.GetHorizontalAlignment());
            viewGroup.addView((View)badgeView, (ViewGroup.LayoutParams)linearLayoutParams);
        } else {
            viewGroup.addView((View)badgeView);
        }
        return (View)badgeView;
    }

    private final int getLinearLayoutGravity(HorizontalAlignment $this$getLinearLayoutGravity) {
        int n;
        HorizontalAlignment horizontalAlignment = $this$getLinearLayoutGravity;
        if (horizontalAlignment != null) {
            HorizontalAlignment it = horizontalAlignment;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[$this$getLinearLayoutGravity.ordinal()]) {
                case 1: {
                    n = 0x800005;
                    break;
                }
                case 2: {
                    n = 17;
                    break;
                }
                default: {
                    n = 0x800003;
                }
            }
        } else {
            HorizontalAlignment $this$getLinearLayoutGravity_u24lambda_u2d1 = $this$getLinearLayoutGravity;
            boolean bl = false;
            n = 0x800003;
        }
        return n;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HorizontalAlignment.values().length];
            nArray[HorizontalAlignment.Right.ordinal()] = 1;
            nArray[HorizontalAlignment.Center.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

